/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.net.command;

import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.command.CommandType;
import com.sap.jvm.profiling.impl.core.command.CommandImpl;
import com.sap.jvm.profiling.net.command.EnableNetworkTraceCommand;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class EnableNetworkTraceCommandImpl
extends CommandImpl
implements EnableNetworkTraceCommand {
    private final ThreadFilter threadFilter;
    private final boolean resolveAllHosts;

    EnableNetworkTraceCommandImpl(ThreadFilter threadFilter, boolean resolveAllHosts) {
        this.threadFilter = threadFilter;
        this.resolveAllHosts = resolveAllHosts;
    }

    @Override
    public void print(PrintStream stream) {
        stream.print("Enable network trace (threadFilter: ");
        stream.print(this.threadFilter == null ? "**" : this.threadFilter.asString());
        stream.print(", resolve all hosts: " + this.resolveAllHosts);
        stream.println(')');
    }

    @Override
    protected void writeToStreamImpl(DataOutputStream stream) throws IOException {
        this.writeUint16(stream, 51);
        stream.writeLong(this.getId());
        this.writeNewThreadFilter(stream, this.threadFilter);
        stream.writeBoolean(this.resolveAllHosts);
    }

    @Override
    public CommandType getType() {
        return CommandType.ENABLE_NETWORK_TRACE;
    }
}

