/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.net.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.impl.core.type.IpAddressV4Impl;
import com.sap.jvm.profiling.impl.core.type.IpAddressV6Impl;
import com.sap.jvm.profiling.impl.net.event.NetworkTraceUtils;
import com.sap.jvm.profiling.impl.net.event.SocketTransferEventBase;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.net.event.DirectedSocketTransferEvent;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public abstract class DirectedSocketTransferEventBase
extends SocketTransferEventBase
implements DirectedSocketTransferEvent {
    private IpAddress remoteAddress;
    private char remotePort;

    protected DirectedSocketTransferEventBase(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        super(reader, mapInfo);
    }

    @Override
    public IpAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public char getRemotePort() {
        return this.remotePort;
    }

    @Override
    public boolean isIPv6() {
        return !this.isIPv4();
    }

    @Override
    protected void readAdditionalAttributes(ResourceReader reader) throws IOException {
        this.remoteAddress = this.isIPv4() ? IpAddressV4Impl.read(reader) : IpAddressV6Impl.read(reader);
        this.remotePort = NetworkTraceUtils.readPort(reader);
    }

    @Override
    protected void writeAdditionalAttributes(ResourceWriter writer) throws IOException {
        this.remoteAddress.write(writer);
        NetworkTraceUtils.writePort(writer, this.remotePort);
    }

    @Override
    protected void printAdditionalAttributes(ProfilingPrintStream stream) {
        stream.println("Remote IP address: " + this.remoteAddress.getAddress());
        stream.println("Remote port      : " + Integer.toString(this.remotePort));
    }
}

