/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.net.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.type.IpAddressV4Impl;
import com.sap.jvm.profiling.impl.core.type.IpAddressV6Impl;
import com.sap.jvm.profiling.net.event.HostLookupEvent;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public abstract class HostLookupEventBase
extends ProfilingPacketImpl
implements HostLookupEvent {
    private final UTF8String hostname;
    private final IpAddress address;

    protected HostLookupEventBase(ResourceReader reader) throws IOException {
        this.hostname = reader.readUTF();
        this.address = this.isIPv4() ? IpAddressV4Impl.read(reader) : IpAddressV6Impl.read(reader);
    }

    protected HostLookupEventBase(UTF8String hostname, IpAddress address) {
        this.hostname = hostname;
        this.address = address;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.HOST_LOOKUP_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.println("Host name       : " + this.getHostName());
        stream.println("IP address      : " + this.address.getAddress());
    }

    @Override
    public UTF8String getHostName() {
        return this.hostname;
    }

    @Override
    public IpAddress getAddress() {
        return this.address;
    }

    @Override
    public boolean isIPv6() {
        return !this.isIPv4();
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket(this.isIPv4() ? (short)415 : 416);
        writer.writeUTF(this.getHostName());
        this.address.write(writer);
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "host lookup event";
    }
}

