/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.net.event;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.util.Arrays;

public class NetworkTraceUtils {
    public static final int IP_V6_ADDRESS_SIZE = 16;
    private static final long IP_V4_MAPPED_IP_V6_MASK = -4294967296L;
    private static final long IP_V4_MAPPED_IP_V6_VALUE = 0xFFFF00000000L;
    private static final byte[] ANY_IPV6_ADDRESS = new byte[16];

    public static String getIPv4AddressText(int address) {
        if (address == 0) {
            return "0.0.0.0";
        }
        return (address >> 24 & 0xFF) + "." + (address >> 16 & 0xFF) + "." + (address >> 8 & 0xFF) + "." + (address >> 0 & 0xFF);
    }

    public static String getIPv6AddressText(byte[] address) {
        if (Arrays.equals(ANY_IPV6_ADDRESS, address)) {
            return "::";
        }
        StringBuffer sb = new StringBuffer(39);
        for (int i = 0; i < 8; ++i) {
            sb.append(Integer.toHexString(address[i << 1] << 8 & 0xFF00 | address[(i << 1) + 1] & 0xFF));
            if (i >= 7) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    public static String getIPv6AddressText(long networkPrefix, long hostAddress) {
        if (networkPrefix == 0L && hostAddress == 0L) {
            return "::";
        }
        if (NetworkTraceUtils.isIPv4MappedIPv6Address(networkPrefix, hostAddress)) {
            return "::ffff:" + NetworkTraceUtils.getIPv4AddressText((int)hostAddress);
        }
        StringBuffer sb = new StringBuffer(39);
        sb.append(Long.toHexString(networkPrefix >> 48 & 0xFFFFL));
        sb.append(":");
        sb.append(Long.toHexString(networkPrefix >> 32 & 0xFFFFL));
        sb.append(":");
        sb.append(Long.toHexString(networkPrefix >> 16 & 0xFFFFL));
        sb.append(":");
        sb.append(Long.toHexString(networkPrefix >> 0 & 0xFFFFL));
        sb.append(":");
        sb.append(Long.toHexString(hostAddress >> 48 & 0xFFFFL));
        sb.append(":");
        sb.append(Long.toHexString(hostAddress >> 32 & 0xFFFFL));
        sb.append(":");
        sb.append(Long.toHexString(hostAddress >> 16 & 0xFFFFL));
        sb.append(":");
        sb.append(Long.toHexString(hostAddress >> 0 & 0xFFFFL));
        return sb.toString();
    }

    public static boolean isIPv4MappedIPv6Address(long networkPrefix, long hostAddress) {
        return networkPrefix == 0L && (hostAddress & 0xFFFFFFFF00000000L) == 0xFFFF00000000L;
    }

    public static byte[] readIPv6Address(ResourceReader reader) throws IOException {
        byte[] result = new byte[16];
        for (int i = 0; i < result.length; ++i) {
            result[i] = reader.readInt8();
        }
        return result;
    }

    public static void writeIPv6Address(ResourceWriter writer, byte[] address) throws IOException {
        assert (address.length == 16);
        for (int i = 0; i < address.length; ++i) {
            writer.writeInt8(address[i]);
        }
    }

    public static char readPort(ResourceReader reader) throws IOException {
        return reader.readUint16();
    }

    public static void writePort(ResourceWriter writer, char port) throws IOException {
        writer.writeUint16(port);
    }
}

