/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.net.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.type.IpAddressV4Impl;
import com.sap.jvm.profiling.impl.core.type.IpAddressV6Impl;
import com.sap.jvm.profiling.net.event.NetworkLookupEvent;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public abstract class ReverseHostLookupEventBase
extends ProfilingPacketImpl
implements NetworkLookupEvent {
    private final UTF8String hostname;
    private final IpAddress address;
    private final long duration;

    protected ReverseHostLookupEventBase(ResourceReader reader) throws IOException {
        this.hostname = this.hasHostName() ? reader.readUTF() : null;
        this.address = this.isIPv4() ? IpAddressV4Impl.read(reader) : IpAddressV6Impl.read(reader);
        this.duration = reader.peekInt64();
    }

    protected ReverseHostLookupEventBase(UTF8String hostname, IpAddress address, long duration) {
        this.hostname = hostname;
        this.address = address;
        this.duration = duration;
    }

    @Override
    public ProfilingPacketType getType() {
        return this.hasHostName() ? ProfilingPacketType.REVERSE_HOST_LOOKUP_FAILURE_EVENT : ProfilingPacketType.REVERSE_HOST_LOOKUP_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        if (this.hasHostName()) {
            stream.println("Host name       : " + this.getHostName());
        }
        stream.println("IP address      : " + this.address.getAddress());
        stream.formatln("Duration         : %d", this.getDuration());
    }

    public UTF8String getHostName() {
        return this.hostname;
    }

    @Override
    public IpAddress getAddress() {
        return this.address;
    }

    public long getDuration() {
        return this.duration;
    }

    protected abstract boolean hasHostName();

    @Override
    public boolean isIPv6() {
        return !this.isIPv4();
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket(this.hasHostName() ? (this.isIPv4() ? (short)780 : 781) : (this.isIPv4() ? (short)782 : 783));
        if (this.hasHostName()) {
            writer.writeUTF(this.getHostName());
        }
        this.address.write(writer);
        writer.writeInt64(this.getDuration());
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "reverse host lookup " + (this.getHostName() == null ? "failure " : "") + "event";
    }
}

