/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.net.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.net.event.NetworkTraceUtils;
import com.sap.jvm.profiling.net.event.ServiceDiscoveryEvent;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class ServiceDiscoveryEventImpl
extends ProfilingPacketImpl
implements ServiceDiscoveryEvent {
    private final String name;
    private final char port;
    private final boolean isTcp;

    public ServiceDiscoveryEventImpl(ResourceReader reader) throws IOException {
        this.name = reader.readUTF().toString();
        this.port = NetworkTraceUtils.readPort(reader);
        this.isTcp = reader.readBoolean();
    }

    public ServiceDiscoveryEventImpl(String name, char port, boolean isTcp) {
        this.name = name;
        this.port = port;
        this.isTcp = isTcp;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.NETWORK_SERVICE_DISCOVERY_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.println("Service name : " + this.getServiceName());
        stream.println("Service port : " + Integer.toString(this.port));
        stream.println("Socket type  : " + (this.isTcp ? "TCP/IP" : "UDP/IP"));
    }

    @Override
    public String getServiceName() {
        return this.name;
    }

    @Override
    public char getPort() {
        return this.port;
    }

    @Override
    public boolean isStream() {
        return this.isTcp;
    }

    @Override
    public boolean isDatagram() {
        return !this.isStream();
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)417);
        writer.writeStringSafe(this.getServiceName());
        NetworkTraceUtils.writePort(writer, this.port);
        writer.writeBoolean(this.isTcp);
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "service discovery event";
    }
}

