/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.net.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.type.IpAddressV4Impl;
import com.sap.jvm.profiling.impl.core.type.IpAddressV6Impl;
import com.sap.jvm.profiling.impl.net.event.NetworkTraceUtils;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.net.event.SocketBindEvent;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public abstract class SocketBindEventBase
extends ProfilingPacketImpl
implements SocketBindEvent {
    private final int fd;
    private final long id;
    private final char threadIndex;
    private final int stackTraceIndex;
    private final long timestamp;
    private final IpAddress localAddress;
    private final char localPort;

    protected SocketBindEventBase(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.threadIndex = reader.readUint16();
        this.stackTraceIndex = reader.readStackTraceIndex();
        this.timestamp = reader.readInt64();
        this.fd = reader.readInt32();
        this.localAddress = this.isIPv4() ? IpAddressV4Impl.read(reader) : IpAddressV6Impl.read(reader);
        this.localPort = NetworkTraceUtils.readPort(reader);
        long tmp = reader.readUniqueSocketId();
        this.id = tmp == -1L ? mapInfo.getUniqueSocketId(this.fd) : tmp;
        mapInfo.addSocketBindEvent(this);
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.SOCKET_BIND_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("File descriptor : %d", this.getFd());
        stream.formatln("Id              : %d", this.getId());
        stream.formatln("Thread          : %*T", this.getThreadIndex());
        stream.formatln("Stack trace     : %*S", this.getStackTraceIndex());
        stream.formatln("Timestamp       : %d", this.getTimeStamp());
        stream.println("IP version      : " + (this.isIPv4() ? "4" : "6"));
        stream.println("Local IP address: " + this.localAddress.getAddress());
        stream.println("Local port      : " + Integer.toString(this.localPort));
    }

    @Override
    public int getFd() {
        return this.fd;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public int getStackTraceIndex() {
        return this.stackTraceIndex;
    }

    @Override
    public long getTimeStamp() {
        return this.timestamp;
    }

    @Override
    public boolean isIPv6() {
        return !this.isIPv4();
    }

    @Override
    public IpAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public char getLocalPort() {
        return this.localPort;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket(this.isIPv4() ? (short)635 : 636);
        writer.writeUint16(this.getThreadIndex());
        writer.writeInt32(this.getStackTraceIndex());
        writer.writeInt64(this.getTimeStamp());
        writer.writeInt32(this.getFd());
        this.localAddress.write(writer);
        NetworkTraceUtils.writePort(writer, this.localPort);
        writer.writeInt64(this.getId());
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "socket bind event";
    }
}

