/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.net.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.type.IpAddressV4Impl;
import com.sap.jvm.profiling.impl.core.type.IpAddressV6Impl;
import com.sap.jvm.profiling.impl.net.event.NetworkTraceUtils;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.net.event.SocketConnectEvent;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public abstract class SocketConnectEventBase
extends ProfilingPacketImpl {
    private final int fd;
    private final long id;
    private final char threadIndex;
    private final int stackTraceIndex;
    private final long timestamp;
    private final IpAddress localAddress;
    private final char localPort;
    private final IpAddress remoteAddress;
    private final char remotePort;
    private final long duration;
    private final UTF8String exception;
    private final UTF8String exceptionMessage;

    protected SocketConnectEventBase(ResourceReader reader, MappingInformation mapInfo, boolean isFailure) throws IOException {
        this.threadIndex = reader.readUint16();
        this.stackTraceIndex = reader.readStackTraceIndex();
        this.timestamp = reader.readInt64();
        this.fd = reader.readInt32();
        this.localAddress = this.isIPv4() ? IpAddressV4Impl.read(reader) : IpAddressV6Impl.read(reader);
        this.localPort = NetworkTraceUtils.readPort(reader);
        this.remoteAddress = this.isIPv4() ? IpAddressV4Impl.read(reader) : IpAddressV6Impl.read(reader);
        this.remotePort = NetworkTraceUtils.readPort(reader);
        this.duration = reader.readInt64();
        long tmp = reader.readUniqueSocketId();
        this.id = tmp == -1L ? mapInfo.getUniqueSocketId(this.fd) : tmp;
        this.exception = isFailure ? reader.readUTF() : null;
        UTF8String uTF8String = this.exceptionMessage = isFailure ? reader.readUTF() : null;
        if (!isFailure) {
            mapInfo.addSocketConnectEvent((SocketConnectEvent)((Object)this));
        }
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.SOCKET_CONNECT_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("File descriptor  : %d", this.getFd());
        stream.formatln("Id               : %d", this.getId());
        stream.formatln("Thread           : %*T", this.getThreadIndex());
        stream.formatln("Stack trace      : %*S", this.getStackTraceIndex());
        stream.formatln("Timestamp        : %d", this.getTimeStamp());
        stream.println("IP version       : " + (this.isIPv4() ? "4" : "6"));
        stream.println("Local IP address : " + this.localAddress.getAddress());
        stream.println("Local port       : " + Integer.toString(this.localPort));
        stream.println("Remote IP address: " + this.remoteAddress.getAddress());
        stream.println("Remote port      : " + Integer.toString(this.remotePort));
        stream.formatln("Duration         : %d", this.duration);
        if (this.exception != null) {
            stream.println("Exception        : " + this.exception);
            stream.println("Exception Message: " + this.exceptionMessage);
        }
    }

    public int getFd() {
        return this.fd;
    }

    public long getId() {
        return this.id;
    }

    public char getThreadIndex() {
        return this.threadIndex;
    }

    public int getStackTraceIndex() {
        return this.stackTraceIndex;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public abstract boolean isIPv4();

    public boolean isIPv6() {
        return !this.isIPv4();
    }

    public IpAddress getLocalAddress() {
        return this.localAddress;
    }

    public char getLocalPort() {
        return this.localPort;
    }

    public IpAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public char getRemotePort() {
        return this.remotePort;
    }

    public long getDuration() {
        return this.duration;
    }

    public UTF8String getException() {
        return this.exception;
    }

    public UTF8String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket(this.exception != null ? (this.isIPv4() ? (short)784 : 785) : (this.isIPv4() ? (short)639 : 640));
        writer.writeUint16(this.getThreadIndex());
        writer.writeInt32(this.getStackTraceIndex());
        writer.writeInt64(this.getTimeStamp());
        writer.writeInt32(this.getFd());
        this.localAddress.write(writer);
        NetworkTraceUtils.writePort(writer, this.localPort);
        this.remoteAddress.write(writer);
        NetworkTraceUtils.writePort(writer, this.remotePort);
        writer.writeInt64(this.duration);
        writer.writeInt64(this.getId());
        if (this.exception != null) {
            writer.writeUTF(this.exception);
            writer.writeUTF(this.exceptionMessage);
        }
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "socket connect event";
    }
}

