/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.net.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.net.event.SocketTransferEvent;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public abstract class SocketTransferEventBase
extends ProfilingPacketImpl
implements SocketTransferEvent {
    private final int fd;
    private final long id;
    private final char threadIndex;
    private final int stackTraceIndex;
    private final long timestamp;
    private final int tranferredBytes;
    private final long duration;

    protected SocketTransferEventBase(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.threadIndex = reader.readUint16();
        this.stackTraceIndex = reader.readStackTraceIndex();
        this.timestamp = reader.readInt64();
        this.fd = reader.readInt32();
        this.tranferredBytes = reader.readInt32();
        this.duration = reader.readInt64();
        this.readAdditionalAttributes(reader);
        long tmp = reader.readUniqueSocketId();
        this.id = tmp == -1L ? mapInfo.getUniqueSocketId(this.fd) : tmp;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("File descriptor  : %d", this.getFd());
        stream.formatln("Id               : %d", this.getId());
        stream.formatln("Thread           : %*T", this.getThreadIndex());
        stream.formatln("Stack trace      : %*S", this.getStackTraceIndex());
        stream.formatln("Timestamp        : %d", this.getTimeStamp());
        stream.formatln("Transferred bytes: %d", this.getNrOfTransferredBytes());
        stream.formatln("Duration         : %d", this.getDuration());
        this.printAdditionalAttributes(stream);
    }

    @Override
    public int getFd() {
        return this.fd;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public int getStackTraceIndex() {
        return this.stackTraceIndex;
    }

    @Override
    public long getTimeStamp() {
        return this.timestamp;
    }

    @Override
    public int getNrOfTransferredBytes() {
        return this.tranferredBytes;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket(this.getPacketType());
        writer.writeUint16(this.getThreadIndex());
        writer.writeInt32(this.getStackTraceIndex());
        writer.writeInt64(this.getTimeStamp());
        writer.writeInt32(this.getFd());
        writer.writeInt32(this.getNrOfTransferredBytes());
        writer.writeInt64(this.getDuration());
        this.writeAdditionalAttributes(writer);
        writer.writeInt64(this.getId());
        writer.finalizePacket();
    }

    protected abstract short getPacketType();

    protected void readAdditionalAttributes(ResourceReader reader) throws IOException {
    }

    protected void writeAdditionalAttributes(ResourceWriter writer) throws IOException {
    }

    protected void printAdditionalAttributes(ProfilingPrintStream stream) {
    }
}

