/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.net.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.net.command.NetworkTraceConfiguration;
import com.sap.jvm.profiling.net.event.NetworkEventHandler;
import com.sap.jvm.profiling.net.response.EnableNetworkTraceResponse;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class EnableNetworkTraceResponseImpl
extends ResponseImpl
implements EnableNetworkTraceResponse {
    private final NetworkTraceConfiguration configuration = new NetworkTraceConfiguration();

    public static EnableNetworkTraceResponseImpl read(ResourceReader reader, NetworkEventHandler[] handlers) throws IOException {
        EnableNetworkTraceResponseImpl retValue = new EnableNetworkTraceResponseImpl(reader);
        for (NetworkEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    private EnableNetworkTraceResponseImpl(ResourceReader reader) throws IOException {
        super("enable network trace response", reader);
        if (reader.hasNext()) {
            this.configuration.setThreadFilter(reader.readNewThreadFilter());
            this.configuration.setResolveAllHosts(reader.hasNext() ? reader.readBoolean() : false);
        }
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1049);
        this.writeInternal(writer);
        writer.writeNewThreadFilter(this.configuration.getThreadFilter());
        writer.writeBoolean(this.configuration.isResolveAllHosts());
        writer.finalizePacket();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ENABLE_NETWORK_TRACE_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
        stream.formatln("Thread filter         : %s", this.configuration.getThreadFilter().asString());
        stream.println("Resolve all hosts     : " + this.configuration.isResolveAllHosts());
    }

    @Override
    public NetworkTraceConfiguration getConfiguration() {
        return this.configuration;
    }
}

