/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.reader;

import com.sap.jvm.profiling.alert.event.AlertEventHandler;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.ProfilingVersion;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.event.HeartBeatEventHandler;
import com.sap.jvm.profiling.core.event.SnapshotMarkerHandler;
import com.sap.jvm.profiling.core.event.TestContentEventHandler;
import com.sap.jvm.profiling.core.event.ThreadAnnotationChanged;
import com.sap.jvm.profiling.core.event.ThreadEventHandler;
import com.sap.jvm.profiling.core.event.ThreadNameChanged;
import com.sap.jvm.profiling.core.event.ThreadStarted;
import com.sap.jvm.profiling.core.event.ThreadStopped;
import com.sap.jvm.profiling.core.event.ThreadUserChanged;
import com.sap.jvm.profiling.core.type.FileManager;
import com.sap.jvm.profiling.core.type.SocketManager;
import com.sap.jvm.profiling.core.type.ThreadManager;
import com.sap.jvm.profiling.exception.event.ExceptionEventHandler;
import com.sap.jvm.profiling.impl.alert.event.ErrorEventImpl;
import com.sap.jvm.profiling.impl.alert.event.OutOfMemoryEventImpl;
import com.sap.jvm.profiling.impl.alert.event.SpuriousWackupEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StackoverflowEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StartAllocationAnalysisEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StartClassStatisticAnalysisEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StartDebuggingEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StartFileAnalysisEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StartGarbageCollectionAnalysisEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StartHeapDumpAnalysisEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StartMethodParameterAnalysisEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StartNetworkIoAnalysisEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StartPerformanceHotspotAnalysisEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StartProfilingEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StartSynchronizationAnalysisEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StopAllocationAnalysisEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StopClassStatisticAnalysisEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StopDebuggingEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StopFileAnalysisEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StopGarbageCollectionAnalysisEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StopHeapDumpAnalysisEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StopMethodParameterAnalysisEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StopNetworkIoAnalysisEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StopPerformanceHotspotAnalysisEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StopProfilingEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StopSynchronizationAnalysisEventImpl;
import com.sap.jvm.profiling.impl.alert.event.StorableAlertImpl;
import com.sap.jvm.profiling.impl.alert.event.ThreadStopEventImpl;
import com.sap.jvm.profiling.impl.alert.event.TraceEventErrorImpl;
import com.sap.jvm.profiling.impl.alert.event.TraceEventInformationImpl;
import com.sap.jvm.profiling.impl.alert.event.TraceEventWarningImpl;
import com.sap.jvm.profiling.impl.alert.response.DisableAlertResponseImpl;
import com.sap.jvm.profiling.impl.alert.response.EnableAlertResponseImpl;
import com.sap.jvm.profiling.impl.control.response.FlushResponseImpl;
import com.sap.jvm.profiling.impl.control.response.JvmProfForwardResponseImpl;
import com.sap.jvm.profiling.impl.control.response.JvmProfStartProfilingResponseImpl;
import com.sap.jvm.profiling.impl.control.response.PauseTracingResponseImpl;
import com.sap.jvm.profiling.impl.control.response.ProfilingTraceInfoResponseImpl;
import com.sap.jvm.profiling.impl.control.response.ResumeTracingResponseImpl;
import com.sap.jvm.profiling.impl.control.response.ResumeVMResponseImpl;
import com.sap.jvm.profiling.impl.control.response.StopProfilingResponseImpl;
import com.sap.jvm.profiling.impl.core.BookmarkImpl;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.impl.core.ThreadInfoImpl;
import com.sap.jvm.profiling.impl.core.event.DefaultTimeZoneSetEventImpl;
import com.sap.jvm.profiling.impl.core.event.HeartBeatEventImpl;
import com.sap.jvm.profiling.impl.core.event.ObjectIdentificationEventImpl;
import com.sap.jvm.profiling.impl.core.event.ProfilingBufferDumpedImpl;
import com.sap.jvm.profiling.impl.core.event.SystemInfoImpl;
import com.sap.jvm.profiling.impl.core.event.TestContentEventImpl;
import com.sap.jvm.profiling.impl.core.event.ThreadAnnotationChangedImpl;
import com.sap.jvm.profiling.impl.core.event.ThreadNameChangedImpl;
import com.sap.jvm.profiling.impl.core.event.ThreadStartedImpl;
import com.sap.jvm.profiling.impl.core.event.ThreadStoppedImpl;
import com.sap.jvm.profiling.impl.core.event.ThreadUserChangedImpl;
import com.sap.jvm.profiling.impl.core.event.ThreadWithAnnotationsStartedImpl;
import com.sap.jvm.profiling.impl.core.response.ChangeHeartBeatIntervalResponseImpl;
import com.sap.jvm.profiling.impl.core.response.DisableHeartBeatResponseImpl;
import com.sap.jvm.profiling.impl.core.response.EnableHeartBeatResponseImpl;
import com.sap.jvm.profiling.impl.core.response.ExtensionCommandResponseImpl;
import com.sap.jvm.profiling.impl.core.response.SnapshotMarkerResponseImpl;
import com.sap.jvm.profiling.impl.exception.event.ExceptionThrownEventImpl;
import com.sap.jvm.profiling.impl.exception.response.DisableExceptionTraceResponseImpl;
import com.sap.jvm.profiling.impl.exception.response.EnableExceptionTraceResponseImpl;
import com.sap.jvm.profiling.impl.io.event.FileCloseEventImpl;
import com.sap.jvm.profiling.impl.io.event.FileNotFoundEventImpl;
import com.sap.jvm.profiling.impl.io.event.FileOpenEventImpl;
import com.sap.jvm.profiling.impl.io.event.FileReadEventImpl;
import com.sap.jvm.profiling.impl.io.event.FileWriteEventImpl;
import com.sap.jvm.profiling.impl.io.event.ZipFileCloseEventImpl;
import com.sap.jvm.profiling.impl.io.event.ZipFileOpenEventImpl;
import com.sap.jvm.profiling.impl.io.event.ZipFileReadEventImpl;
import com.sap.jvm.profiling.impl.io.response.DisableIOTraceResponseImpl;
import com.sap.jvm.profiling.impl.io.response.EnableIOTraceResponseImpl;
import com.sap.jvm.profiling.impl.jit.event.JitEventMethodCompilationImpl;
import com.sap.jvm.profiling.impl.jit.event.JitEventNMethodStateChangeImpl;
import com.sap.jvm.profiling.impl.jit.response.DisableJitEventsResponseImpl;
import com.sap.jvm.profiling.impl.jit.response.EnableJitEventsResponseImpl;
import com.sap.jvm.profiling.impl.memory.event.ArrayAllocationEventImpl;
import com.sap.jvm.profiling.impl.memory.event.ArrayAllocationNoIdEventImpl;
import com.sap.jvm.profiling.impl.memory.event.ArrayAllocationNoStackAndIdEventImpl;
import com.sap.jvm.profiling.impl.memory.event.ArrayAllocationNoStackEventImpl;
import com.sap.jvm.profiling.impl.memory.event.ArrayStackAllocationNoIdEventImpl;
import com.sap.jvm.profiling.impl.memory.event.ArrayStackAllocationNoStackAndIdEventImpl;
import com.sap.jvm.profiling.impl.memory.event.ClassStatisticDumpEndImpl;
import com.sap.jvm.profiling.impl.memory.event.ClassStatisticDumpStartImpl;
import com.sap.jvm.profiling.impl.memory.event.GcHistoryFileDumpEventImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticConcMarkSweepGcImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticG1GcImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticParallelGcImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticParallelNewGcImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticParallelOldGcImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticSerialGcImpl;
import com.sap.jvm.profiling.impl.memory.event.HprofDumpEndImpl;
import com.sap.jvm.profiling.impl.memory.event.HprofDumpSeekImpl;
import com.sap.jvm.profiling.impl.memory.event.HprofDumpStartImpl;
import com.sap.jvm.profiling.impl.memory.event.HprofDumpWriteAddonImpl;
import com.sap.jvm.profiling.impl.memory.event.HprofDumpWriteImpl;
import com.sap.jvm.profiling.impl.memory.event.MultiArrayAllocationNoIdEventImpl;
import com.sap.jvm.profiling.impl.memory.event.MultiArrayAllocationNoStackAndIdEventImpl;
import com.sap.jvm.profiling.impl.memory.event.MultiArrayStackAllocationNoIdEventImpl;
import com.sap.jvm.profiling.impl.memory.event.MultiArrayStackAllocationNoStackAndIdEventImpl;
import com.sap.jvm.profiling.impl.memory.event.MultiNonArrayAllocationNoIdEventImpl;
import com.sap.jvm.profiling.impl.memory.event.MultiNonArrayAllocationNoStackAndIdEventImpl;
import com.sap.jvm.profiling.impl.memory.event.MultiNonArrayStackAllocationNoIdEventImpl;
import com.sap.jvm.profiling.impl.memory.event.MultiNonArrayStackAllocationNoStackAndIdEventImpl;
import com.sap.jvm.profiling.impl.memory.event.NonArrayAllocationEventImpl;
import com.sap.jvm.profiling.impl.memory.event.NonArrayAllocationNoIdEventImpl;
import com.sap.jvm.profiling.impl.memory.event.NonArrayAllocationNoStackAndIdEventImpl;
import com.sap.jvm.profiling.impl.memory.event.NonArrayAllocationNoStackEventImpl;
import com.sap.jvm.profiling.impl.memory.event.NonArrayStackAllocationNoIdEventImpl;
import com.sap.jvm.profiling.impl.memory.event.NonArrayStackAllocationNoStackAndIdEventImpl;
import com.sap.jvm.profiling.impl.memory.event.ObjectDeathEventImpl;
import com.sap.jvm.profiling.impl.memory.event.OldGenClassStatisticImpl;
import com.sap.jvm.profiling.impl.memory.event.PermGenClassStatisticImpl;
import com.sap.jvm.profiling.impl.memory.event.YoungGenClassStatisticImpl;
import com.sap.jvm.profiling.impl.memory.response.ClassStatisticDumpResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.DisableAllocationMptTraceResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.DisableAllocationTraceResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.DisableGcStatisticResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.DisableObjectDeathTraceResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.DisableOldGenClassStatisticResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.DisablePermGenClassStatisticResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.DisableYoungGenClassStatisticResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.DumpClassStatisticEndResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.DumpClassStatisticStartResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.EnableAdaptiveAllocationMptTraceResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.EnableAdaptiveAllocationTraceResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.EnableAllocationMptTraceResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.EnableAllocationTraceResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.EnableGcStatisticResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.EnableObjectDeathTraceResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.EnableOldGenClassStatisticResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.EnablePermGenClassStatisticResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.EnableYoungGenClassStatisticResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.ForceGcResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.GcHistoryFileDumpEnableResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.HprofDumpResponseImpl;
import com.sap.jvm.profiling.impl.memory.response.WriteHprofHeapDumpResponseImpl;
import com.sap.jvm.profiling.impl.method.event.MethodCoverageEventImpl;
import com.sap.jvm.profiling.impl.method.event.MethodParameterApplyErrorEventImpl;
import com.sap.jvm.profiling.impl.method.event.MethodParameterEntryEventImpl;
import com.sap.jvm.profiling.impl.method.event.MethodParameterExitEventImpl;
import com.sap.jvm.profiling.impl.method.event.MethodParameterMethodToTraceEventImpl;
import com.sap.jvm.profiling.impl.method.event.MethodParameterNearMissEventImpl;
import com.sap.jvm.profiling.impl.method.event.MethodParameterRawTagHandling;
import com.sap.jvm.profiling.impl.method.event.MethodTraceEventImpl;
import com.sap.jvm.profiling.impl.method.event.TimeBasedSamplingEventImpl;
import com.sap.jvm.profiling.impl.method.event.TimeBasedSamplingInitialCpuTimesEventImpl;
import com.sap.jvm.profiling.impl.method.response.DisableMethodCoverageResponseImpl;
import com.sap.jvm.profiling.impl.method.response.DisableMethodParameterTraceResponseImpl;
import com.sap.jvm.profiling.impl.method.response.DisableMethodTraceResponseImpl;
import com.sap.jvm.profiling.impl.method.response.DisableTimeBasedSamplingMptResponseImpl;
import com.sap.jvm.profiling.impl.method.response.DisableTimeBasedSamplingResponseImpl;
import com.sap.jvm.profiling.impl.method.response.EnableMethodCoverageResponseImpl;
import com.sap.jvm.profiling.impl.method.response.EnableMethodParameterTraceResponseImpl;
import com.sap.jvm.profiling.impl.method.response.EnableMethodTraceResponseImpl;
import com.sap.jvm.profiling.impl.method.response.EnableTimeBasedSamplingMptResponseImpl;
import com.sap.jvm.profiling.impl.method.response.EnableTimeBasedSamplingResponseImpl;
import com.sap.jvm.profiling.impl.monitoring.event.MonitoringBoardDiffToInitialEventImpl;
import com.sap.jvm.profiling.impl.monitoring.event.MonitoringBoardDiffToPrevEventImpl;
import com.sap.jvm.profiling.impl.monitoring.event.MonitoringBoardInitialEventImpl;
import com.sap.jvm.profiling.impl.monitoring.response.DisableMonitoringBoardTraceResponseImpl;
import com.sap.jvm.profiling.impl.monitoring.response.EnableMonitoringBoardTraceResponseImpl;
import com.sap.jvm.profiling.impl.net.event.DatagramSocketOpenV4EventImpl;
import com.sap.jvm.profiling.impl.net.event.DatagramSocketOpenV6EventImpl;
import com.sap.jvm.profiling.impl.net.event.DirectedSocketPeekV4EventImpl;
import com.sap.jvm.profiling.impl.net.event.DirectedSocketPeekV6EventImpl;
import com.sap.jvm.profiling.impl.net.event.DirectedSocketReadV4EventImpl;
import com.sap.jvm.profiling.impl.net.event.DirectedSocketReadV6EventImpl;
import com.sap.jvm.profiling.impl.net.event.DirectedSocketWriteV4EventImpl;
import com.sap.jvm.profiling.impl.net.event.DirectedSocketWriteV6EventImpl;
import com.sap.jvm.profiling.impl.net.event.HostLookupV4EventImpl;
import com.sap.jvm.profiling.impl.net.event.HostLookupV6EventImpl;
import com.sap.jvm.profiling.impl.net.event.ReverseHostLookupFailureV4EventImpl;
import com.sap.jvm.profiling.impl.net.event.ReverseHostLookupV4EventImpl;
import com.sap.jvm.profiling.impl.net.event.ReverseHostLookupV6EventImpl;
import com.sap.jvm.profiling.impl.net.event.ServiceDiscoveryEventImpl;
import com.sap.jvm.profiling.impl.net.event.SocketAcceptV4EventImpl;
import com.sap.jvm.profiling.impl.net.event.SocketAcceptV6EventImpl;
import com.sap.jvm.profiling.impl.net.event.SocketBindV4EventImpl;
import com.sap.jvm.profiling.impl.net.event.SocketBindV6EventImpl;
import com.sap.jvm.profiling.impl.net.event.SocketCloseEventImpl;
import com.sap.jvm.profiling.impl.net.event.SocketConnectFailureV4EventImpl;
import com.sap.jvm.profiling.impl.net.event.SocketConnectFailureV6EventImpl;
import com.sap.jvm.profiling.impl.net.event.SocketConnectV4EventImpl;
import com.sap.jvm.profiling.impl.net.event.SocketConnectV6EventImpl;
import com.sap.jvm.profiling.impl.net.event.SocketPeekEventImpl;
import com.sap.jvm.profiling.impl.net.event.SocketReadEventImpl;
import com.sap.jvm.profiling.impl.net.event.SocketWriteEventImpl;
import com.sap.jvm.profiling.impl.net.event.StreamSocketOpenV4EventImpl;
import com.sap.jvm.profiling.impl.net.event.StreamSocketOpenV6EventImpl;
import com.sap.jvm.profiling.impl.net.response.DisableNetworkTraceResponseImpl;
import com.sap.jvm.profiling.impl.net.response.EnableNetworkTraceResponseImpl;
import com.sap.jvm.profiling.impl.reader.EntryEventHandler;
import com.sap.jvm.profiling.impl.session.AbstractProfilingSessionImpl;
import com.sap.jvm.profiling.impl.summary.event.AllocationDeadClassStatisticImpl;
import com.sap.jvm.profiling.impl.summary.event.AllocationLiveClassStatisticImpl;
import com.sap.jvm.profiling.impl.summary.event.ProfilingSummaryEventImpl;
import com.sap.jvm.profiling.impl.summary.response.DisableProfilingSummaryTraceResponseImpl;
import com.sap.jvm.profiling.impl.summary.response.EnableProfilingSummaryTraceResponseImpl;
import com.sap.jvm.profiling.impl.sync.event.MonitorEnterEventImpl;
import com.sap.jvm.profiling.impl.sync.event.MonitorEnteredEventImpl;
import com.sap.jvm.profiling.impl.sync.event.MonitorExitEventImpl;
import com.sap.jvm.profiling.impl.sync.event.MonitorNotifyAllEventImpl;
import com.sap.jvm.profiling.impl.sync.event.MonitorNotifyEventImpl;
import com.sap.jvm.profiling.impl.sync.event.MonitorSlowEnterEventImpl;
import com.sap.jvm.profiling.impl.sync.event.MonitorWaitEnterEventImpl;
import com.sap.jvm.profiling.impl.sync.event.MonitorWaitExitEventImpl;
import com.sap.jvm.profiling.impl.sync.event.ReentrantLockEnterEventImpl;
import com.sap.jvm.profiling.impl.sync.event.ReentrantLockEnteredEventImpl;
import com.sap.jvm.profiling.impl.sync.event.ReentrantLockExitEventImpl;
import com.sap.jvm.profiling.impl.sync.response.DisableMonitorSlowEnterTraceResponseImpl;
import com.sap.jvm.profiling.impl.sync.response.DisableSynchronizationTraceResponseImpl;
import com.sap.jvm.profiling.impl.sync.response.EnableMonitorSlowEnterTraceResponseImpl;
import com.sap.jvm.profiling.impl.sync.response.EnableSynchronizationTraceResponseImpl;
import com.sap.jvm.profiling.impl.thread.event.ThreadDumpsEventImpl;
import com.sap.jvm.profiling.impl.thread.event.ThreadDumpsLastEventImpl;
import com.sap.jvm.profiling.impl.thread.event.ThreadStateSamplingEventImpl;
import com.sap.jvm.profiling.impl.thread.response.DisableThreadDumpsResponseImpl;
import com.sap.jvm.profiling.impl.thread.response.DisableThreadStateSamplingResponseImpl;
import com.sap.jvm.profiling.impl.thread.response.EnableThreadDumpsResponseImpl;
import com.sap.jvm.profiling.impl.thread.response.EnableThreadStateSamplingResponseImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.impl.util.MappingInformationImpl;
import com.sap.jvm.profiling.io.event.IOEventHandler;
import com.sap.jvm.profiling.memory.event.AllocationEventHandler;
import com.sap.jvm.profiling.memory.event.ClassStatisticEventHandler;
import com.sap.jvm.profiling.memory.event.GcEventHandler;
import com.sap.jvm.profiling.memory.event.GcHistoryFileDumpEventHandler;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.event.HprofDumpEventHandler;
import com.sap.jvm.profiling.memory.response.DisableGcStatisticResponse;
import com.sap.jvm.profiling.memory.response.EnableGcStatisticResponse;
import com.sap.jvm.profiling.method.event.MethodParameterEventHandler;
import com.sap.jvm.profiling.method.event.MethodToTraceHandler;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingEventHandler;
import com.sap.jvm.profiling.monitoring.event.MonitoringEventHandler;
import com.sap.jvm.profiling.net.event.NetworkEventHandler;
import com.sap.jvm.profiling.resource.PacketResourceReader;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.sync.event.SynchronizationEventHandler;
import com.sap.jvm.profiling.thread.event.ThreadDumpEventHandler;
import com.sap.jvm.tracing.Trace;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class AbstractProfilingReaderImpl
implements ProfilingReader,
ThreadEventHandler,
GcEventHandler {
    private static final int ESTIMATED_TIME_TO_GET_PACKET = 1;
    private static final int MAX_GARBAGE_COLLECTION_CACHE_THRESHOLD = 1000;
    private SnapshotMarkerHandler[] snapshotMarkerHandlers;
    private MethodToTraceHandler[] methodToTraceHandlers;
    private AllocationEventHandler[] allocationEventHandlers;
    private TimeBasedSamplingEventHandler[] timeBasedSamplingEventHandlers;
    private HeartBeatEventHandler[] heartBeatEventHandlers;
    private MethodParameterEventHandler[] methodParameterEventHandlers;
    private MonitoringEventHandler[] monitoringEventHandlers;
    private EntryEventHandler methodParameterEntryHandler;
    private IOEventHandler[] ioEventHandlers;
    private GcEventHandler[] gcEventHandlers;
    private SynchronizationEventHandler[] syncEventHandlers;
    private NetworkEventHandler[] netEventHandlers;
    private ExceptionEventHandler[] exceptionEventHandlers;
    private AlertEventHandler[] alertEventHandlers;
    private TestContentEventHandler[] testContentEventHandlers;
    private HprofDumpEventHandler[] hprofDumpEventHandlers;
    private final Object lockHprofDumpEventHandler = new Object();
    private ClassStatisticEventHandler[] classStatisticEventHandlers;
    private final Object lockClassStatisticEventHandlers = new Object();
    private ThreadDumpEventHandler[] threadDumpEventHandlers;
    private final Object lockThreadDumpEventHandler = new Object();
    private GcHistoryFileDumpEventHandler[] gcHistoryFileDumpEventHandlers;
    private final Object lockGcHistoryFileDumpEventHandlers = new Object();
    private ThreadEventHandler[] threadEventHandlers;
    protected PacketResourceReader reader;
    protected AbstractProfilingSessionImpl session;
    protected MappingInformation mapInfo;
    protected PacketResourceWriter eventWriter;
    protected PacketResourceWriter heartBeatWriter;
    protected PacketResourceWriter alertsWriter;
    protected SystemInfoImpl systemInfo;
    protected ProfilingVersion versionInfo;
    protected boolean[] threadFilterFlags;
    protected ThreadFilter threadFilter;
    private long nrOfReadPackets;
    private long lastlyReadTimestamp;
    private long nrOfReadPacketsTimestamp;
    private final long nrOfPacketsToRead;
    private final long nrOfInitiallyReadPackets;
    private long nrOfHeartBeatPackets;
    private boolean heartBeatAvailable;
    private long syncEnterEventId = 0L;
    private long syncExitEventId = 0L;
    private long alertEventId = 0L;
    private HeartBeatEventImpl lastHeartBeatEvent;
    private int hbInterval;
    private ArrayList<GcStatistic> gcStatistics;
    private boolean gcStatisticsWasAtLimit = false;

    public AbstractProfilingReaderImpl(AbstractProfilingSessionImpl session, PacketResourceReader reader, ThreadFilter threadFilter) throws IOException {
        this.session = session;
        this.reader = reader;
        this.mapInfo = session.getMapInfo();
        this.nrOfReadPackets = reader.getNrOfReadPackets();
        this.eventWriter = session.getResourceManager() != null ? session.getResourceManager().getEventWriter() : null;
        this.heartBeatWriter = session.getResourceManager() != null ? session.getResourceManager().getHeartBeatWriter() : null;
        this.alertsWriter = session.getResourceManager() != null ? session.getResourceManager().getAlertsWriter() : null;
        this.nrOfPacketsToRead = reader.getNrOfPacketsToRead();
        this.threadFilter = threadFilter;
        this.snapshotMarkerHandlers = new SnapshotMarkerHandler[0];
        this.methodToTraceHandlers = new MethodToTraceHandler[0];
        this.allocationEventHandlers = new AllocationEventHandler[0];
        this.timeBasedSamplingEventHandlers = new TimeBasedSamplingEventHandler[0];
        this.heartBeatEventHandlers = new HeartBeatEventHandler[0];
        this.methodParameterEventHandlers = new MethodParameterEventHandler[0];
        this.methodParameterEntryHandler = new EntryEventHandler(this.methodParameterEventHandlers);
        this.ioEventHandlers = new IOEventHandler[0];
        this.gcEventHandlers = new GcEventHandler[0];
        this.syncEventHandlers = new SynchronizationEventHandler[0];
        this.netEventHandlers = new NetworkEventHandler[0];
        this.nrOfInitiallyReadPackets = reader.getNrOfReadPackets();
        this.exceptionEventHandlers = new ExceptionEventHandler[0];
        this.alertEventHandlers = new AlertEventHandler[0];
        this.hprofDumpEventHandlers = new HprofDumpEventHandler[0];
        this.threadDumpEventHandlers = new ThreadDumpEventHandler[0];
        this.classStatisticEventHandlers = new ClassStatisticEventHandler[0];
        this.testContentEventHandlers = new TestContentEventHandler[0];
        this.monitoringEventHandlers = new MonitoringEventHandler[0];
        this.threadEventHandlers = new ThreadEventHandler[]{this};
        this.gcHistoryFileDumpEventHandlers = new GcHistoryFileDumpEventHandler[0];
    }

    @Override
    public long getNrOfReadBytes() {
        return this.reader.getNrOfReadBytes();
    }

    @Override
    public long getNrOfReadPackets() {
        return this.reader.getNrOfReadPackets() - this.nrOfInitiallyReadPackets;
    }

    @Override
    public long getNrOfPacketsToRead() {
        return this.nrOfPacketsToRead - this.nrOfInitiallyReadPackets;
    }

    @Override
    public long getLastlyReadTimestamp() {
        return this.heartBeatAvailable ? this.lastlyReadTimestamp : Math.abs(this.nrOfReadPackets - this.nrOfReadPacketsTimestamp) * 1L + this.lastlyReadTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProfilingPacketImpl nextPacket() throws IOException {
        ProfilingPacketImpl retValue = null;
        AbstractProfilingSessionImpl abstractProfilingSessionImpl = this.session;
        synchronized (abstractProfilingSessionImpl) {
            while (retValue == null) {
                int type = this.getNextEventPacketType();
                if (type == -1 || type == 1023) {
                    return null;
                }
                boolean hasNext = this.reader.nextPacket();
                if (!hasNext) {
                    throw new EOFException();
                }
                retValue = this.getNextEventPacket();
            }
        }
        return retValue;
    }

    @Override
    public AbstractProfilingSessionImpl getSession() {
        return this.session;
    }

    @Override
    public ThreadManager getThreadManager() {
        return this.mapInfo;
    }

    @Override
    public FileManager getFileManager() {
        return this.mapInfo;
    }

    @Override
    public SocketManager getSocketManager() {
        return this.mapInfo;
    }

    @Override
    public void registerAllocationEventHandler(AllocationEventHandler handler) {
        ArrayList<AllocationEventHandler> newHandlers = new ArrayList<AllocationEventHandler>(Arrays.asList(this.allocationEventHandlers));
        newHandlers.add(handler);
        this.allocationEventHandlers = newHandlers.toArray(new AllocationEventHandler[newHandlers.size()]);
    }

    @Override
    public void registerTimeBasedSamplingEventHandler(TimeBasedSamplingEventHandler handler) {
        ArrayList<TimeBasedSamplingEventHandler> newHandlers = new ArrayList<TimeBasedSamplingEventHandler>(Arrays.asList(this.timeBasedSamplingEventHandlers));
        newHandlers.add(handler);
        this.timeBasedSamplingEventHandlers = newHandlers.toArray(new TimeBasedSamplingEventHandler[newHandlers.size()]);
    }

    @Override
    public void registerHeartBeatEventHandler(HeartBeatEventHandler handler) {
        ArrayList<HeartBeatEventHandler> newHandlers = new ArrayList<HeartBeatEventHandler>(Arrays.asList(this.heartBeatEventHandlers));
        newHandlers.add(handler);
        this.heartBeatEventHandlers = newHandlers.toArray(new HeartBeatEventHandler[newHandlers.size()]);
    }

    @Override
    public void registerMethodParameterEventHandler(MethodParameterEventHandler handler) {
        ArrayList<MethodParameterEventHandler> newHandlers = new ArrayList<MethodParameterEventHandler>(Arrays.asList(this.methodParameterEventHandlers));
        newHandlers.add(handler);
        this.methodParameterEventHandlers = newHandlers.toArray(new MethodParameterEventHandler[newHandlers.size()]);
        this.methodParameterEntryHandler = new EntryEventHandler(this.methodParameterEventHandlers);
    }

    @Override
    public void registerExceptionEventHandler(ExceptionEventHandler handler) {
        ArrayList<ExceptionEventHandler> newHandlers = new ArrayList<ExceptionEventHandler>(Arrays.asList(this.exceptionEventHandlers));
        newHandlers.add(handler);
        this.exceptionEventHandlers = newHandlers.toArray(new ExceptionEventHandler[newHandlers.size()]);
    }

    @Override
    public void registerAlertEventHandler(AlertEventHandler handler) {
        ArrayList<AlertEventHandler> newHandlers = new ArrayList<AlertEventHandler>(Arrays.asList(this.alertEventHandlers));
        newHandlers.add(handler);
        this.alertEventHandlers = newHandlers.toArray(new AlertEventHandler[newHandlers.size()]);
    }

    @Override
    public void registerHprofDumpEventHandler(HprofDumpEventHandler handler) {
        ArrayList<HprofDumpEventHandler> newHandlers = new ArrayList<HprofDumpEventHandler>(Arrays.asList(this.hprofDumpEventHandlers));
        newHandlers.add(handler);
        this.hprofDumpEventHandlers = newHandlers.toArray(new HprofDumpEventHandler[newHandlers.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterHprofDumpEventHandler(HprofDumpEventHandler handler) {
        Object object = this.lockHprofDumpEventHandler;
        synchronized (object) {
            ArrayList<HprofDumpEventHandler> newHandlers = new ArrayList<HprofDumpEventHandler>(Arrays.asList(this.hprofDumpEventHandlers));
            newHandlers.remove(handler);
            this.hprofDumpEventHandlers = newHandlers.toArray(new HprofDumpEventHandler[newHandlers.size()]);
        }
    }

    @Override
    public void registerClassStatisticEventHandler(ClassStatisticEventHandler handler) {
        ArrayList<ClassStatisticEventHandler> newHandlers = new ArrayList<ClassStatisticEventHandler>(Arrays.asList(this.classStatisticEventHandlers));
        newHandlers.add(handler);
        this.classStatisticEventHandlers = newHandlers.toArray(new ClassStatisticEventHandler[newHandlers.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterClassStatisticEventHandler(ClassStatisticEventHandler handler) {
        Object object = this.lockClassStatisticEventHandlers;
        synchronized (object) {
            ArrayList<ClassStatisticEventHandler> newHandlers = new ArrayList<ClassStatisticEventHandler>(Arrays.asList(this.classStatisticEventHandlers));
            newHandlers.remove(handler);
            this.classStatisticEventHandlers = newHandlers.toArray(new ClassStatisticEventHandler[newHandlers.size()]);
        }
    }

    @Override
    public void registerThreadDumpEventHandler(ThreadDumpEventHandler handler) {
        ArrayList<ThreadDumpEventHandler> newHandlers = new ArrayList<ThreadDumpEventHandler>(Arrays.asList(this.threadDumpEventHandlers));
        newHandlers.add(handler);
        this.threadDumpEventHandlers = newHandlers.toArray(new ThreadDumpEventHandler[newHandlers.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterThreadDumpEventHandler(ThreadDumpEventHandler handler) {
        Object object = this.lockThreadDumpEventHandler;
        synchronized (object) {
            ArrayList<ThreadDumpEventHandler> newHandlers = new ArrayList<ThreadDumpEventHandler>(Arrays.asList(this.threadDumpEventHandlers));
            newHandlers.remove(handler);
            this.threadDumpEventHandlers = newHandlers.toArray(new ThreadDumpEventHandler[newHandlers.size()]);
        }
    }

    @Override
    public void registerTestContentEventHandler(TestContentEventHandler handler) {
        ArrayList<TestContentEventHandler> newHandlers = new ArrayList<TestContentEventHandler>(Arrays.asList(this.testContentEventHandlers));
        newHandlers.add(handler);
        this.testContentEventHandlers = newHandlers.toArray(new TestContentEventHandler[newHandlers.size()]);
    }

    @Override
    public void registerIOEventHandler(IOEventHandler handler) {
        ArrayList<IOEventHandler> newHandlers = new ArrayList<IOEventHandler>(Arrays.asList(this.ioEventHandlers));
        newHandlers.add(handler);
        this.ioEventHandlers = newHandlers.toArray(new IOEventHandler[newHandlers.size()]);
    }

    @Override
    public void registerGcEventHandler(GcEventHandler handler) {
        ArrayList<GcEventHandler> newHandlers = new ArrayList<GcEventHandler>(Arrays.asList(this.gcEventHandlers));
        newHandlers.add(handler);
        this.gcEventHandlers = newHandlers.toArray(new GcEventHandler[newHandlers.size()]);
    }

    @Override
    public void registerSynchronizationEventHandler(SynchronizationEventHandler handler) {
        ArrayList<SynchronizationEventHandler> newHandlers = new ArrayList<SynchronizationEventHandler>(Arrays.asList(this.syncEventHandlers));
        newHandlers.add(handler);
        this.syncEventHandlers = newHandlers.toArray(new SynchronizationEventHandler[newHandlers.size()]);
    }

    @Override
    public void registerNetworkEventHandler(NetworkEventHandler handler) {
        ArrayList<NetworkEventHandler> newHandlers = new ArrayList<NetworkEventHandler>(Arrays.asList(this.netEventHandlers));
        newHandlers.add(handler);
        this.netEventHandlers = newHandlers.toArray(new NetworkEventHandler[newHandlers.size()]);
    }

    @Override
    public void registerSnapshotMarkHandler(SnapshotMarkerHandler handler) {
        ArrayList<SnapshotMarkerHandler> newHandlers = new ArrayList<SnapshotMarkerHandler>(Arrays.asList(this.snapshotMarkerHandlers));
        newHandlers.add(handler);
        this.snapshotMarkerHandlers = newHandlers.toArray(new SnapshotMarkerHandler[newHandlers.size()]);
    }

    @Override
    public void registerMethodToTraceHandler(MethodToTraceHandler handler) {
        ArrayList<MethodToTraceHandler> newHandlers = new ArrayList<MethodToTraceHandler>(Arrays.asList(this.methodToTraceHandlers));
        newHandlers.add(handler);
        this.methodToTraceHandlers = newHandlers.toArray(new MethodToTraceHandler[newHandlers.size()]);
    }

    @Override
    public void registerMonitoringEventHandler(MonitoringEventHandler handler) {
        ArrayList<MonitoringEventHandler> newHandlers = new ArrayList<MonitoringEventHandler>(Arrays.asList(this.monitoringEventHandlers));
        newHandlers.add(handler);
        this.monitoringEventHandlers = newHandlers.toArray(new MonitoringEventHandler[newHandlers.size()]);
    }

    @Override
    public void registerThreadEventHandler(ThreadEventHandler handler) {
        ArrayList<ThreadEventHandler> newHandlers = new ArrayList<ThreadEventHandler>(Arrays.asList(this.threadEventHandlers));
        newHandlers.add(handler);
        this.threadEventHandlers = newHandlers.toArray(new ThreadEventHandler[newHandlers.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerGcHistoryFileDumpEventHandler(GcHistoryFileDumpEventHandler handler) {
        Object object = this.lockGcHistoryFileDumpEventHandlers;
        synchronized (object) {
            ArrayList<GcHistoryFileDumpEventHandler> newHandlers = new ArrayList<GcHistoryFileDumpEventHandler>(Arrays.asList(this.gcHistoryFileDumpEventHandlers));
            newHandlers.add(handler);
            this.gcHistoryFileDumpEventHandlers = newHandlers.toArray(new GcHistoryFileDumpEventHandler[newHandlers.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterGcHistoryFileDumpEventHandler(GcHistoryFileDumpEventHandler handler) {
        Object object = this.lockGcHistoryFileDumpEventHandlers;
        synchronized (object) {
            ArrayList<GcHistoryFileDumpEventHandler> newHandlers = new ArrayList<GcHistoryFileDumpEventHandler>(Arrays.asList(this.gcHistoryFileDumpEventHandlers));
            newHandlers.remove(handler);
            this.gcHistoryFileDumpEventHandlers = newHandlers.toArray(new GcHistoryFileDumpEventHandler[newHandlers.size()]);
        }
    }

    public void registerEventWriter(PacketResourceWriter writer) {
        this.eventWriter = writer;
    }

    public void registerHeartBeatWriter(PacketResourceWriter writer) {
        this.heartBeatWriter = writer;
    }

    public void registerAlertsWriter(PacketResourceWriter writer) {
        this.alertsWriter = writer;
    }

    @Override
    public BookmarkImpl createBookmark() {
        return new BookmarkImpl(this.nrOfReadPackets);
    }

    @Override
    public boolean isBeforeBookmark(Bookmark bookmark) {
        assert (this.nrOfReadPackets >= 0L);
        return this.nrOfReadPackets < bookmark.getNrOfReadEvents();
    }

    @Override
    public boolean isAfterBookmark(Bookmark bookmark) {
        assert (this.nrOfReadPackets >= 0L);
        return this.nrOfReadPackets > bookmark.getNrOfReadEvents();
    }

    @Override
    public SystemInfoImpl getSystemInfo() {
        return this.systemInfo;
    }

    protected void readMapInfoPacket(MappingInformationImpl mapInfoImpl) throws IOException {
        switch (this.reader.getType()) {
            case 400: {
                mapInfoImpl.addNonArrayClassObject(this.reader);
                break;
            }
            case 401: {
                mapInfoImpl.addArrayClassObject(this.reader);
                break;
            }
            case 403: {
                mapInfoImpl.addInternalClassObject(this.reader);
                break;
            }
            case 404: {
                mapInfoImpl.addClassLoaderObject(this.reader, true);
                break;
            }
            case 402: {
                mapInfoImpl.addPrimitiveClassObject(this.reader);
                break;
            }
            case 408: {
                mapInfoImpl.addMethodObjectFromInternal(this.reader);
                break;
            }
            case 409: {
                mapInfoImpl.addStackTrace(this.reader);
                break;
            }
            case 410: {
                mapInfoImpl.addThreadAnnotationKey(this.reader);
                break;
            }
            case 414: {
                mapInfoImpl.addGCHistoryInitialValues(this.reader);
                break;
            }
            case 415: {
                mapInfoImpl.addHostNameMapping(new HostLookupV4EventImpl(this.reader));
                break;
            }
            case 416: {
                mapInfoImpl.addHostNameMapping(new HostLookupV6EventImpl(this.reader));
                break;
            }
            case 417: {
                mapInfoImpl.addNetworkServiceMapping(new ServiceDiscoveryEventImpl(this.reader));
                break;
            }
            case 418: {
                this.hbInterval = (int)this.reader.readInt64();
                this.gcStatistics = new ArrayList();
                this.registerGcEventHandler(this);
            }
        }
    }

    protected ProfilingPacketImpl getNextEventPacket() throws IOException {
        if (this.eventWriter != null) {
            this.eventWriter.beforeNewPacket();
        }
        ++this.nrOfReadPackets;
        if (this.reader.getType() >= 1000 && this.reader.getType() < 1100) {
            ResponseImpl retValue = this.getNextResponseEventPacket();
            if (retValue == null) {
                --this.nrOfReadPackets;
            } else {
                this.lastlyReadTimestamp = retValue.getTime();
            }
            this.nrOfReadPacketsTimestamp = this.getNrOfReadPackets();
            if (this.eventWriter != null && retValue != null) {
                retValue.write(this.eventWriter);
            }
            if (this.reader.getType() == 1023) {
                return null;
            }
            return retValue;
        }
        ProfilingPacketImpl retValue = this.getNextCommonEventPacket();
        if (retValue != null && this.reader.getType() == 535) {
            this.lastlyReadTimestamp = ((HeartBeatEventImpl)retValue).getTimeMillis();
            this.nrOfReadPacketsTimestamp = this.getNrOfReadPackets();
            this.heartBeatAvailable = true;
            if (this.heartBeatWriter != null) {
                retValue.write(this.heartBeatWriter);
                ++this.nrOfHeartBeatPackets;
            }
        }
        if (retValue != null && this.eventWriter != null) {
            retValue.write(this.eventWriter);
        }
        if (retValue == null) {
            --this.nrOfReadPackets;
        }
        return retValue;
    }

    protected ResponseImpl getNextResponseEventPacket() throws IOException {
        switch (this.reader.getType()) {
            case 1003: {
                return EnableYoungGenClassStatisticResponseImpl.read(this.reader, this.classStatisticEventHandlers);
            }
            case 1005: {
                return EnableOldGenClassStatisticResponseImpl.read(this.reader, this.classStatisticEventHandlers);
            }
            case 1007: {
                return EnablePermGenClassStatisticResponseImpl.read(this.reader, this.classStatisticEventHandlers);
            }
            case 1004: {
                return DisableYoungGenClassStatisticResponseImpl.read(this.reader, this.classStatisticEventHandlers);
            }
            case 1006: {
                return DisableOldGenClassStatisticResponseImpl.read(this.reader, this.classStatisticEventHandlers);
            }
            case 1008: {
                return DisablePermGenClassStatisticResponseImpl.read(this.reader, this.classStatisticEventHandlers);
            }
            case 1009: {
                return new PauseTracingResponseImpl(this.reader);
            }
            case 1010: {
                return new ResumeTracingResponseImpl(this.reader);
            }
            case 1000: {
                return new FlushResponseImpl(this.reader);
            }
            case 1011: {
                return new EnableMethodCoverageResponseImpl(this.reader);
            }
            case 1012: {
                return new DisableMethodCoverageResponseImpl(this.reader);
            }
            case 1013: {
                return EnableAllocationTraceResponseImpl.read(this.reader, this.getSession().getCapabilities(), this.allocationEventHandlers);
            }
            case 1014: {
                return DisableAllocationTraceResponseImpl.read(this.reader, this.allocationEventHandlers);
            }
            case 1015: {
                return new ExtensionCommandResponseImpl(this.reader);
            }
            case 1016: {
                return new EnableProfilingSummaryTraceResponseImpl(this.reader);
            }
            case 1017: {
                return new DisableProfilingSummaryTraceResponseImpl(this.reader);
            }
            case 1018: {
                return EnableTimeBasedSamplingResponseImpl.read(this.reader, this.mapInfo, this.getSession().getCapabilities(), this.timeBasedSamplingEventHandlers);
            }
            case 1019: {
                return DisableTimeBasedSamplingResponseImpl.read(this.reader, this.timeBasedSamplingEventHandlers);
            }
            case 1027: {
                return new EnableThreadStateSamplingResponseImpl(this.reader);
            }
            case 1028: {
                return new DisableThreadStateSamplingResponseImpl(this.reader);
            }
            case 1032: {
                return EnableHeartBeatResponseImpl.read(this.reader, this.heartBeatEventHandlers);
            }
            case 1033: {
                return DisableHeartBeatResponseImpl.read(this.reader, this.heartBeatEventHandlers);
            }
            case 1020: {
                return new EnableObjectDeathTraceResponseImpl(this.reader);
            }
            case 1021: {
                return new DisableObjectDeathTraceResponseImpl(this.reader);
            }
            case 1022: {
                return new WriteHprofHeapDumpResponseImpl(this.reader);
            }
            case 1024: {
                return new ForceGcResponseImpl(this.reader);
            }
            case 1025: {
                return DumpClassStatisticStartResponseImpl.read(this.reader, this.classStatisticEventHandlers);
            }
            case 1026: {
                return DumpClassStatisticEndResponseImpl.read(this.reader, this.classStatisticEventHandlers);
            }
            case 1023: {
                return new StopProfilingResponseImpl(this.reader);
            }
            case 1029: {
                return EnableAdaptiveAllocationTraceResponseImpl.read(this.reader, this.getSession().getCapabilities(), this.allocationEventHandlers);
            }
            case 1030: {
                return EnableMethodParameterTraceResponseImpl.read(this.reader, this.mapInfo, this.methodParameterEventHandlers);
            }
            case 1031: {
                return DisableMethodParameterTraceResponseImpl.read(this.reader, this.mapInfo, this.methodParameterEventHandlers);
            }
            case 1034: {
                return SnapshotMarkerResponseImpl.read(this.reader, this.snapshotMarkerHandlers);
            }
            case 1035: {
                return EnableAllocationMptTraceResponseImpl.read(this.reader, this.getSession().getCapabilities(), this.mapInfo, this.allocationEventHandlers);
            }
            case 1036: {
                return EnableAdaptiveAllocationMptTraceResponseImpl.read(this.reader, this.getSession().getCapabilities(), this.mapInfo, this.allocationEventHandlers);
            }
            case 1037: {
                return DisableAllocationMptTraceResponseImpl.read(this.reader, this.allocationEventHandlers);
            }
            case 1038: {
                return EnableTimeBasedSamplingMptResponseImpl.read(this.reader, this.mapInfo, this.getSession().getCapabilities(), this.timeBasedSamplingEventHandlers);
            }
            case 1039: {
                return DisableTimeBasedSamplingMptResponseImpl.read(this.reader, this.timeBasedSamplingEventHandlers);
            }
            case 1040: {
                return ChangeHeartBeatIntervalResponseImpl.read(this.reader, this.heartBeatEventHandlers);
            }
            case 1041: {
                return new EnableMethodTraceResponseImpl(this.reader);
            }
            case 1042: {
                return new DisableMethodTraceResponseImpl(this.reader);
            }
            case 1045: {
                return EnableIOTraceResponseImpl.read(this.reader, this.ioEventHandlers);
            }
            case 1046: {
                return DisableIOTraceResponseImpl.read(this.reader, this.ioEventHandlers, this.mapInfo);
            }
            case 1001: {
                return EnableGcStatisticResponseImpl.read(this.reader, this.gcEventHandlers);
            }
            case 1002: {
                return DisableGcStatisticResponseImpl.read(this.reader, this.gcEventHandlers);
            }
            case 1047: {
                return EnableSynchronizationTraceResponseImpl.read(this.reader, this.syncEventHandlers);
            }
            case 1048: {
                return DisableSynchronizationTraceResponseImpl.read(this.reader, this.syncEventHandlers);
            }
            case 1049: {
                return EnableNetworkTraceResponseImpl.read(this.reader, this.netEventHandlers);
            }
            case 1050: {
                return DisableNetworkTraceResponseImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 1051: {
                return EnableExceptionTraceResponseImpl.read(this.reader, this.exceptionEventHandlers);
            }
            case 1052: {
                return DisableExceptionTraceResponseImpl.read(this.reader, this.exceptionEventHandlers);
            }
            case 1053: {
                return new EnableMonitorSlowEnterTraceResponseImpl(this.reader);
            }
            case 1054: {
                return new DisableMonitorSlowEnterTraceResponseImpl(this.reader);
            }
            case 1055: {
                return new EnableAlertResponseImpl(this.reader);
            }
            case 1056: {
                return new DisableAlertResponseImpl(this.reader);
            }
            case 1057: {
                return HprofDumpResponseImpl.read(this.reader, this.hprofDumpEventHandlers);
            }
            case 1058: {
                return new ResumeVMResponseImpl(this.reader);
            }
            case 1059: {
                return new JvmProfForwardResponseImpl(this.reader);
            }
            case 1060: {
                return new JvmProfStartProfilingResponseImpl(this.reader);
            }
            case 1061: {
                return new ProfilingTraceInfoResponseImpl(this.reader);
            }
            case 1062: {
                return ClassStatisticDumpResponseImpl.read(this.reader, this.classStatisticEventHandlers);
            }
            case 1069: {
                return EnableThreadDumpsResponseImpl.read(this.reader, this.mapInfo, this.threadDumpEventHandlers);
            }
            case 1070: {
                return new DisableThreadDumpsResponseImpl(this.reader);
            }
            case 1064: {
                return EnableJitEventsResponseImpl.read(this.reader);
            }
            case 1065: {
                return DisableJitEventsResponseImpl.read(this.reader);
            }
            case 1066: {
                return EnableMonitoringBoardTraceResponseImpl.read(this.reader, this.monitoringEventHandlers);
            }
            case 1067: {
                return DisableMonitoringBoardTraceResponseImpl.read(this.reader, this.monitoringEventHandlers);
            }
            case 1068: {
                return GcHistoryFileDumpEnableResponseImpl.read(this.reader, this.gcHistoryFileDumpEventHandlers);
            }
        }
        return null;
    }

    protected ProfilingPacketImpl getNextCommonEventPacket() throws IOException {
        switch (this.reader.getType()) {
            case 501: {
                return new ProfilingBufferDumpedImpl(this.reader);
            }
            case 502: {
                return YoungGenClassStatisticImpl.read(this.reader, this.classStatisticEventHandlers);
            }
            case 503: {
                return OldGenClassStatisticImpl.read(this.reader, this.classStatisticEventHandlers);
            }
            case 504: {
                return PermGenClassStatisticImpl.read(this.reader, this.classStatisticEventHandlers);
            }
            case 508: {
                return GcStatisticSerialGcImpl.read(this.reader, this.gcEventHandlers, this.mapInfo, false);
            }
            case 696: {
                return GcStatisticSerialGcImpl.read(this.reader, this.gcEventHandlers, this.mapInfo, true);
            }
            case 505: {
                return GcStatisticParallelGcImpl.read(this.reader, this.gcEventHandlers, this.mapInfo, false);
            }
            case 693: {
                return GcStatisticParallelGcImpl.read(this.reader, this.gcEventHandlers, this.mapInfo, true);
            }
            case 506: {
                return GcStatisticParallelNewGcImpl.read(this.reader, this.gcEventHandlers, this.mapInfo, false);
            }
            case 694: {
                return GcStatisticParallelNewGcImpl.read(this.reader, this.gcEventHandlers, this.mapInfo, true);
            }
            case 507: {
                return GcStatisticParallelOldGcImpl.read(this.reader, this.gcEventHandlers, this.mapInfo, false);
            }
            case 695: {
                return GcStatisticParallelOldGcImpl.read(this.reader, this.gcEventHandlers, this.mapInfo, true);
            }
            case 532: {
                return GcStatisticConcMarkSweepGcImpl.read(this.reader, this.gcEventHandlers, this.mapInfo, false);
            }
            case 697: {
                return GcStatisticConcMarkSweepGcImpl.read(this.reader, this.gcEventHandlers, this.mapInfo, true);
            }
            case 704: {
                return GcStatisticG1GcImpl.read(this.reader, this.gcEventHandlers, this.mapInfo, false);
            }
            case 705: {
                return GcStatisticG1GcImpl.read(this.reader, this.gcEventHandlers, this.mapInfo, true);
            }
            case 509: {
                return new MethodCoverageEventImpl(this.reader, this.mapInfo);
            }
            case 510: {
                return NonArrayAllocationEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 511: {
                return ArrayAllocationEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 512: {
                return NonArrayAllocationNoStackEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 513: {
                return ArrayAllocationNoStackEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 514: {
                return NonArrayAllocationNoIdEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 515: {
                return ArrayAllocationNoIdEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 516: {
                return NonArrayAllocationNoStackAndIdEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 517: {
                return ArrayAllocationNoStackAndIdEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 527: {
                return MultiNonArrayAllocationNoIdEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 528: {
                return MultiArrayAllocationNoIdEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 529: {
                return MultiNonArrayAllocationNoStackAndIdEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 530: {
                return MultiArrayAllocationNoStackAndIdEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 769: {
                return NonArrayStackAllocationNoIdEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 773: {
                return ArrayStackAllocationNoIdEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 771: {
                return NonArrayStackAllocationNoStackAndIdEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 775: {
                return ArrayStackAllocationNoStackAndIdEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 776: {
                return MultiNonArrayStackAllocationNoIdEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 778: {
                return MultiArrayStackAllocationNoIdEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 777: {
                return MultiNonArrayStackAllocationNoStackAndIdEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 779: {
                return MultiArrayStackAllocationNoStackAndIdEventImpl.read(this.reader, this.allocationEventHandlers, this.threadFilterFlags);
            }
            case 518: {
                return new ProfilingSummaryEventImpl(this.reader);
            }
            case 519: {
                return new AllocationLiveClassStatisticImpl(this.reader);
            }
            case 520: {
                return new AllocationDeadClassStatisticImpl(this.reader);
            }
            case 521: {
                return TimeBasedSamplingEventImpl.readInternal(this.session, this.mapInfo, this.reader, this.timeBasedSamplingEventHandlers);
            }
            case 531: {
                return ThreadStateSamplingEventImpl.read(this.reader);
            }
            case 535: {
                this.lastHeartBeatEvent = HeartBeatEventImpl.read(this.lastHeartBeatEvent, this.reader, this.session, this.heartBeatEventHandlers);
                return this.lastHeartBeatEvent;
            }
            case 522: {
                return new ObjectDeathEventImpl(this.reader);
            }
            case 523: {
                return ThreadStartedImpl.read(this.reader, this.mapInfo, this.threadEventHandlers);
            }
            case 556: {
                return ThreadWithAnnotationsStartedImpl.read(this.reader, this.mapInfo, this.threadEventHandlers);
            }
            case 524: {
                return ThreadStoppedImpl.read(this.reader, this.mapInfo, this.threadEventHandlers);
            }
            case 525: {
                return ThreadNameChangedImpl.read(this.reader, this.mapInfo, this.threadEventHandlers);
            }
            case 526: {
                return ThreadUserChangedImpl.read(this.reader, this.mapInfo, this.threadEventHandlers);
            }
            case 557: {
                return ThreadAnnotationChangedImpl.read(this.reader, this.mapInfo, this.threadEventHandlers);
            }
            case 536: {
                MethodParameterRawTagHandling.readEntry(this.reader, this.mapInfo);
                break;
            }
            case 550: {
                return MethodParameterRawTagHandling.readExit(this.reader, this.mapInfo, this.methodParameterEventHandlers);
            }
            case 537: {
                return MethodParameterRawTagHandling.readExceptionParameter(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 538: {
                return MethodParameterRawTagHandling.readNullInCallParameter(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 539: {
                return MethodParameterRawTagHandling.readNullParameter(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 549: {
                return MethodParameterRawTagHandling.readBooleanParameter(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 548: {
                return MethodParameterRawTagHandling.readByteParameter(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 547: {
                return MethodParameterRawTagHandling.readShortParameter(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 546: {
                return MethodParameterRawTagHandling.readCharParameter(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 545: {
                return MethodParameterRawTagHandling.readIntParameter(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 544: {
                return MethodParameterRawTagHandling.readLongParameter(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 543: {
                return MethodParameterRawTagHandling.readFloatParameter(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 542: {
                return MethodParameterRawTagHandling.readDoubleParameter(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 540: {
                return MethodParameterRawTagHandling.readStringParameter(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 541: {
                return MethodParameterRawTagHandling.readClassParameter(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 551: {
                this.mapInfo.addMethodParameterDefinition(this.reader);
                break;
            }
            case 552: {
                return MethodParameterApplyErrorEventImpl.read(this.reader, this.mapInfo, this.methodParameterEventHandlers);
            }
            case 553: {
                return MethodParameterRawTagHandling.readIndexOutOfBoundsParameter(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 554: {
                return MethodParameterRawTagHandling.readClassCastParameter(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 555: {
                return MethodParameterRawTagHandling.readEnabledFailedParameter(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 558: {
                return MethodParameterNearMissEventImpl.read(this.reader, this.mapInfo, this.methodParameterEventHandlers);
            }
            case 533: {
                return MethodParameterEntryEventImpl.read(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 534: {
                return MethodParameterExitEventImpl.read(this.reader, this.mapInfo, this.methodParameterEventHandlers);
            }
            case 562: {
                return MethodParameterRawTagHandling.readEntryCpuTime(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 560: {
                return MethodParameterRawTagHandling.readEntryTimeStamp(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 563: {
                MethodParameterRawTagHandling.readExitCpuTime(this.reader, this.mapInfo);
                break;
            }
            case 561: {
                MethodParameterRawTagHandling.readExitTimeStamp(this.reader, this.mapInfo);
                break;
            }
            case 564: {
                MethodParameterRawTagHandling.readEntryWithStack(this.reader, this.mapInfo);
                break;
            }
            case 565: {
                return MethodParameterRawTagHandling.readExitWithStack(this.reader, this.mapInfo, this.methodParameterEventHandlers);
            }
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 700: 
            case 701: 
            case 702: 
            case 703: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 711: 
            case 712: 
            case 713: 
            case 754: 
            case 755: 
            case 786: 
            case 787: 
            case 788: 
            case 789: 
            case 930: {
                this.mapInfo.getGcHistoryInitialValues().addGCEvent(this.reader, this.reader.getType(), this.mapInfo);
                break;
            }
            case 590: {
                return MethodParameterRawTagHandling.readUnknownParameter(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 591: {
                return MethodParameterMethodToTraceEventImpl.read(this.reader, this.mapInfo, this.methodToTraceHandlers);
            }
            case 594: {
                return new MethodTraceEventImpl(this.reader, this.mapInfo);
            }
            case 596: {
                return MonitorEnterEventImpl.read((ResourceReader)this.reader, this.mapInfo, this.syncEventHandlers, ++this.syncEnterEventId);
            }
            case 614: {
                return MonitorEnterEventImpl.read((ResourceReader)this.reader, this.mapInfo, this.syncEventHandlers, false);
            }
            case 619: {
                return MonitorEnterEventImpl.read((ResourceReader)this.reader, this.mapInfo, this.syncEventHandlers, true);
            }
            case 597: {
                return MonitorEnteredEventImpl.read(this.reader, this.mapInfo, this.syncEventHandlers, false);
            }
            case 620: {
                return MonitorEnteredEventImpl.read(this.reader, this.mapInfo, this.syncEventHandlers, true);
            }
            case 598: {
                return MonitorWaitEnterEventImpl.read(this.reader, this.mapInfo, this.syncEventHandlers, false);
            }
            case 621: {
                return MonitorWaitEnterEventImpl.read(this.reader, this.mapInfo, this.syncEventHandlers, true);
            }
            case 599: {
                return MonitorWaitExitEventImpl.read(this.reader, this.mapInfo, this.syncEventHandlers, false);
            }
            case 622: {
                return MonitorWaitExitEventImpl.read(this.reader, this.mapInfo, this.syncEventHandlers, true);
            }
            case 602: {
                return MonitorExitEventImpl.read((ResourceReader)this.reader, this.mapInfo, this.syncEventHandlers, ++this.syncExitEventId);
            }
            case 615: {
                return MonitorExitEventImpl.read((ResourceReader)this.reader, this.mapInfo, this.syncEventHandlers, false);
            }
            case 625: {
                return MonitorExitEventImpl.read((ResourceReader)this.reader, this.mapInfo, this.syncEventHandlers, true);
            }
            case 600: {
                return MonitorNotifyEventImpl.read(this.reader, this.mapInfo, this.syncEventHandlers, false);
            }
            case 623: {
                return MonitorNotifyEventImpl.read(this.reader, this.mapInfo, this.syncEventHandlers, true);
            }
            case 601: {
                return MonitorNotifyAllEventImpl.read(this.reader, this.mapInfo, this.syncEventHandlers, false);
            }
            case 624: {
                return MonitorNotifyAllEventImpl.read(this.reader, this.mapInfo, this.syncEventHandlers, true);
            }
            case 603: {
                return ObjectIdentificationEventImpl.read(this.reader, this.syncEventHandlers);
            }
            case 604: {
                return ReentrantLockEnterEventImpl.read(this.reader, this.mapInfo, this.syncEventHandlers, false, ++this.syncEnterEventId);
            }
            case 626: {
                return ReentrantLockEnterEventImpl.read(this.reader, this.mapInfo, this.syncEventHandlers, true, ++this.syncEnterEventId);
            }
            case 629: {
                return ReentrantLockEnterEventImpl.read(this.reader, this.mapInfo, this.syncEventHandlers);
            }
            case 605: {
                return ReentrantLockEnteredEventImpl.read(this.reader, this.mapInfo, this.syncEventHandlers, false);
            }
            case 627: {
                return ReentrantLockEnteredEventImpl.read(this.reader, this.mapInfo, this.syncEventHandlers, true);
            }
            case 606: {
                return ReentrantLockExitEventImpl.read(this.reader, this.mapInfo, this.syncEventHandlers, false, ++this.syncExitEventId);
            }
            case 628: {
                return ReentrantLockExitEventImpl.read(this.reader, this.mapInfo, this.syncEventHandlers, true, ++this.syncExitEventId);
            }
            case 630: {
                return ReentrantLockExitEventImpl.read(this.reader, this.mapInfo, this.syncEventHandlers);
            }
            case 607: {
                return FileOpenEventImpl.read(this.reader, this.ioEventHandlers, this.session.getSystemInfo(), this.mapInfo);
            }
            case 616: {
                return ZipFileOpenEventImpl.read(this.reader, this.ioEventHandlers, this.session.getSystemInfo(), this.mapInfo);
            }
            case 612: {
                return FileNotFoundEventImpl.read(this.reader, this.ioEventHandlers, this.session.getSystemInfo());
            }
            case 608: {
                return FileReadEventImpl.read(this.reader, this.ioEventHandlers, this.mapInfo);
            }
            case 617: {
                return ZipFileReadEventImpl.read(this.reader, this.ioEventHandlers, this.mapInfo);
            }
            case 611: {
                return FileWriteEventImpl.read(this.reader, this.ioEventHandlers, this.mapInfo);
            }
            case 609: {
                return FileCloseEventImpl.read(this.reader, this.ioEventHandlers, this.mapInfo);
            }
            case 618: {
                return ZipFileCloseEventImpl.read(this.reader, this.ioEventHandlers, this.mapInfo);
            }
            case 559: {
                return TimeBasedSamplingInitialCpuTimesEventImpl.read(this.session, this.mapInfo, this.reader);
            }
            case 610: {
                return TimeBasedSamplingEventImpl.readExternal(this.session, this.mapInfo, this.reader, this.timeBasedSamplingEventHandlers);
            }
            case 631: {
                return StreamSocketOpenV4EventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 632: {
                return StreamSocketOpenV6EventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 633: {
                return DatagramSocketOpenV4EventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 634: {
                return DatagramSocketOpenV6EventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 635: {
                return SocketBindV4EventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 636: {
                return SocketBindV6EventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 637: {
                return SocketAcceptV4EventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 638: {
                return SocketAcceptV6EventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 639: {
                return SocketConnectV4EventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 640: {
                return SocketConnectV6EventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 784: {
                return SocketConnectFailureV4EventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 785: {
                return SocketConnectFailureV6EventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 641: {
                return SocketPeekEventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 642: {
                return DirectedSocketPeekV4EventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 643: {
                return DirectedSocketPeekV6EventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 644: {
                return SocketReadEventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 645: {
                return DirectedSocketReadV4EventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 646: {
                return DirectedSocketReadV6EventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 647: {
                return SocketWriteEventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 648: {
                return DirectedSocketWriteV4EventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 649: {
                return DirectedSocketWriteV6EventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 650: {
                return SocketCloseEventImpl.read(this.reader, this.netEventHandlers, this.mapInfo);
            }
            case 780: {
                return new ReverseHostLookupV4EventImpl(this.reader);
            }
            case 781: {
                return new ReverseHostLookupV6EventImpl(this.reader);
            }
            case 782: {
                return new ReverseHostLookupFailureV4EventImpl(this.reader);
            }
            case 783: {
                return new ReverseHostLookupFailureV4EventImpl(this.reader);
            }
            case 651: {
                return ExceptionThrownEventImpl.read(this.reader, this.exceptionEventHandlers);
            }
            case 652: {
                return new MonitorSlowEnterEventImpl(this.reader);
            }
            case 653: {
                return ErrorEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 680: {
                return ErrorEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 654: {
                return StackoverflowEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 681: {
                return StackoverflowEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 655: {
                return OutOfMemoryEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 682: {
                return OutOfMemoryEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 665: {
                return ThreadStopEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 683: {
                return ThreadStopEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 667: {
                return SpuriousWackupEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 684: {
                return SpuriousWackupEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 689: {
                return StartDebuggingEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 690: {
                return StartDebuggingEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 691: {
                return StopDebuggingEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 692: {
                return StopDebuggingEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 685: {
                return StartProfilingEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 686: {
                return StartProfilingEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 687: {
                return StopProfilingEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 688: {
                return StopProfilingEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 668: {
                return HprofDumpStartImpl.read(this.reader, this.hprofDumpEventHandlers);
            }
            case 669: {
                return HprofDumpEndImpl.read(this.reader, this.hprofDumpEventHandlers);
            }
            case 670: {
                return HprofDumpWriteImpl.read(this.reader, this.hprofDumpEventHandlers);
            }
            case 671: {
                return HprofDumpSeekImpl.read(this.reader, this.hprofDumpEventHandlers);
            }
            case 672: {
                return HprofDumpWriteAddonImpl.read(this.reader, this.hprofDumpEventHandlers);
            }
            case 673: {
                return MethodParameterRawTagHandling.readMethodParameter(this.reader, this.mapInfo, this.methodParameterEntryHandler);
            }
            case 674: {
                return TraceEventErrorImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 675: {
                return TraceEventErrorImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 676: {
                return TraceEventInformationImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 677: {
                return TraceEventInformationImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 678: {
                return TraceEventWarningImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 679: {
                return TraceEventWarningImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 698: {
                return ClassStatisticDumpStartImpl.read(this.reader, this.classStatisticEventHandlers);
            }
            case 699: {
                return ClassStatisticDumpEndImpl.read(this.reader, this.classStatisticEventHandlers);
            }
            case 714: {
                return StartAllocationAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 715: {
                return StartAllocationAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 716: {
                return StopAllocationAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 717: {
                return StopAllocationAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 718: {
                return StartPerformanceHotspotAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 719: {
                return StartPerformanceHotspotAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 720: {
                return StopPerformanceHotspotAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 721: {
                return StopPerformanceHotspotAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 722: {
                return StartMethodParameterAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 723: {
                return StartMethodParameterAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 724: {
                return StopMethodParameterAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 725: {
                return StopMethodParameterAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 730: {
                return StartSynchronizationAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 731: {
                return StartSynchronizationAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 732: {
                return StopSynchronizationAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 733: {
                return StopSynchronizationAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 734: {
                return StartFileAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 735: {
                return StartFileAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 736: {
                return StopFileAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 737: {
                return StopFileAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 738: {
                return StartNetworkIoAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 739: {
                return StartNetworkIoAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 740: {
                return StopNetworkIoAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 741: {
                return StopNetworkIoAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 742: {
                return StartGarbageCollectionAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 743: {
                return StartGarbageCollectionAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 744: {
                return StopGarbageCollectionAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 745: {
                return StopGarbageCollectionAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 746: {
                return StartHeapDumpAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 747: {
                return StartHeapDumpAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 748: {
                return StopHeapDumpAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 749: {
                return StopHeapDumpAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 750: {
                return StartClassStatisticAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 751: {
                return StartClassStatisticAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 752: {
                return StopClassStatisticAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 753: {
                return StopClassStatisticAnalysisEventImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, -1L);
            }
            case 920: {
                return JitEventMethodCompilationImpl.read(this.reader, this.mapInfo);
            }
            case 921: {
                return JitEventNMethodStateChangeImpl.read(this.reader, this.mapInfo);
            }
            case 756: {
                return TestContentEventImpl.read(this.reader, this.testContentEventHandlers);
            }
            case 757: {
                this.lastHeartBeatEvent = HeartBeatEventImpl.readSmallKey(this.lastHeartBeatEvent, this.reader, this.session, this.heartBeatEventHandlers, this.gcStatistics);
                return this.lastHeartBeatEvent;
            }
            case 758: {
                this.lastHeartBeatEvent = HeartBeatEventImpl.readSmallDiff(this.lastHeartBeatEvent, this.reader, this.session, this.heartBeatEventHandlers, this.hbInterval, this.gcStatistics);
                return this.lastHeartBeatEvent;
            }
            case 759: {
                this.lastHeartBeatEvent = HeartBeatEventImpl.readSmallDiff2(this.lastHeartBeatEvent, this.reader, this.session, this.heartBeatEventHandlers, this.gcStatistics);
                return this.lastHeartBeatEvent;
            }
            case 760: {
                return StorableAlertImpl.read(this.reader, this.alertEventHandlers, this.alertsWriter, ++this.alertEventId);
            }
            case 761: {
                MonitoringBoardInitialEventImpl event = MonitoringBoardInitialEventImpl.read(this.reader, this.monitoringEventHandlers);
                this.session.setInitialMonitoringBoard(event);
                this.mapInfo.setLastMonitoringBoard(event);
                return this.session.getInitialMonitoringBoard();
            }
            case 763: {
                MonitoringBoardDiffToInitialEventImpl event = MonitoringBoardDiffToInitialEventImpl.read(this.reader, this.session.getInitialMonitoringBoard().getContent(), this.monitoringEventHandlers);
                this.mapInfo.setLastMonitoringBoard(event);
                return event;
            }
            case 762: {
                MonitoringBoardDiffToPrevEventImpl event = new MonitoringBoardDiffToPrevEventImpl(this.reader);
                this.mapInfo.setLastMonitoringBoard(event);
                for (MonitoringEventHandler handler : this.monitoringEventHandlers) {
                    handler.handle(event, this.mapInfo.getLastBoardContent());
                }
                return event;
            }
            case 764: {
                return ThreadDumpsEventImpl.read(this.reader, this.mapInfo, this.threadDumpEventHandlers);
            }
            case 765: {
                return ThreadDumpsLastEventImpl.read(this.reader, this.mapInfo, this.threadDumpEventHandlers);
            }
            case 767: {
                DefaultTimeZoneSetEventImpl packet = new DefaultTimeZoneSetEventImpl(this.reader);
                this.session.setDefaultTimeZone(packet.getTimeZoneId());
                return packet;
            }
            case 766: {
                return GcHistoryFileDumpEventImpl.read(this.reader, this.gcHistoryFileDumpEventHandlers);
            }
        }
        return null;
    }

    protected int getNextEventPacketType() throws IOException {
        try {
            int type;
            while ((type = this.reader.nextPacketType()) >= 400 && type < 500) {
                boolean hasNext = this.reader.nextPacket();
                if (!hasNext) {
                    throw new EOFException();
                }
                this.readMapInfoPacket((MappingInformationImpl)this.mapInfo);
            }
            return type;
        }
        catch (EOFException ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    protected SystemInfoImpl readSystemInfo() throws IOException {
        int type = this.reader.nextPacketType();
        if (type == 407) {
            assert (this.systemInfo == null);
            boolean hasNext = this.reader.nextPacket();
            assert (hasNext);
            return new SystemInfoImpl(this.reader);
        }
        return null;
    }

    @Override
    public void handle(ThreadStarted event, ThreadManager threadManager) {
        if (this.threadFilter == null) {
            return;
        }
        char threadIndex = event.getThreadIndex();
        ThreadInfoImpl threadInfo = (ThreadInfoImpl)threadManager.getThreadInfo(threadIndex);
        if (this.threadFilterFlags == null || this.threadFilterFlags.length <= threadIndex) {
            int length = Math.min(2 * threadIndex, 65536);
            boolean[] newFlags = new boolean[length];
            if (this.threadFilterFlags != null) {
                System.arraycopy(this.threadFilterFlags, 0, newFlags, 0, this.threadFilterFlags.length);
            }
            this.threadFilterFlags = newFlags;
        }
        this.threadFilterFlags[threadIndex] = this.threadFilter.applies(threadInfo);
    }

    @Override
    public void handle(ThreadStopped event, ThreadManager threadManager) {
    }

    @Override
    public void handle(ThreadNameChanged event, ThreadManager threadManager) {
    }

    @Override
    public void handle(ThreadUserChanged event, ThreadManager threadManager) {
        if (this.threadFilter == null) {
            return;
        }
        char threadIndex = event.getThreadIndex();
        ThreadInfoImpl threadInfo = (ThreadInfoImpl)threadManager.getThreadInfo(threadIndex);
        this.threadFilterFlags[threadIndex] = this.threadFilter.applies(threadInfo);
    }

    @Override
    public void handle(ThreadAnnotationChanged event, ThreadManager threadManager) {
        if (this.threadFilter == null) {
            return;
        }
        char threadIndex = event.getThreadIndex();
        ThreadInfoImpl threadInfo = (ThreadInfoImpl)threadManager.getThreadInfo(threadIndex);
        this.threadFilterFlags[threadIndex] = this.threadFilter.applies(threadInfo);
    }

    @Override
    public void close() {
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.mapInfo != null) {
            if (this.heartBeatWriter != null) {
                this.mapInfo.setNrOfHeartBeatPackets(this.nrOfHeartBeatPackets);
            }
            this.mapInfo = null;
        }
        this.heartBeatWriter = null;
        this.eventWriter = null;
    }

    @Override
    public void handle(EnableGcStatisticResponse response) {
    }

    @Override
    public void handle(DisableGcStatisticResponse response) {
    }

    @Override
    public void handle(GcStatistic event) {
        if (this.gcStatistics.size() < 1000) {
            this.gcStatistics.add(event);
        } else if (!this.gcStatisticsWasAtLimit) {
            this.gcStatisticsWasAtLimit = true;
            Trace.warn("Profiling heart beat garbage collection cache hit limit.");
        }
    }
}

