/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.reader;

import com.sap.jvm.profiling.impl.method.parameters.MethodParametersImpl;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEventHandler;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.ArrayList;

public class EntryEventHandler {
    private final MethodParameterEventHandler[] handlers;
    private final MethodParameterEventHandler[] modifiers;

    public EntryEventHandler(MethodParameterEventHandler[] handlers) {
        this.handlers = (MethodParameterEventHandler[])handlers.clone();
        int nrOfModifiers = 0;
        for (MethodParameterEventHandler handler : handlers) {
            if (!handler.providesReturnValuesInEntryEvents()) continue;
            ++nrOfModifiers;
        }
        this.modifiers = new MethodParameterEventHandler[nrOfModifiers];
        nrOfModifiers = 0;
        for (MethodParameterEventHandler handler : handlers) {
            if (!handler.providesReturnValuesInEntryEvents()) continue;
            this.modifiers[nrOfModifiers] = handler;
            ++nrOfModifiers;
        }
    }

    public void handle(MethodParameterEntryEvent event) {
        for (MethodParameterEventHandler modifier : this.modifiers) {
            try {
                ArrayList<Parameter> returnValues = modifier.getReturnValuesForEntryEvent(event);
                if (returnValues == null || returnValues.isEmpty()) continue;
                MethodParametersImpl parameters = (MethodParametersImpl)event.getParameters();
                parameters.replaceReturnValues(returnValues);
            }
            catch (IOException e) {
                Trace.error((Throwable)e, () -> "Error when getting return values from " + modifier + ".");
                throw new RuntimeException(e);
            }
        }
        for (MethodParameterEventHandler handler : this.handlers) {
            handler.handle(event);
        }
    }
}

