/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.reader;

import com.sap.jvm.profiling.core.ProfilingVersion;
import com.sap.jvm.profiling.impl.reader.AbstractProfilingReaderImpl;
import com.sap.jvm.profiling.impl.reader.ResourceReaderImpl;
import com.sap.jvm.profiling.impl.session.InputStreamProfilingSessionImpl;
import com.sap.jvm.util.persistence.ContinuedPacketReader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class InputStreamProfilingReaderImpl
extends AbstractProfilingReaderImpl {
    private final CountingInputStream is;

    public InputStreamProfilingReaderImpl(CountingInputStream is, InputStreamProfilingSessionImpl session) throws IOException {
        super(session, new ResourceReaderImpl(session, session.getMapInfo(), new ContinuedPacketReader(new BufferedInputStream(is), true)), null);
        this.systemInfo = this.readSystemInfo();
        this.is = is;
    }

    @Override
    public ProfilingVersion getVersion() {
        return new ProfilingVersion(this.systemInfo.getMajorVersion(), this.systemInfo.getMinorVersion(), this.systemInfo.getMinorVersion());
    }

    @Override
    public long getNrOfReadBytes() {
        return this.is.getReadBytes();
    }

    public static class CountingInputStream
    extends InputStream {
        private final InputStream is;
        private long readBytes;

        public CountingInputStream(InputStream is) {
            this.is = is;
        }

        public long getReadBytes() {
            return this.readBytes;
        }

        @Override
        public int read() throws IOException {
            int res = this.is.read();
            if (res >= 0) {
                ++this.readBytes;
            }
            return res;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int result = this.is.read(b);
            if (result > 0) {
                this.readBytes += (long)result;
            }
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.is.read(b, off, len);
            if (result > 0) {
                this.readBytes += (long)result;
            }
            return result;
        }
    }
}

