/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.reader;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.impl.core.type.MethodObjectImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.AbstractPacketResourceReader;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.util.persistence.ContinuedPacketReader;
import java.io.EOFException;
import java.io.IOException;

public final class ResourceReaderImpl
extends AbstractPacketResourceReader {
    private final MappingInformation mapInfo;

    public ResourceReaderImpl(ProfilingSession session, MappingInformation mapInfo, ContinuedPacketReader packetReader) {
        super(session);
        this.setPacketReader(packetReader);
        this.mapInfo = mapInfo;
    }

    @Override
    public int getStackTraceIndexForObjectId(long objectId) {
        int stackTraceId = (int)(objectId & 0x3FFFFFFL);
        return this.mapInfo.getStackTraceIndexOfOriginalId(stackTraceId);
    }

    @Override
    public long readClassLoaderId() throws EOFException {
        return this.readInt64();
    }

    @Override
    public ClassLoaderObject readClassLoaderObject() throws EOFException {
        long id = this.readInt64();
        return this.mapInfo.getClassLoaderObjectById(id);
    }

    @Override
    public long readClassObjectId() throws EOFException {
        return this.readInt64();
    }

    @Override
    public ClassObject readClassObject() throws EOFException {
        long id = this.readInt64();
        return this.mapInfo.getClassObjectById(id);
    }

    @Override
    public long readMethodObjectId() throws EOFException {
        return this.readInt64();
    }

    @Override
    public MethodObjectImpl readMethodObject() throws EOFException {
        long id = this.readInt64();
        return this.mapInfo.getMethodObjectById(id);
    }

    @Override
    public int readStackTraceIndex() throws EOFException {
        int id = this.readInt32();
        return this.mapInfo.getStackTraceIndexOfOriginalId(id);
    }

    @Override
    public long readUniqueFileId() throws EOFException {
        return -1L;
    }

    @Override
    public long readUniqueSocketId() throws EOFException {
        return -1L;
    }

    @Override
    public ResourceName readResourceName() throws IOException {
        throw new UnsupportedOperationException("Cannot create resource names.");
    }

    @Override
    public long getNrOfReadBytes() {
        return -1L;
    }
}

