/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.session;

import com.sap.jvm.profiling.MapMetaInfo;
import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.ProfilingSessionStatistic;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.JRubyMethodCategorizer;
import com.sap.jvm.profiling.core.ProfilingCapabilities;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.type.ClassLoaderManager;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.ClassObjectManager;
import com.sap.jvm.profiling.core.type.HostNameManager;
import com.sap.jvm.profiling.core.type.MethodLocationManager;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.MethodObjectManager;
import com.sap.jvm.profiling.core.type.NetworkServiceNameManager;
import com.sap.jvm.profiling.core.type.PackageNameManager;
import com.sap.jvm.profiling.core.type.StackTraceManager;
import com.sap.jvm.profiling.core.type.StringManager;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.ProfilingSessionStatisticImpl;
import com.sap.jvm.profiling.impl.core.BookmarkImpl;
import com.sap.jvm.profiling.impl.core.JRubyMethodCategorizerImpl;
import com.sap.jvm.profiling.impl.core.ProfilingCapabilitiesImpl;
import com.sap.jvm.profiling.impl.core.event.SystemInfoImpl;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.method.event.MethodParameterMethodToTraceEventImpl;
import com.sap.jvm.profiling.impl.method.response.MethodParameterSpecImpl;
import com.sap.jvm.profiling.impl.monitoring.event.MonitoringBoardInitialEventImpl;
import com.sap.jvm.profiling.impl.reader.PartProfilingReaderImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.impl.util.MappingInformationImpl;
import com.sap.jvm.profiling.method.event.MethodParameterDefinitions;
import com.sap.jvm.profiling.method.event.MethodParameterMethodToTraceEvent;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.resource.PacketResourceReader;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.util.TimeZoneUtils;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import java.io.IOException;
import java.util.HashSet;
import java.util.TimeZone;

public abstract class AbstractProfilingSessionImpl
implements ProfilingSession {
    private static final Tracer tracer = Trace.get(AbstractProfilingSessionImpl.class, (Object)"Profiling/Session");
    private static final String TZ_PROP_PREFIX = "-Duser.timezone=";
    protected int nrOfThreads = Math.min(4, Runtime.getRuntime().availableProcessors());
    protected MethodParameterDefinitions parameterDefinitions;
    protected MappingInformationImpl mapInfo;
    protected ResourceManager resourceManager;
    protected PacketResourceWriter eventWriter;
    protected PacketResourceWriter heartBeatWriter;
    protected PacketResourceWriter alertsWriter;
    protected SystemInfoImpl systemInfo;
    protected ProfilingCapabilities capabilities;
    private long lastSeenTimeStamp;
    private volatile JRubyMethodCategorizerImpl categorizer;
    private volatile MonitoringBoardInitialEventImpl initialBoard;
    private TimeZone timeZone;
    private String fallbackTimeZone;
    private final Object tzLock = new Object();
    private final Object mbLock = new Object();
    private final Object jrubyLock = new Object();

    AbstractProfilingSessionImpl() throws IOException {
    }

    @Override
    public void setNrOfThreads(int nrOfThreads) {
        this.nrOfThreads = nrOfThreads;
    }

    @Override
    public int getNrOfThreads() {
        return this.nrOfThreads;
    }

    @Override
    public int getNrOfThreadsForSorting() {
        if ((this.nrOfThreads & this.nrOfThreads - 1) == 0) {
            return this.nrOfThreads;
        }
        return Integer.highestOneBit(this.nrOfThreads) * 2;
    }

    @Override
    public abstract SystemInfoImpl getSystemInfo();

    public MappingInformation getMapInfo() {
        return this.mapInfo;
    }

    @Override
    public ProfilingSessionStatistic getSessionStatistic() {
        return new ProfilingSessionStatisticImpl(this.mapInfo.getNrOfAnnotationKeys(), this.mapInfo.getParameterDefinitions().getNrOfSpecs(), this.mapInfo.getParameterDefinitions().getNrOfDefinitions());
    }

    @Override
    public final MethodLocationManager getMethodLocationManager() {
        return this.mapInfo.getStackTraceManager();
    }

    @Override
    public final StackTraceManager getStackTraceManager() {
        return this.mapInfo.getStackTraceManager();
    }

    @Override
    public ClassObjectManager getClassObjectManager() {
        return this.mapInfo;
    }

    @Override
    public ClassLoaderManager getClassLoaderManager() {
        return this.mapInfo;
    }

    @Override
    public MethodObjectManager getMethodObjectManager() {
        return this.mapInfo;
    }

    @Override
    public StringManager getStringManager() {
        return this.mapInfo;
    }

    @Override
    public PackageNameManager getPackageNameManager() {
        return this.mapInfo;
    }

    @Override
    public HostNameManager getHostNameManager() {
        return this.mapInfo.getHostNameManager();
    }

    @Override
    public NetworkServiceNameManager getNetworkServiceNameManager() {
        return this.mapInfo.getNetworkServiceNameManager();
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public void registerResourceManager(ResourceManager manager) {
        if (manager == null) {
            return;
        }
        this.resourceManager = manager;
        this.eventWriter = manager.getEventWriter();
        this.heartBeatWriter = manager.getHeartBeatWriter();
        this.alertsWriter = manager.getAlertsWriter();
    }

    @Override
    public void writeMapInfo(PacketResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.mapInfo.write(writer, reporter);
    }

    @Override
    public void readMapInfo(PacketResourceReader reader, MapMetaInfo mapMetaInfo, ProgressReporter progressReporter) throws IOException {
        this.mapInfo = new MappingInformationImpl(reader, mapMetaInfo, progressReporter);
    }

    @Override
    public ClassLoaderObject getClassLoader(int index) {
        return this.mapInfo.getClassLoaderObject(index);
    }

    @Override
    public ClassObject getClassObject(int index) {
        return this.mapInfo.getClassObject(index);
    }

    @Override
    public MethodObject getMethodObject(int index) {
        return this.mapInfo.getMethodObject(index);
    }

    @Override
    public MethodParameterDefinitions getParameterDefinitions() {
        return this.mapInfo.getParameterDefinitions();
    }

    @Override
    public ProfilingReader getReader(PacketResourceReader resourceReader, ThreadFilter threadFilter) {
        try {
            return new PartProfilingReaderImpl(this, resourceReader, threadFilter);
        }
        catch (IOException ex) {
            tracer.debug((Throwable)ex, "Unexpected I/O error during getting a profiling reader.");
            return null;
        }
    }

    @Override
    public MethodObject[] getMatchingClassAndMethodNames(String prefix) {
        return this.mapInfo.getMatchingClassAndMethodNames(prefix);
    }

    @Override
    public ClassObject[] getMatchingClassNames(String prefix) {
        return this.mapInfo.getMatchingClassNames(prefix);
    }

    @Override
    public MethodObject[] getMatchingFullClassAndMethodNames(String prefix) {
        return this.mapInfo.getMatchingFullClassAndMethodNames(prefix);
    }

    @Override
    public ClassObject[] getMatchingFullClassNames(String prefix) {
        return this.mapInfo.getMatchingFullClassNames(prefix);
    }

    @Override
    public MethodObject[] getMatchingFullMethodNames(String prefix) {
        return this.mapInfo.getMatchingFullMethodNames(prefix);
    }

    @Override
    public String[] getMatchingLoaderNamePrefixes(String prefix) {
        return this.mapInfo.getMatchingLoaderNamePrefixes(prefix);
    }

    @Override
    public HashSet<UTF8String> getAllPackages() {
        return this.mapInfo.getAllPackages();
    }

    @Override
    public String[] getMatchingPackagePrefixes(String prefix) {
        return this.mapInfo.getMatchingPackagePrefixes(prefix);
    }

    @Override
    public int getNrOfAnnotationKeys() {
        return this.mapInfo.getNrOfAnnotationKeys();
    }

    @Override
    public UTF8String getAnnotationKey(int slot) {
        return this.mapInfo.getAnnotationKey(slot);
    }

    @Override
    public UTF8String getAnnotationDescription(int slot) {
        return this.mapInfo.getAnnotationDescription(slot);
    }

    @Override
    public Bookmark readBookmark(ResourceReader reader) throws IOException {
        return BookmarkImpl.read(reader);
    }

    @Override
    public void writeThreadInfo(PacketResourceWriter writer) throws IOException {
        this.mapInfo.writeThreadInfo(writer);
    }

    @Override
    public MethodParameterSpec readMethodParameterSpec(ResourceReader reader) throws IOException {
        return MethodParameterSpecImpl.read(reader);
    }

    @Override
    public void writeMethodParameterSpec(MethodParameterSpec spec, PacketResourceWriter writer) throws IOException {
        ((MethodParameterSpecImpl)spec).write(writer);
    }

    @Override
    public MethodParameterMethodToTraceEvent readMethodToTrace(ResourceReader reader) throws IOException {
        return new MethodParameterMethodToTraceEventImpl(reader, this.getMapInfo());
    }

    @Override
    public void writeMethodToTrace(MethodParameterMethodToTraceEvent event, PacketResourceWriter writer) throws IOException {
        ((MethodParameterMethodToTraceEventImpl)event).write(writer);
    }

    public void setSystemInfo(SystemInfoImpl systemInfo) {
        this.systemInfo = systemInfo;
        this.timeZone = null;
        this.capabilities = new ProfilingCapabilitiesImpl(this.getVersion(), systemInfo);
    }

    public void setMapInfo(MappingInformationImpl mapInfo) {
        this.mapInfo = mapInfo;
        this.timeZone = null;
    }

    @Override
    public boolean hasGcStatistic() {
        return this.mapInfo.getGcHistoryInitialValues() != null;
    }

    @Override
    public int getNumberOfConcurrentGCThreads() {
        GCHistoryInitialValues history = this.mapInfo.getGcHistoryInitialValues();
        return history == null ? -1 : history.getNumberOfConcurrentGCThreads();
    }

    @Override
    public int getNumberOfGCThreads() {
        GCHistoryInitialValues history = this.mapInfo.getGcHistoryInitialValues();
        return history == null ? -1 : history.getNumberOfGCThreads();
    }

    @Override
    public long getReservedJavaHeapSize() {
        GCHistoryInitialValues history = this.mapInfo.getGcHistoryInitialValues();
        return history == null ? -1L : history.getReservedJavaHeapSize();
    }

    @Override
    public long getReservedPermGenSize() {
        GCHistoryInitialValues history = this.mapInfo.getGcHistoryInitialValues();
        return history == null ? -1L : history.getReservedPermGenSize();
    }

    @Override
    public long getNrOfHeartBeatPackets() {
        return this.mapInfo.getNrOfHeartBeatPackets();
    }

    @Override
    public int getNrOfHostnames() {
        return this.mapInfo.getHostNameManager().getNrOfHostNames();
    }

    @Override
    public int getNrOfNetworkServices() {
        return this.mapInfo.getNetworkServiceNameManager().getNrOfSpecialServices();
    }

    @Override
    public long getLastlyReadTimestamp() {
        if (this.getReader() != null && this.getReader().getLastlyReadTimestamp() > 0L) {
            return this.getReader().getLastlyReadTimestamp();
        }
        return this.lastSeenTimeStamp;
    }

    @Override
    public void setLastlyReadTimestamp(long ts) {
        this.lastSeenTimeStamp = ts;
    }

    @Override
    public Bookmark createBookmarkByPacketNr(long nrOfReadPackets) {
        return new BookmarkImpl(nrOfReadPackets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRubyMethodCategorizer getJRubyMethodCategorizer() {
        if (this.categorizer == null) {
            Object object = this.jrubyLock;
            synchronized (object) {
                if (this.categorizer != null) {
                    return this.categorizer;
                }
                this.categorizer = new JRubyMethodCategorizerImpl(this);
            }
        }
        return this.categorizer;
    }

    @Override
    public MonitoringBoardInitialEventImpl getInitialMonitoringBoard() {
        return this.initialBoard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitialMonitoringBoard(MonitoringBoardInitialEventImpl board) {
        Object object = this.mbLock;
        synchronized (object) {
            if (this.initialBoard == null) {
                this.initialBoard = board;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultTimeZone() {
        Object object = this.tzLock;
        synchronized (object) {
            String result;
            String string = result = this.systemInfo != null ? this.systemInfo.getDefaultTimeZone() : "";
            if (result.length() == 0 && (result = this.mapInfo.getDefaultTimeZone()).length() == 0) {
                if (this.fallbackTimeZone != null) {
                    result = this.fallbackTimeZone;
                } else if (this.systemInfo != null) {
                    for (String arg : this.systemInfo.getVmArguments()) {
                        if (!arg.startsWith(TZ_PROP_PREFIX)) continue;
                        this.fallbackTimeZone = arg.substring(TZ_PROP_PREFIX.length());
                    }
                    if (this.fallbackTimeZone == null) {
                        String[] nativeInfo = this.systemInfo.getNativeTimeZoneInfo();
                        this.fallbackTimeZone = TimeZoneUtils.getTimeZoneFromNative(nativeInfo);
                    }
                    result = this.fallbackTimeZone;
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultTimeZone(String id) {
        Object object = this.tzLock;
        synchronized (object) {
            String tz;
            String string = tz = this.systemInfo != null ? this.systemInfo.getDefaultTimeZone() : "";
            if (tz.length() == 0 && (tz = this.mapInfo.getDefaultTimeZone()).length() == 0) {
                this.timeZone = null;
                this.mapInfo.setDefaultTimeZone(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUserTimeZone() {
        Object object = this.tzLock;
        synchronized (object) {
            return this.mapInfo.getUserTimeZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserTimeZone(String id) {
        Object object = this.tzLock;
        synchronized (object) {
            this.timeZone = null;
            this.mapInfo.setUserTimeZone(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeZone getTimeZone() {
        Object object = this.tzLock;
        synchronized (object) {
            String defaultId;
            if (this.timeZone != null) {
                return this.timeZone;
            }
            String id = this.getUserTimeZone();
            if (id.length() == 0) {
                id = this.getDefaultTimeZone();
            }
            this.timeZone = id.length() == 0 ? ((defaultId = System.getProperty("user.timezone", null)) != null && defaultId.length() > 0 ? TimeZone.getTimeZone(defaultId) : TimeZone.getDefault()) : TimeZone.getTimeZone(id);
        }
        return this.timeZone;
    }
}

