/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.session;

import com.sap.jvm.profiling.core.ProfilingCapabilities;
import com.sap.jvm.profiling.core.ProfilingVersion;
import com.sap.jvm.profiling.exception.UnsupportedVersionException;
import com.sap.jvm.profiling.impl.core.ProfilingCapabilitiesImpl;
import com.sap.jvm.profiling.impl.core.event.SystemInfoImpl;
import com.sap.jvm.profiling.impl.reader.InputStreamProfilingReaderImpl;
import com.sap.jvm.profiling.impl.session.AbstractProfilingSessionImpl;
import com.sap.jvm.profiling.impl.util.MappingInformationImpl;
import com.sap.jvm.profiling.resource.ResourceManager;
import java.io.IOException;
import java.io.InputStream;

public final class InputStreamProfilingSessionImpl
extends AbstractProfilingSessionImpl {
    private ProfilingVersion versionInfo;
    private InputStreamProfilingReaderImpl mainReader;

    public InputStreamProfilingSessionImpl(InputStream is) throws UnsupportedVersionException, IOException {
        this.mapInfo = new MappingInformationImpl(this, false);
        try {
            this.mainReader = new InputStreamProfilingReaderImpl(new InputStreamProfilingReaderImpl.CountingInputStream(is), this);
            this.systemInfo = this.mainReader.getSystemInfo();
        }
        catch (IOException ex) {
            is.close();
            throw ex;
        }
        if (this.versionInfo == null) {
            this.versionInfo = new ProfilingVersion(this.systemInfo.getMajorVersion(), this.systemInfo.getMinorVersion(), 0);
            this.checkVersion(this.versionInfo);
        }
        this.capabilities = new ProfilingCapabilitiesImpl(this.versionInfo, this.systemInfo);
    }

    public InputStreamProfilingSessionImpl() throws IOException {
        this.mapInfo = new MappingInformationImpl(this, false);
    }

    @Override
    public void close() {
        if (this.mainReader != null) {
            this.mainReader.close();
        }
    }

    @Override
    public SystemInfoImpl getSystemInfo() {
        return this.systemInfo;
    }

    @Override
    public ProfilingVersion getVersion() {
        if (this.versionInfo == null && this.resourceManager != null) {
            this.versionInfo = this.resourceManager.getVersionInfo();
        }
        return this.versionInfo;
    }

    @Override
    public ProfilingCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public InputStreamProfilingReaderImpl getReader() {
        return this.mainReader;
    }

    @Override
    public void registerResourceManager(ResourceManager store) {
        super.registerResourceManager(store);
        if (this.mainReader != null) {
            this.mainReader.registerEventWriter(this.eventWriter);
            this.mainReader.registerHeartBeatWriter(this.heartBeatWriter);
            this.mainReader.registerAlertsWriter(this.alertsWriter);
        }
    }

    private void checkVersion(ProfilingVersion version) throws UnsupportedVersionException {
        if (!version.isCompatible(1, 6, 0)) {
            throw new UnsupportedVersionException("Unspported protocol version: " + version.toString(), version);
        }
    }
}

