/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.session;

import com.sap.jvm.profiling.OfflineProfilingSession;
import com.sap.jvm.profiling.core.ProfilingCapabilities;
import com.sap.jvm.profiling.core.ProfilingVersion;
import com.sap.jvm.profiling.exception.UnsupportedVersionException;
import com.sap.jvm.profiling.impl.core.ProfilingCapabilitiesImpl;
import com.sap.jvm.profiling.impl.core.event.SystemInfoImpl;
import com.sap.jvm.profiling.impl.reader.OfflineProfilingReaderImpl;
import com.sap.jvm.profiling.impl.session.AbstractProfilingSessionImpl;
import com.sap.jvm.profiling.impl.util.MappingInformationImpl;
import com.sap.jvm.profiling.impl.util.ProfilingFileInputStream;
import com.sap.jvm.profiling.resource.ResourceManager;
import java.io.IOException;

public final class OfflineProfilingSessionImpl
extends AbstractProfilingSessionImpl
implements OfflineProfilingSession {
    private String filename;
    private ProfilingVersion versionInfo;
    private OfflineProfilingReaderImpl mainReader;

    public OfflineProfilingSessionImpl(String filename) throws UnsupportedVersionException, IOException {
        this.filename = filename;
        this.mapInfo = new MappingInformationImpl(this, false);
        ProfilingFileInputStream inputStream = new ProfilingFileInputStream(filename);
        this.versionInfo = inputStream.getVersion();
        if (this.versionInfo != null) {
            this.checkVersion(this.versionInfo);
        }
        try {
            this.mainReader = new OfflineProfilingReaderImpl(inputStream, this);
            this.systemInfo = this.mainReader.getSystemInfo();
        }
        catch (IOException ex) {
            inputStream.close();
            throw ex;
        }
        if (this.versionInfo == null) {
            this.versionInfo = new ProfilingVersion(this.systemInfo.getMajorVersion(), this.systemInfo.getMinorVersion(), 0);
            this.checkVersion(this.versionInfo);
        }
        this.capabilities = new ProfilingCapabilitiesImpl(this.versionInfo, this.systemInfo);
    }

    public OfflineProfilingSessionImpl() throws IOException {
        this.mapInfo = new MappingInformationImpl(this, false);
    }

    @Override
    public void close() {
        if (this.mainReader != null) {
            this.mainReader.close();
        }
    }

    @Override
    public SystemInfoImpl getSystemInfo() {
        return this.systemInfo;
    }

    @Override
    public ProfilingVersion getVersion() {
        if (this.versionInfo == null && this.resourceManager != null) {
            this.versionInfo = this.resourceManager.getVersionInfo();
        }
        return this.versionInfo;
    }

    @Override
    public ProfilingCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public OfflineProfilingReaderImpl getReader() {
        return this.mainReader;
    }

    @Override
    public void registerResourceManager(ResourceManager store) {
        super.registerResourceManager(store);
        if (this.mainReader != null) {
            this.mainReader.registerEventWriter(this.eventWriter);
            this.mainReader.registerHeartBeatWriter(this.heartBeatWriter);
            this.mainReader.registerAlertsWriter(this.alertsWriter);
        }
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    private void checkVersion(ProfilingVersion version) throws UnsupportedVersionException {
        if (!version.isCompatible(1, 6, 0)) {
            throw new UnsupportedVersionException("Unspported protocol version: " + version.toString(), version);
        }
    }

    @Override
    public boolean usesChunkedFile() {
        return this.mainReader.usesChunkedFile();
    }

    @Override
    public void changeFilename(String file) {
        this.filename = file;
    }
}

