/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.session;

import com.sap.jvm.profiling.Connection;
import com.sap.jvm.profiling.OnlineProfilingSession;
import com.sap.jvm.profiling.core.ProfilingCapabilities;
import com.sap.jvm.profiling.core.ProfilingVersion;
import com.sap.jvm.profiling.impl.core.ProfilingCapabilitiesImpl;
import com.sap.jvm.profiling.impl.core.event.SystemInfoImpl;
import com.sap.jvm.profiling.impl.reader.OnlineProfilingReaderImpl;
import com.sap.jvm.profiling.impl.session.AbstractProfilingSessionImpl;
import com.sap.jvm.profiling.impl.util.MappingInformationImpl;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public final class OnlineProfilingSessionImpl
extends AbstractProfilingSessionImpl
implements OnlineProfilingSession {
    private Connection connection;
    private OnlineProfilingReaderImpl mainReader;
    private ProfilingVersion versionInfo;

    public OnlineProfilingSessionImpl(Connection connection) throws IOException {
        this.connection = connection;
        this.mapInfo = new MappingInformationImpl(this, false);
        this.mainReader = new OnlineProfilingReaderImpl(this);
        this.systemInfo = this.mainReader.getSystemInfo();
        this.versionInfo = this.mainReader.getVersion() == null ? new ProfilingVersion(this.systemInfo.getMajorVersion(), this.systemInfo.getMinorVersion(), this.systemInfo.getMicroVersion()) : this.mainReader.getVersion();
        this.capabilities = new ProfilingCapabilitiesImpl(this.versionInfo, this.systemInfo);
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (IOException ex) {
            Trace.warn((Throwable)ex, "Error during closing profiling connection.");
        }
        this.mainReader.close();
    }

    @Override
    public String getBackupFileName() {
        return this.connection.getBackupFileName();
    }

    @Override
    public OnlineProfilingReaderImpl getReader() {
        return this.mainReader;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public ProfilingCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public SystemInfoImpl getSystemInfo() {
        return this.systemInfo;
    }

    @Override
    public ProfilingVersion getVersion() {
        return this.versionInfo;
    }

    @Override
    public void registerResourceManager(ResourceManager store) {
        super.registerResourceManager(store);
        if (this.mainReader != null) {
            this.mainReader.registerEventWriter(this.eventWriter);
            this.mainReader.registerHeartBeatWriter(this.heartBeatWriter);
            this.mainReader.registerAlertsWriter(this.alertsWriter);
        }
    }
}

