/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.summary.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.memory.event.BasicClassStatisticHelperImpl;
import com.sap.jvm.profiling.memory.AgeRange;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.summary.event.AllocationLiveClassStatistic;
import java.io.IOException;

public final class AllocationLiveClassStatisticImpl
extends ProfilingPacketImpl
implements AllocationLiveClassStatistic {
    private final long gcNr;
    private final AgeRange ageRange;
    private final ClassObject[] classes;
    private final long[] nrOfObjects;
    private final long[] sizeOfObjects;
    private final short tag;

    public AllocationLiveClassStatisticImpl(ResourceReader reader) throws IOException {
        int startAge = 0;
        int endAge = Integer.MAX_VALUE;
        this.tag = reader.readInt16();
        this.gcNr = reader.readInt64();
        int nrOfClasses = reader.readInt32();
        this.ageRange = new AgeRange(startAge, endAge);
        this.classes = new ClassObject[nrOfClasses];
        this.nrOfObjects = new long[nrOfClasses];
        this.sizeOfObjects = new long[nrOfClasses];
        for (int i = 0; i < nrOfClasses; ++i) {
            this.classes[i] = reader.readClassObject();
            this.nrOfObjects[i] = reader.readInt64();
            this.sizeOfObjects[i] = reader.readInt64();
        }
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ALLOCATION_LIVE_CLASS_STATISTIC_EVENT;
    }

    @Override
    public short getThreadTag() {
        return this.tag;
    }

    @Override
    public AgeRange getAgeRange() {
        return this.ageRange;
    }

    @Override
    public ClassObject getClassObject(int index) {
        return this.classes[index];
    }

    @Override
    public long getGCNr() {
        return this.gcNr;
    }

    @Override
    public int getNrOfClasses() {
        return this.classes.length;
    }

    @Override
    public long getNrOfObjects(int index) {
        return this.nrOfObjects[index];
    }

    @Override
    public long getSizeOfObjects(int index) {
        return this.sizeOfObjects[index];
    }

    @Override
    public long getTotalNumOfObjects() {
        return BasicClassStatisticHelperImpl.getObjectCount(this);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
    }

    @Override
    public String getPacketName() {
        return "allocation live class statistic event";
    }
}

