/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.summary.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.summary.event.AllocationStatisticImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.summary.event.AllocationStatistic;
import com.sap.jvm.profiling.summary.event.ProfilingSummary;
import com.sap.jvm.profiling.summary.event.ProfilingSummaryEvent;
import com.sap.jvm.profiling.summary.event.TimeStatistic;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class ProfilingSummaryEventImpl
extends ProfilingPacketImpl
implements ProfilingSummaryEvent {
    private Map<Short, ProfilingSummary> summary = new HashMap<Short, ProfilingSummary>();

    public ProfilingSummaryEventImpl(ResourceReader reader) throws IOException {
        int numberTags = reader.readUint16();
        for (int i = 0; i < numberTags; ++i) {
            long numberOfAllocatedInstances = reader.readInt64();
            long numberOfAllocatedBytes = reader.readInt64();
            long numberOfFreedInstances = reader.readInt64();
            long numberOfFreedBytes = reader.readInt64();
            long cpuTime = reader.readInt64();
            if (cpuTime == 0L && numberOfAllocatedInstances == 0L) continue;
            AllocationStatisticImpl allocStat = new AllocationStatisticImpl(numberOfAllocatedInstances, numberOfAllocatedBytes, numberOfFreedInstances, numberOfFreedBytes);
            TimeStatisticImpl timeStat = new TimeStatisticImpl(cpuTime);
            ProfilingSummaryImpl tagSummary = new ProfilingSummaryImpl(allocStat, timeStat);
            this.summary.put((short)i, tagSummary);
        }
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.PROFILING_SUMMARY_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
    }

    @Override
    public Map<Short, ProfilingSummary> get() {
        return this.summary;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
    }

    @Override
    public String getPacketName() {
        return "profiling summary event";
    }

    private static class TimeStatisticImpl
    implements TimeStatistic {
        private long duration;

        TimeStatisticImpl(long duration) {
            this.duration = duration;
        }

        @Override
        public long getCPUDuration() {
            return this.duration;
        }
    }

    private static class ProfilingSummaryImpl
    implements ProfilingSummary {
        private AllocationStatistic allocStatistic;
        private TimeStatistic timeStatistic;

        ProfilingSummaryImpl(AllocationStatistic allocStat, TimeStatistic timeStat) {
            this.allocStatistic = allocStat;
            this.timeStatistic = timeStat;
        }

        @Override
        public AllocationStatistic getAllocationStatistic() {
            return this.allocStatistic;
        }

        @Override
        public TimeStatistic getTimeStatistic() {
            return this.timeStatistic;
        }
    }
}

