/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.summary.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.summary.command.ProfilingSummaryConfiguration;
import com.sap.jvm.profiling.summary.response.EnableProfilingSummaryTraceResponse;
import java.io.IOException;

public final class EnableProfilingSummaryTraceResponseImpl
extends ResponseImpl
implements EnableProfilingSummaryTraceResponse {
    private final ProfilingSummaryConfiguration config;

    public EnableProfilingSummaryTraceResponseImpl(ResourceReader reader) throws IOException {
        super("enable profiling summary trace response", reader);
        boolean enableClassStatisticForLiveObjects = reader.readBoolean();
        boolean enableClassStatisticForDeadObjects = reader.readBoolean();
        this.config = new ProfilingSummaryConfiguration();
        if (enableClassStatisticForLiveObjects) {
            this.config.enableClassStatisticForLiveObjects();
        }
        if (enableClassStatisticForDeadObjects) {
            this.config.enableClassStatisticForDeadObjects();
        }
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ENABLE_PROFILING_SUMMARY_TRACE_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
    }

    @Override
    public ProfilingSummaryConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.writeInt16((short)1016);
        this.writeInternal(writer);
        writer.writeBoolean(this.config.isClassStatisticForLiveObjectsEnabled());
        writer.writeBoolean(this.config.isClassStatisticForDeadObjectsEnabled());
    }
}

