/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.sync.command;

import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.command.CommandType;
import com.sap.jvm.profiling.impl.core.command.CommandImpl;
import com.sap.jvm.profiling.sync.command.EnableSynchronizationTraceCommand;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class EnableSynchronizationTraceCommandImpl
extends CommandImpl
implements EnableSynchronizationTraceCommand {
    private final ThreadFilter threadFilter;
    private final boolean withWaitNotify;

    EnableSynchronizationTraceCommandImpl(ThreadFilter threadFilter, boolean withWaitNotify) {
        this.threadFilter = threadFilter;
        this.withWaitNotify = withWaitNotify;
    }

    @Override
    public void print(PrintStream stream) {
        stream.print("Enable synchronization trace (threadFilter: ");
        stream.print(this.threadFilter == null ? "**" : this.threadFilter.asString());
        stream.println(')');
        stream.println("Wait/Notify events : " + (this.withWaitNotify ? "enabled" : "disabled"));
    }

    @Override
    protected void writeToStreamImpl(DataOutputStream stream) throws IOException {
        this.writeUint16(stream, 49);
        stream.writeLong(this.getId());
        this.writeNewThreadFilter(stream, this.threadFilter);
        stream.writeBoolean(this.withWaitNotify);
    }

    @Override
    public CommandType getType() {
        return CommandType.ENABLE_SYNCHRONIZATION_TRACE;
    }
}

