/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.sync.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.event.ObjectIdentificationEventImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.sync.event.MonitorNotifyAllEvent;
import com.sap.jvm.profiling.sync.event.SynchronizationEventHandler;
import java.io.IOException;

public class MonitorNotifyAllEventImpl
extends ProfilingPacketImpl
implements MonitorNotifyAllEvent {
    private final char threadIndex;
    private final long timeStamp;
    private final int stackTraceIndex;
    private final char[] notifiedThreadIndices;
    private final char notifiedThreadCount;
    private final long objectId;
    private final long cumulatedSafepointTime;

    public static MonitorNotifyAllEventImpl read(ResourceReader reader, MappingInformation mapInfo, SynchronizationEventHandler[] handlers, boolean hasCalculatedTime) throws IOException {
        MonitorNotifyAllEventImpl retValue = new MonitorNotifyAllEventImpl(reader, mapInfo, hasCalculatedTime);
        for (SynchronizationEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    private MonitorNotifyAllEventImpl(ResourceReader reader, MappingInformation mapInfo, boolean hasCalculatedTime) throws IOException {
        this.threadIndex = reader.readUint16();
        this.timeStamp = reader.readInt64();
        this.stackTraceIndex = reader.readStackTraceIndex();
        this.notifiedThreadCount = reader.readUint16();
        this.notifiedThreadIndices = new char[this.notifiedThreadCount];
        for (int i = 0; i < this.notifiedThreadCount; ++i) {
            this.notifiedThreadIndices[i] = reader.readUint16();
        }
        this.objectId = ObjectIdentificationEventImpl.readObjectId(reader);
        if (hasCalculatedTime) {
            this.cumulatedSafepointTime = reader.readInt64();
        } else {
            double tickLength = reader.getSession().getSystemInfo().getOSCounterPeriod();
            this.cumulatedSafepointTime = (long)((double)reader.readInt64() * tickLength);
        }
    }

    @Override
    public char getNotifiedThreadCount() {
        return this.notifiedThreadCount;
    }

    @Override
    public char[] getNotifiedThreadIndices() {
        return this.notifiedThreadIndices;
    }

    @Override
    public long getObjectId() {
        return this.objectId;
    }

    @Override
    public int getStackTraceIndex() {
        return this.stackTraceIndex;
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.MONITOR_NOTIFY_ALL_EVENT;
    }

    @Override
    public long getCumulatedSafepointTime() {
        return this.cumulatedSafepointTime;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Timestamp           : %*t", this.timeStamp);
        stream.formatln("Notifying Thread    : %*T", this.threadIndex);
        stream.formatln("Stack trace : %*S", this.getStackTraceIndex());
        for (int i = 0; i < this.notifiedThreadCount; ++i) {
            stream.formatln("Notified Thread %3d    : %*T", i, this.notifiedThreadIndices[i]);
        }
        stream.formatln("Object id          : %d", this.objectId);
        stream.formatln("Cumulated safepoint time : %*D", this.cumulatedSafepointTime);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)624);
        writer.writeUint16(this.threadIndex);
        writer.writeInt64(this.timeStamp);
        writer.writeInt32(this.stackTraceIndex);
        writer.writeUint16(this.notifiedThreadCount);
        for (int i = 0; i < this.notifiedThreadCount; ++i) {
            writer.writeUint16(this.notifiedThreadIndices[i]);
        }
        ObjectIdentificationEventImpl.writeObjectId(writer, this.objectId);
        writer.writeInt64(this.cumulatedSafepointTime);
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "monitor notify all event";
    }
}

