/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.sync.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.event.ObjectIdentificationEventImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.sync.event.MonitorNotifyEvent;
import com.sap.jvm.profiling.sync.event.SynchronizationEventHandler;
import java.io.IOException;

public class MonitorNotifyEventImpl
extends ProfilingPacketImpl
implements MonitorNotifyEvent {
    private final char threadIndex;
    private final long timeStamp;
    private final int stackTraceIndex;
    private final char notifiedThreadIndex;
    private final boolean notifiedThreadAvail;
    private final long objectId;
    private final long cumulatedSafepointTime;

    public static MonitorNotifyEventImpl read(ResourceReader reader, MappingInformation mapInfo, SynchronizationEventHandler[] handlers, boolean hasCalculatedTime) throws IOException {
        MonitorNotifyEventImpl retValue = new MonitorNotifyEventImpl(reader, mapInfo, hasCalculatedTime);
        for (SynchronizationEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    private MonitorNotifyEventImpl(ResourceReader reader, MappingInformation mapInfo, boolean hasCalculatedTime) throws IOException {
        this.threadIndex = reader.readUint16();
        this.timeStamp = reader.readInt64();
        this.stackTraceIndex = reader.readStackTraceIndex();
        this.notifiedThreadAvail = reader.readBoolean();
        this.notifiedThreadIndex = this.notifiedThreadAvail ? reader.readUint16() : (char)'\u0000';
        this.objectId = ObjectIdentificationEventImpl.readObjectId(reader);
        if (hasCalculatedTime) {
            this.cumulatedSafepointTime = reader.readInt64();
        } else {
            double tickLength = reader.getSession().getSystemInfo().getOSCounterPeriod();
            this.cumulatedSafepointTime = (long)((double)reader.readInt64() * tickLength);
        }
    }

    @Override
    public char getNotifiedThreadIndex() {
        return this.notifiedThreadIndex;
    }

    @Override
    public long getObjectId() {
        return this.objectId;
    }

    @Override
    public int getStackTraceIndex() {
        return this.stackTraceIndex;
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public boolean hasNotifiedThread() {
        return this.notifiedThreadAvail;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.MONITOR_NOTIFY_EVENT;
    }

    @Override
    public long getCumulatedSafepointTime() {
        return this.cumulatedSafepointTime;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Timestamp           : %*t", this.timeStamp);
        stream.formatln("Notifying Thread    : %*T", this.threadIndex);
        stream.formatln("Stack trace : %*S", this.getStackTraceIndex());
        if (this.notifiedThreadAvail) {
            stream.formatln("Notified Thread     : %*T", this.notifiedThreadIndex);
        }
        stream.formatln("Object id          : %d", this.objectId);
        stream.formatln("Cumulated safepoint time : %*D", this.cumulatedSafepointTime);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)623);
        writer.writeUint16(this.threadIndex);
        writer.writeInt64(this.timeStamp);
        writer.writeInt32(this.stackTraceIndex);
        writer.writeBoolean(this.notifiedThreadAvail);
        if (this.notifiedThreadAvail) {
            writer.writeUint16(this.notifiedThreadIndex);
        }
        ObjectIdentificationEventImpl.writeObjectId(writer, this.objectId);
        writer.writeInt64(this.cumulatedSafepointTime);
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "monitor notify event";
    }
}

