/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.sync.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.sync.event.MonitorSlowEnterEvent;
import java.io.IOException;

public final class MonitorSlowEnterEventImpl
extends ProfilingPacketImpl
implements MonitorSlowEnterEvent {
    private final int stackTrace;
    private final char threadIndex;
    private final long objectId;

    public MonitorSlowEnterEventImpl(ResourceReader reader) throws IOException {
        this.stackTrace = reader.readStackTraceIndex();
        this.threadIndex = reader.readUint16();
        this.objectId = reader.readInt64();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.MONITOR_SLOW_ENTER_EVENT;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)652);
        writer.writeInt32(this.stackTrace);
        writer.writeUint16(this.threadIndex);
        writer.writeInt64(this.objectId);
        writer.finalizePacket();
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Stack trace : %*S", this.getStackTraceIndex());
        stream.formatln("Thread      : %*T", this.getThreadIndex());
        stream.formatln("Object id   : %d", this.getObjectId());
    }

    @Override
    public int getStackTraceIndex() {
        return this.stackTrace;
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public long getObjectId() {
        return this.objectId;
    }

    @Override
    public String getPacketName() {
        return "monitor slow eneter event";
    }
}

