/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.sync.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.event.ObjectIdentificationEventImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.sync.event.MonitorWaitEnterEvent;
import com.sap.jvm.profiling.sync.event.SynchronizationEventHandler;
import java.io.IOException;

public final class MonitorWaitEnterEventImpl
extends ProfilingPacketImpl
implements MonitorWaitEnterEvent {
    private final char threadIndex;
    private final long timeStamp;
    private final int stackTraceIndex;
    private final long cumulatedSafepointTime;
    private final long objectId;
    private final long timeout;

    public static MonitorWaitEnterEventImpl read(ResourceReader reader, MappingInformation mapInfo, SynchronizationEventHandler[] handlers, boolean hasCalculatedTime) throws IOException {
        MonitorWaitEnterEventImpl retValue = new MonitorWaitEnterEventImpl(reader, mapInfo, hasCalculatedTime);
        for (SynchronizationEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    private MonitorWaitEnterEventImpl(ResourceReader reader, MappingInformation mapInfo, boolean hasCalculatedTime) throws IOException {
        this.threadIndex = reader.readUint16();
        this.timeStamp = reader.readInt64();
        this.stackTraceIndex = reader.readStackTraceIndex();
        if (hasCalculatedTime) {
            this.cumulatedSafepointTime = reader.readInt64();
        } else {
            double tickLength = reader.getSession().getSystemInfo().getOSCounterPeriod();
            this.cumulatedSafepointTime = (long)((double)reader.readInt64() * tickLength);
        }
        this.objectId = ObjectIdentificationEventImpl.readObjectId(reader);
        this.timeout = reader.readInt64();
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public int getStackTraceIndex() {
        return this.stackTraceIndex;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.MONITOR_WAIT_ENTER_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Timestamp        : %*t", this.timeStamp);
        stream.formatln("Waiting Thread   : %*T", this.threadIndex);
        stream.formatln("Stack trace      : %*S", this.getStackTraceIndex());
        stream.formatln("Cumulated safepoint time : %*D", this.cumulatedSafepointTime);
        stream.formatln("Object id          : %d", this.objectId);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)621);
        writer.writeUint16(this.threadIndex);
        writer.writeInt64(this.timeStamp);
        writer.writeInt32(this.stackTraceIndex);
        writer.writeInt64(this.cumulatedSafepointTime);
        ObjectIdentificationEventImpl.writeObjectId(writer, this.objectId);
        writer.writeInt64(this.timeout);
        writer.finalizePacket();
    }

    @Override
    public long getCumulatedSafepointTime() {
        return this.cumulatedSafepointTime;
    }

    @Override
    public long getObjectId() {
        return this.objectId;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public String getPacketName() {
        return "monitor wait enter event";
    }
}

