/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.sync.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.sync.event.MonitorWaitExitEvent;
import com.sap.jvm.profiling.sync.event.MonitorWaitExitType;
import com.sap.jvm.profiling.sync.event.SynchronizationEventHandler;
import java.io.IOException;

public final class MonitorWaitExitEventImpl
extends ProfilingPacketImpl
implements MonitorWaitExitEvent {
    private final char threadIndex;
    private final long timeStamp;
    private final long cumulatedSafepointTime;
    private final MonitorWaitExitType exitType;

    public static MonitorWaitExitEventImpl read(ResourceReader reader, MappingInformation mapInfo, SynchronizationEventHandler[] handlers, boolean hasCalculatedTime) throws IOException {
        MonitorWaitExitEventImpl retValue = new MonitorWaitExitEventImpl(reader, mapInfo, hasCalculatedTime);
        for (SynchronizationEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    private MonitorWaitExitEventImpl(ResourceReader reader, MappingInformation mapInfo, boolean hasCalculatedTime) throws IOException {
        this.threadIndex = reader.readUint16();
        this.timeStamp = reader.readInt64();
        if (hasCalculatedTime) {
            this.cumulatedSafepointTime = reader.readInt64();
        } else {
            double tickLength = reader.getSession().getSystemInfo().getOSCounterPeriod();
            this.cumulatedSafepointTime = (long)((double)reader.readInt64() * tickLength);
        }
        this.exitType = MonitorWaitExitType.get(reader.readInt8());
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.MONITOR_WAIT_EXIT_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Timestamp        : %*t", this.timeStamp);
        stream.formatln("Unblocked Thread : %*T", this.threadIndex);
        stream.formatln("Cumulated safepoint time : %*D", this.cumulatedSafepointTime);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)622);
        writer.writeUint16(this.threadIndex);
        writer.writeInt64(this.timeStamp);
        writer.writeInt64(this.cumulatedSafepointTime);
        writer.writeInt8(this.exitType.getValue());
        writer.finalizePacket();
    }

    @Override
    public long getCumulatedSafepointTime() {
        return this.cumulatedSafepointTime;
    }

    @Override
    public MonitorWaitExitType getExitType() {
        return this.exitType;
    }

    @Override
    public String getPacketName() {
        return "monitor wait exit event";
    }
}

