/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.sync.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.event.ObjectIdentificationEventImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.sync.event.SyncEnterEvent;
import java.io.IOException;

public abstract class SyncEnterEventImpl
extends ProfilingPacketImpl
implements SyncEnterEvent {
    private final long id;
    private final char threadIndex;
    private final long timeStamp;
    private final int stackTraceIndex;
    private final char blockerThreadIndex;
    private final boolean blockerThreadAvail;
    private final long cumulatedSafepointTime;
    private final long objectId;
    private final long lockCount;

    protected SyncEnterEventImpl(ResourceReader reader, MappingInformation mapInfo, boolean hasCalculatedTime, long id) throws IOException {
        this.id = id;
        this.threadIndex = reader.readUint16();
        this.timeStamp = reader.readInt64();
        this.blockerThreadAvail = reader.readBoolean();
        this.blockerThreadIndex = this.blockerThreadAvail ? reader.readUint16() : (char)'\u0000';
        this.stackTraceIndex = reader.readStackTraceIndex();
        if (hasCalculatedTime) {
            this.cumulatedSafepointTime = reader.readInt64();
        } else {
            double tickLength = reader.getSession().getSystemInfo().getOSCounterPeriod();
            this.cumulatedSafepointTime = (long)((double)reader.readInt64() * tickLength);
        }
        this.objectId = ObjectIdentificationEventImpl.readObjectId(reader);
        this.lockCount = reader.readInt64();
    }

    protected SyncEnterEventImpl(ResourceReader reader, MappingInformation mapInfo, boolean hasCalculatedTime) throws IOException {
        this.id = reader.readInt64();
        this.threadIndex = reader.readUint16();
        this.timeStamp = reader.readInt64();
        this.blockerThreadAvail = reader.readBoolean();
        this.blockerThreadIndex = this.blockerThreadAvail ? reader.readUint16() : (char)'\u0000';
        this.stackTraceIndex = reader.readStackTraceIndex();
        if (hasCalculatedTime) {
            this.cumulatedSafepointTime = reader.readInt64();
        } else {
            double tickLength = reader.getSession().getSystemInfo().getOSCounterPeriod();
            this.cumulatedSafepointTime = (long)((double)reader.readInt64() * tickLength);
        }
        this.objectId = ObjectIdentificationEventImpl.readObjectId(reader);
        this.lockCount = reader.readInt64();
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public int getStackTraceIndex() {
        return this.stackTraceIndex;
    }

    @Override
    public boolean hasBlockerThread() {
        return this.blockerThreadAvail;
    }

    @Override
    public char getBlockerThreadIndex() {
        return this.blockerThreadIndex;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Id                  : %d", this.id);
        stream.formatln("Timestamp           : %*t", this.timeStamp);
        stream.formatln("Blocked Thread      : %*T", this.threadIndex);
        stream.formatln("Stack trace : %*S", this.getStackTraceIndex());
        if (this.blockerThreadAvail) {
            stream.formatln("Blocker Thread      : %*T", this.blockerThreadIndex);
        }
        stream.formatln("Cumulated safepoint time : %*D", this.cumulatedSafepointTime);
        stream.formatln("Object id          : %d", this.objectId);
        stream.formatln("Lock count         : %d", this.lockCount);
    }

    protected void write(PacketResourceWriter writer, short type) throws IOException {
        writer.initializePacket(type);
        writer.writeInt64(this.id);
        writer.writeUint16(this.threadIndex);
        writer.writeInt64(this.timeStamp);
        writer.writeBoolean(this.blockerThreadAvail);
        if (this.blockerThreadAvail) {
            writer.writeUint16(this.blockerThreadIndex);
        }
        writer.writeInt32(this.stackTraceIndex);
        writer.writeInt64(this.cumulatedSafepointTime);
        ObjectIdentificationEventImpl.writeObjectId(writer, this.objectId);
        writer.writeInt64(this.lockCount);
        writer.finalizePacket();
    }

    @Override
    public long getCumulatedSafepointTime() {
        return this.cumulatedSafepointTime;
    }

    @Override
    public long getObjectId() {
        return this.objectId;
    }

    @Override
    public long getLockCount() {
        return this.lockCount;
    }

    @Override
    public long getId() {
        return this.id;
    }
}

