/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.sync.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.sync.event.SyncEnteredEvent;
import java.io.IOException;

public abstract class SyncEnteredEventImpl
extends ProfilingPacketImpl
implements SyncEnteredEvent {
    private final char threadIndex;
    private final long timeStamp;
    private final long cumulatedSafepointTime;

    protected SyncEnteredEventImpl(ResourceReader reader, MappingInformation mapInfo, boolean hasCalculatedTime) throws IOException {
        this.threadIndex = reader.readUint16();
        this.timeStamp = reader.readInt64();
        if (hasCalculatedTime) {
            this.cumulatedSafepointTime = reader.readInt64();
        } else {
            double tickLength = reader.getSession().getSystemInfo().getOSCounterPeriod();
            this.cumulatedSafepointTime = (long)((double)reader.readInt64() * tickLength);
        }
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Unblocked Thread : %*T", this.threadIndex);
        stream.formatln("Timestamp        : %*t", this.timeStamp);
        stream.formatln("Cumulated safepoint time : %*D", this.cumulatedSafepointTime);
    }

    protected void write(PacketResourceWriter writer, short type) throws IOException {
        writer.initializePacket(type);
        writer.writeUint16(this.threadIndex);
        writer.writeInt64(this.timeStamp);
        writer.writeInt64(this.cumulatedSafepointTime);
        writer.finalizePacket();
    }

    @Override
    public long getCumulatedSafepointTime() {
        return this.cumulatedSafepointTime;
    }
}

