/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.sync.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.event.ObjectIdentificationEventImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.sync.event.SyncExitEvent;
import java.io.IOException;

public abstract class SyncExitEventImpl
extends ProfilingPacketImpl
implements SyncExitEvent {
    private final long id;
    private final char threadIndex;
    private final long timeStamp;
    private final char successorThreadIndex;
    private final boolean successorThreadAvail;
    private final long cumulatedSafepointTime;
    private final long objectId;
    private final int stackTraceIndex;
    private final long lockCount;

    protected SyncExitEventImpl(ResourceReader reader, MappingInformation mapInfo, boolean hasCalculatedTime, long id, boolean withSuccessor) throws IOException {
        this.id = id;
        this.threadIndex = reader.readUint16();
        this.timeStamp = reader.readInt64();
        this.successorThreadAvail = withSuccessor ? reader.readBoolean() : false;
        char c = this.successorThreadIndex = this.successorThreadAvail ? reader.readUint16() : (char)'\u0000';
        if (hasCalculatedTime) {
            this.cumulatedSafepointTime = reader.readInt64();
        } else {
            double tickLength = reader.getSession().getSystemInfo().getOSCounterPeriod();
            this.cumulatedSafepointTime = (long)((double)reader.readInt64() * tickLength);
        }
        this.objectId = ObjectIdentificationEventImpl.readObjectId(reader);
        this.stackTraceIndex = reader.readStackTraceIndex();
        this.lockCount = reader.readInt64();
    }

    protected SyncExitEventImpl(ResourceReader reader, MappingInformation mapInfo, boolean hasCalculatedTime, boolean withSuccessor) throws IOException {
        this.id = reader.readInt64();
        this.threadIndex = reader.readUint16();
        this.timeStamp = reader.readInt64();
        this.successorThreadAvail = withSuccessor ? reader.readBoolean() : false;
        char c = this.successorThreadIndex = this.successorThreadAvail ? reader.readUint16() : (char)'\u0000';
        if (hasCalculatedTime) {
            this.cumulatedSafepointTime = reader.readInt64();
        } else {
            double tickLength = reader.getSession().getSystemInfo().getOSCounterPeriod();
            this.cumulatedSafepointTime = (long)((double)reader.readInt64() * tickLength);
        }
        this.objectId = ObjectIdentificationEventImpl.readObjectId(reader);
        this.stackTraceIndex = reader.readStackTraceIndex();
        this.lockCount = reader.readInt64();
    }

    @Override
    public long getCumulatedSafepointTime() {
        return this.cumulatedSafepointTime;
    }

    @Override
    public long getObjectId() {
        return this.objectId;
    }

    protected char getSuccessorThreadIndex() {
        return this.successorThreadIndex;
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    protected boolean hasSuccessorThread() {
        return this.successorThreadAvail;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Id                  : %d", this.id);
        stream.formatln("Timestamp           : %*t", this.timeStamp);
        stream.formatln("Exiting Thread      : %*T", this.threadIndex);
        stream.formatln("Stack trace : %*S", this.getStackTraceIndex());
        if (this.successorThreadAvail) {
            stream.formatln("Successor Thread     : %*T", this.successorThreadIndex);
        }
        stream.formatln("Cumulated safepoint time : %*D", this.cumulatedSafepointTime);
        stream.formatln("Object id          : %d", this.objectId);
        stream.formatln("Lock count         : %d", this.lockCount);
    }

    protected void write(PacketResourceWriter writer, short type, boolean withSuccessor) throws IOException {
        writer.initializePacket(type);
        writer.writeInt64(this.id);
        writer.writeUint16(this.threadIndex);
        writer.writeInt64(this.timeStamp);
        if (withSuccessor) {
            writer.writeBoolean(this.successorThreadAvail);
            if (this.successorThreadAvail) {
                writer.writeUint16(this.successorThreadIndex);
            }
        }
        writer.writeInt64(this.cumulatedSafepointTime);
        ObjectIdentificationEventImpl.writeObjectId(writer, this.objectId);
        writer.writeInt32(this.stackTraceIndex);
        writer.writeInt64(this.lockCount);
        writer.finalizePacket();
    }

    @Override
    public int getStackTraceIndex() {
        return this.stackTraceIndex;
    }

    @Override
    public long getLockCount() {
        return this.lockCount;
    }

    @Override
    public long getId() {
        return this.id;
    }
}

