/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.sync.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.sync.command.SynchronizationTraceConfiguration;
import com.sap.jvm.profiling.sync.event.SynchronizationEventHandler;
import com.sap.jvm.profiling.sync.response.EnableSynchronizationTraceResponse;
import java.io.IOException;

public final class EnableSynchronizationTraceResponseImpl
extends ResponseImpl
implements EnableSynchronizationTraceResponse {
    private final SynchronizationTraceConfiguration configuration = new SynchronizationTraceConfiguration();

    public static EnableSynchronizationTraceResponseImpl read(ResourceReader reader, SynchronizationEventHandler[] handlers) throws IOException {
        EnableSynchronizationTraceResponseImpl retValue = new EnableSynchronizationTraceResponseImpl(reader);
        for (SynchronizationEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    private EnableSynchronizationTraceResponseImpl(ResourceReader reader) throws IOException {
        super("enable synchronization trace response", reader);
        this.configuration.setThreadFilter(reader.readNewThreadFilter());
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1047);
        this.writeInternal(writer);
        writer.writeNewThreadFilter(this.configuration.getThreadFilter());
        writer.finalizePacket();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ENABLE_SYNCHRONIZATION_TRACE_RESPONSE;
    }

    @Override
    public SynchronizationTraceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
        ThreadFilter threadFilter = this.configuration.getThreadFilter();
        stream.formatln("Thread filter         : %s", threadFilter == null ? "**" : threadFilter.asString());
    }
}

