/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.thread;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.impl.thread.ThreadDumpItemImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.thread.ThreadDump;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class ThreadDumpImpl
implements ThreadDump {
    private long timeStamp;
    private final ThreadDumpItem[] threadDumpItems;
    private Map<Integer, ThreadDumpItem> threadDumpIndexMap = new TreeMap<Integer, ThreadDumpItem>();

    public ThreadDumpImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.timeStamp = reader.readInt64();
        int numThreads = reader.readInt32();
        this.threadDumpItems = new ThreadDumpItem[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            this.threadDumpItems[i] = ThreadDumpItemImpl.read(reader, mapInfo);
        }
        int extensionNumber = 1;
        while (reader.hasNext()) {
            for (int i = 0; i < numThreads; ++i) {
                ((ThreadDumpItemImpl)this.threadDumpItems[i]).readExtension(reader, extensionNumber);
            }
            ++extensionNumber;
        }
        this.prepare();
    }

    public ThreadDumpImpl(long timeStamp, ThreadDumpItem[] threadDumpItems) {
        this.timeStamp = timeStamp;
        this.threadDumpItems = threadDumpItems;
        this.prepare();
    }

    private void prepare() {
        TreeMap<Integer, HashSet<MonitorObject>> contentedMonitorObjects = new TreeMap<Integer, HashSet<MonitorObject>>();
        for (ThreadDumpItem item : this.threadDumpItems) {
            this.threadDumpIndexMap.put(item.getThreadIndex(), item);
            int blockingThreadIndex = item.getBlockingThreadIndex();
            MonitorObject blockingMonitor = item.getMonitorObject();
            if (blockingMonitor == null || blockingThreadIndex < 0) continue;
            HashSet<MonitorObject> threadMonitors = (HashSet<MonitorObject>)contentedMonitorObjects.get(blockingThreadIndex);
            if (threadMonitors == null) {
                threadMonitors = new HashSet<MonitorObject>();
                contentedMonitorObjects.put(blockingThreadIndex, threadMonitors);
            }
            threadMonitors.add(blockingMonitor);
        }
        for (ThreadDumpItem item : this.threadDumpItems) {
            Set threadMonitors = (Set)contentedMonitorObjects.get(item.getThreadIndex());
            if (threadMonitors != null) {
                item.calcBlockedMonitorObjects(threadMonitors);
            }
            if (!item.hasBlockingThread() || item.getDeadlockCycleIndex() != 0) continue;
            HashSet<ThreadDumpItem> visited = new HashSet<ThreadDumpItem>();
            ThreadDumpItem curThreadDump = item;
            while (curThreadDump != null && curThreadDump.hasBlockingThread() && curThreadDump.getDeadlockCycleIndex() == 0 && !visited.contains(curThreadDump)) {
                visited.add(curThreadDump);
                curThreadDump = this.threadDumpIndexMap.get(curThreadDump.getBlockingThreadIndex());
            }
            if (curThreadDump == null || curThreadDump.getDeadlockCycleIndex() <= 0) continue;
            item.setBlockedDeadlockCycleIndex(curThreadDump.getDeadlockCycleIndex());
        }
    }

    @Override
    public ThreadDumpItem getThreadDumpItemWithThreadIndex(int threadIndex) {
        return this.threadDumpIndexMap.get(threadIndex);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt64(this.timeStamp);
        writer.writeInt32(this.threadDumpItems.length);
        for (ThreadDumpItem threadInfo : this.threadDumpItems) {
            threadInfo.write(writer);
        }
        for (int extensionNumber = 1; extensionNumber <= 1; ++extensionNumber) {
            for (ThreadDumpItem threadInfo : this.threadDumpItems) {
                threadInfo.writeExtension(writer, extensionNumber);
            }
        }
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public int getNumThreads() {
        return this.threadDumpItems.length;
    }

    @Override
    public ThreadDumpItem[] getThreadDumpItems() {
        return this.threadDumpItems;
    }

    @Override
    public void print(ProfilingPrintStream stream, boolean includeThreadContent) {
        stream.formatln("Timestamp          : %*r", this.getTimeStamp());
        stream.println("Threads: (" + this.getThreadDumpItems().length + ")");
        if (includeThreadContent) {
            for (ThreadDumpItem threadDumpInfo : this.getThreadDumpItems()) {
                threadDumpInfo.print(stream);
            }
        }
    }

    @Override
    public ThreadDumpItem[] getDeadlocks() {
        ArrayList<ThreadDumpItem> deadlockedItems = new ArrayList<ThreadDumpItem>();
        for (ThreadDumpItem item : this.threadDumpItems) {
            if (item.getDeadlockCycleIndex() <= 0) continue;
            deadlockedItems.add(item);
        }
        return deadlockedItems.toArray(new ThreadDumpItem[0]);
    }
}

