/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.thread;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.ThreadAnnotation;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ThreadAnnotationImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.thread.SocketObject;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadPriority;
import com.sap.jvm.profiling.thread.ThreadStatus;
import com.sap.jvm.tracing.Trace;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ThreadDumpItemImpl
implements ThreadDumpItem {
    private static UTF8String emptyStr = UTF8Creator.create("");
    private int threadIndex;
    private long kernelId;
    private long pthreadId;
    private long nativeId;
    private long javaThreadId;
    private ThreadStatus status = ThreadStatus.THREAD_STATUS_UNKNOWN;
    private ThreadPriority priority = ThreadPriority.UNKNOWN_PRIORITY;
    private boolean isDaemon;
    private UTF8String name = emptyStr;
    private ThreadAnnotation[] annotations;
    private UTF8String threadGroupName = emptyStr;
    private int stackTraceIndex = -1;
    private int topFrameType;
    private long[] cpuTime = new long[2];
    private long[] elapsedTime = new long[2];
    private long[] memoryConsumption = new long[2];
    private long[] fileBytesRead = new long[2];
    private long[] fileBytesWritten = new long[2];
    private long[] socketBytesRead = new long[2];
    private long[] socketBytesWritten = new long[2];
    private long[] numFilesOpen = new long[2];
    private long[] numSocketsOpen = new long[2];
    private ClassLoaderObject contextClassLoader;
    private long contentedEnterCount;
    private long contentedEnterTime;
    private long monitorWaitCount;
    private long monitorWaitTime;
    private long sleepCount;
    private long sleepTime;
    private MonitorObject monitorObject;
    private int blockingThreadIndex = -1;
    private int deadlockCycleIndex = 0;
    private int bockedDeadlockCycleIndex = 0;
    private Map<Integer, List<MonitorObject>> stackMonitorObjects = new TreeMap<Integer, List<MonitorObject>>();
    private SocketObject socketInfo;
    private long numDefinedClasses = 0L;
    private Map<Integer, List<MonitorObject>> lockedMonitorObjects = new TreeMap<Integer, List<MonitorObject>>();

    private ThreadDumpItemImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.threadIndex = reader.readUint16();
        this.kernelId = reader.readInt64();
        this.pthreadId = reader.readInt64();
        this.javaThreadId = reader.readInt64();
        short statusValue = reader.readUint8();
        ThreadStatus threadStatus = ThreadStatus.THREAD_STATUS_UNKNOWN;
        try {
            threadStatus = ThreadStatus.getThreadState(statusValue);
        }
        catch (IllegalArgumentException e) {
            Trace.error(() -> "Cannot map " + statusValue + " to a known ThreadStatus.");
        }
        this.status = threadStatus;
        byte prioValue = reader.readInt8();
        ThreadPriority threadPriority = ThreadPriority.UNKNOWN_PRIORITY;
        try {
            threadPriority = ThreadPriority.getThreadPriority(prioValue);
        }
        catch (IllegalArgumentException e) {
            Trace.error(() -> "Cannot map " + prioValue + " to a known ThreadPriority.");
        }
        this.priority = threadPriority;
        this.isDaemon = reader.readBoolean();
        this.name = reader.readUTF();
        this.annotations = new ThreadAnnotationImpl[mapInfo.getNrOfAnnotationKeys()];
        for (int i = 0; i < this.annotations.length; ++i) {
            this.annotations[i] = new ThreadAnnotationImpl(i, UTF8Creator.create(""), mapInfo);
        }
        int nrOfAnnotations = reader.readInt16();
        for (int i = 0; i < nrOfAnnotations; ++i) {
            short annotationSlot = reader.readInt16();
            UTF8String annotationValue = reader.readUTF();
            ((ThreadAnnotationImpl)this.annotations[annotationSlot]).setValue(annotationValue);
        }
        this.threadGroupName = reader.readUTF();
        this.stackTraceIndex = reader.readStackTraceIndex();
        this.topFrameType = reader.readInt8();
        this.cpuTime[0] = reader.readInt64();
        this.elapsedTime[0] = reader.readInt64();
        this.memoryConsumption[0] = reader.readInt64();
        this.fileBytesRead[0] = reader.readInt64();
        this.fileBytesWritten[0] = reader.readInt64();
        this.socketBytesRead[0] = reader.readInt64();
        this.socketBytesWritten[0] = reader.readInt64();
        this.numFilesOpen[0] = reader.readInt64();
        this.numSocketsOpen[0] = reader.readInt64();
        this.contextClassLoader = reader.readClassLoaderObject();
        this.contentedEnterCount = reader.readInt64();
        this.monitorWaitCount = reader.readInt64();
        this.sleepCount = reader.readInt64();
        this.contentedEnterTime = reader.readInt64();
        this.monitorWaitTime = reader.readInt64();
        this.sleepTime = reader.readInt64();
        if (reader.readBoolean()) {
            this.monitorObject = this.readMonitorObject(reader);
            if (reader.readBoolean()) {
                this.blockingThreadIndex = reader.readUint16();
            }
            this.deadlockCycleIndex = reader.readInt32();
            assert (this.deadlockCycleIndex >= 0);
        }
        int numFrames = reader.readInt32();
        for (int i = 0; i < numFrames; ++i) {
            int frameIndex = reader.readInt32();
            int numMonitors = reader.readInt32();
            LinkedList<MonitorObject> monitors = new LinkedList<MonitorObject>();
            for (int j = 0; j < numMonitors; ++j) {
                MonitorObject monitor = this.readMonitorObject(reader);
                monitors.add(monitor);
            }
            this.stackMonitorObjects.put(frameIndex, monitors);
        }
        if (reader.readBoolean()) {
            this.socketInfo = new SocketObject(reader);
            switch (this.socketInfo.getSocketUsage()) {
                case READING: {
                    this.status = ThreadStatus.THREAD_STATUS_SOCKET_READ;
                    break;
                }
                case WRITING: {
                    this.status = ThreadStatus.THREAD_STATUS_SOCKET_WRITE;
                    break;
                }
                case ACCEPTING: {
                    this.status = ThreadStatus.THREAD_STATUS_SOCKET_ACCEPT;
                    break;
                }
                case CONNECTING: {
                    this.status = ThreadStatus.THREAD_STATUS_SOCKET_CONNECT;
                }
            }
        } else {
            this.socketInfo = null;
        }
    }

    public void readExtension(ResourceReader reader, int extensionNumber) throws IOException {
        assert (extensionNumber >= 1 && extensionNumber <= 1);
        if (extensionNumber == 1) {
            this.numDefinedClasses = reader.readInt64();
            this.nativeId = reader.readInt64();
            this.cpuTime[1] = reader.readInt64();
            this.elapsedTime[1] = reader.readInt64();
            this.memoryConsumption[1] = reader.readInt64();
            this.fileBytesRead[1] = reader.readInt64();
            this.fileBytesWritten[1] = reader.readInt64();
            this.socketBytesRead[1] = reader.readInt64();
            this.socketBytesWritten[1] = reader.readInt64();
            this.numFilesOpen[1] = reader.readInt64();
            this.numSocketsOpen[1] = reader.readInt64();
        }
    }

    @Override
    public void writeExtension(ResourceWriter writer, int extensionNumber) throws IOException {
        assert (extensionNumber >= 1 && extensionNumber <= 1);
        if (extensionNumber == 1) {
            writer.writeInt64(this.numDefinedClasses);
            writer.writeInt64(this.nativeId);
            writer.writeInt64(this.cpuTime[1]);
            writer.writeInt64(this.elapsedTime[1]);
            writer.writeInt64(this.memoryConsumption[1]);
            writer.writeInt64(this.fileBytesRead[1]);
            writer.writeInt64(this.fileBytesWritten[1]);
            writer.writeInt64(this.socketBytesRead[1]);
            writer.writeInt64(this.socketBytesWritten[1]);
            writer.writeInt64(this.numFilesOpen[1]);
            writer.writeInt64(this.numSocketsOpen[1]);
        }
    }

    private void writeMonitorObject(ResourceWriter writer, MonitorObject monitor) throws IOException {
        writer.writeInt64(0L);
        writer.writeInt64(monitor.getObjectId());
        assert (monitor.getClazzId() >= 0L);
        if (monitor.getClassObject() != null) {
            writer.writeClassObject(monitor.getClassObject());
        } else {
            writer.writeInt64(monitor.getClazzId());
        }
    }

    private MonitorObject readMonitorObject(ResourceReader reader) throws EOFException {
        reader.readInt64();
        long id = reader.readInt64();
        ClassObject clazz = reader.readClassObject();
        assert (clazz != null);
        return new MonitorObject(id, clazz);
    }

    private ThreadDumpItemImpl() {
    }

    public static ThreadDumpItem read(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        ThreadDumpItemImpl result = new ThreadDumpItemImpl(reader, mapInfo);
        result.filterSpecialMethods(reader.getSession());
        return result;
    }

    public static ThreadDumpItem create(int threadIndex, long kernelId, long nativeId, long pthreadId, ThreadStatus status, boolean isDaemon, UTF8String name, int priority, long cpuTime, long elapsedTime, long memoryConsumption, long numFilesOpen, long numSocketsOpen, long[] fileBytes, long[] socketBytes, long cpuTimeReset, long elapsedTimeReset, long memoryConsumptionReset, long numFilesOpenReset, long numSocketsOpenReset, long[] fileBytesReset, long[] socketBytesReset, SocketObject socketInfo, MonitorObject blocker, Map<Integer, List<MonitorObject>> stackLocks, int stackTraceIndex) {
        ThreadDumpItemImpl result = new ThreadDumpItemImpl();
        result.threadIndex = threadIndex;
        result.kernelId = kernelId;
        result.nativeId = nativeId;
        result.pthreadId = pthreadId;
        result.status = status;
        result.isDaemon = isDaemon;
        result.name = name;
        result.stackTraceIndex = stackTraceIndex;
        result.cpuTime[0] = cpuTime;
        result.elapsedTime[0] = elapsedTime;
        result.memoryConsumption[0] = memoryConsumption;
        result.numFilesOpen[0] = numFilesOpen;
        result.numSocketsOpen[0] = numSocketsOpen;
        result.fileBytesRead[0] = fileBytes != null ? fileBytes[0] : 0L;
        result.fileBytesWritten[0] = fileBytes != null ? fileBytes[1] : 0L;
        result.socketBytesRead[0] = socketBytes != null ? socketBytes[0] : 0L;
        result.socketBytesWritten[0] = socketBytes != null ? socketBytes[1] : 0L;
        result.cpuTime[1] = cpuTimeReset;
        result.elapsedTime[1] = elapsedTimeReset;
        result.memoryConsumption[1] = memoryConsumptionReset;
        result.numFilesOpen[1] = numFilesOpenReset;
        result.numSocketsOpen[1] = numSocketsOpenReset;
        result.fileBytesRead[1] = fileBytesReset != null ? fileBytesReset[0] : 0L;
        result.fileBytesWritten[1] = fileBytesReset != null ? fileBytesReset[1] : 0L;
        result.socketBytesRead[1] = socketBytesReset != null ? socketBytesReset[0] : 0L;
        result.socketBytesWritten[1] = socketBytesReset != null ? socketBytesReset[1] : 0L;
        result.socketInfo = socketInfo;
        result.stackMonitorObjects.putAll(stackLocks);
        result.monitorObject = blocker;
        try {
            result.priority = ThreadPriority.getThreadPriority(priority);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return result;
    }

    private void filterSpecialMethods(ProfilingSession session) {
        if (this.status == ThreadStatus.THREAD_STATUS_RUNNING || this.status == ThreadStatus.THREAD_STATUS_UNKNOWN) {
            StackFrames stacktrace = session.getStackTraceManager().getStackFramesObject(true);
            stacktrace.fillIn(this.stackTraceIndex);
            String fullMethodName = stacktrace.getMethod(stacktrace.getNrOfFrames() - 1).getFullName();
            int signatureSeparator = fullMethodName.indexOf(40);
            String methodName = fullMethodName.substring(0, signatureSeparator);
            ThreadStatus specialStatus = ThreadStatus.isSpecialMethod(methodName);
            if (specialStatus != null) {
                this.status = specialStatus;
            }
        }
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeUint16((char)this.threadIndex);
        writer.writeInt64(this.kernelId);
        writer.writeInt64(this.pthreadId);
        writer.writeInt64(this.javaThreadId);
        writer.writeInt8(this.status.getValue());
        writer.writeInt8(this.priority.getValue());
        writer.writeBoolean(this.isDaemon);
        writer.writeUTF(this.name.getBytes());
        if (this.annotations != null) {
            short i;
            int numAnnotations = 0;
            for (i = 0; i < this.annotations.length; i = (short)((short)(i + 1))) {
                if (this.annotations[i].getValue().isEmpty()) continue;
                ++numAnnotations;
            }
            writer.writeInt16((short)numAnnotations);
            for (i = 0; i < this.annotations.length; i = (short)(i + 1)) {
                UTF8String annotationValue = this.annotations[i].getValue();
                if (annotationValue.isEmpty()) continue;
                writer.writeInt16(i);
                writer.writeUTF(annotationValue);
            }
        } else {
            writer.writeInt16((short)0);
        }
        writer.writeUTF(this.threadGroupName.getBytes());
        writer.writeInt32(this.stackTraceIndex);
        writer.writeInt8(this.topFrameType);
        writer.writeInt64(this.cpuTime[0]);
        writer.writeInt64(this.elapsedTime[0]);
        writer.writeInt64(this.memoryConsumption[0]);
        writer.writeInt64(this.fileBytesRead[0]);
        writer.writeInt64(this.fileBytesWritten[0]);
        writer.writeInt64(this.socketBytesRead[0]);
        writer.writeInt64(this.socketBytesWritten[0]);
        writer.writeInt64(this.numFilesOpen[0]);
        writer.writeInt64(this.numSocketsOpen[0]);
        writer.writeClassLoaderObject(this.contextClassLoader);
        writer.writeInt64(this.contentedEnterCount);
        writer.writeInt64(this.monitorWaitCount);
        writer.writeInt64(this.sleepCount);
        writer.writeInt64(this.contentedEnterTime);
        writer.writeInt64(this.monitorWaitTime);
        writer.writeInt64(this.sleepTime);
        if (this.monitorObject != null) {
            writer.writeBoolean(true);
            this.writeMonitorObject(writer, this.monitorObject);
            if (this.blockingThreadIndex != -1) {
                writer.writeBoolean(true);
                writer.writeUint16((char)this.blockingThreadIndex);
            } else {
                writer.writeBoolean(false);
            }
            writer.writeInt32(this.deadlockCycleIndex);
        } else {
            writer.writeBoolean(false);
        }
        writer.writeInt32(this.stackMonitorObjects.values().size());
        for (Map.Entry<Integer, List<MonitorObject>> stackMonitorEntry : this.stackMonitorObjects.entrySet()) {
            writer.writeInt32(stackMonitorEntry.getKey());
            List<MonitorObject> monitors = stackMonitorEntry.getValue();
            writer.writeInt32(monitors.size());
            for (MonitorObject monitor : monitors) {
                this.writeMonitorObject(writer, monitor);
            }
        }
        if (this.socketInfo != null) {
            writer.writeBoolean(true);
            this.socketInfo.write(writer);
        } else {
            writer.writeBoolean(false);
        }
    }

    @Override
    public int getStackTraceIndex() {
        return this.stackTraceIndex;
    }

    @Override
    public int getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public long getKernelId() {
        return this.kernelId;
    }

    @Override
    public long getPthreadId() {
        return this.pthreadId;
    }

    @Override
    public long getNativeId() {
        return this.nativeId;
    }

    @Override
    public long getJavaThreadId() {
        return this.javaThreadId;
    }

    @Override
    public ThreadStatus getStatus() {
        return this.status;
    }

    @Override
    public ThreadPriority getPriority() {
        return this.priority;
    }

    @Override
    public boolean isDaemon() {
        return this.isDaemon;
    }

    @Override
    public UTF8String getName() {
        return this.name;
    }

    @Override
    public UTF8String getThreadGroupName() {
        return this.threadGroupName;
    }

    @Override
    public int getTopFrameType() {
        return this.topFrameType;
    }

    @Override
    public long getCpuTime(boolean reset) {
        return this.cpuTime[reset ? 1 : 0];
    }

    @Override
    public long getElapsedTime(boolean reset) {
        return this.elapsedTime[reset ? 1 : 0];
    }

    @Override
    public long getMemoryConsumption(boolean reset) {
        return this.memoryConsumption[reset ? 1 : 0];
    }

    @Override
    public long getFileBytesRead(boolean reset) {
        return this.fileBytesRead[reset ? 1 : 0];
    }

    @Override
    public long getFileBytesWritten(boolean reset) {
        return this.fileBytesWritten[reset ? 1 : 0];
    }

    @Override
    public long getSocketBytesRead(boolean reset) {
        return this.socketBytesRead[reset ? 1 : 0];
    }

    @Override
    public long getSocketBytesWritten(boolean reset) {
        return this.socketBytesWritten[reset ? 1 : 0];
    }

    @Override
    public long getNumFilesOpen(boolean reset) {
        return this.numFilesOpen[reset ? 1 : 0];
    }

    @Override
    public long getNumSocketsOpen(boolean reset) {
        return this.numSocketsOpen[reset ? 1 : 0];
    }

    @Override
    public ClassLoaderObject getContextClassLoader() {
        return this.contextClassLoader;
    }

    @Override
    public long getContentedEnterCount() {
        return this.contentedEnterCount;
    }

    @Override
    public long getContentedEnterTime() {
        return this.contentedEnterTime;
    }

    @Override
    public long getMonitorWaitCount() {
        return this.monitorWaitCount;
    }

    @Override
    public long getMonitorWaitTime() {
        return this.monitorWaitTime;
    }

    @Override
    public long getSleepCount() {
        return this.sleepCount;
    }

    @Override
    public long getSleepTime() {
        return this.sleepTime;
    }

    @Override
    public MonitorObject getMonitorObject() {
        return this.monitorObject;
    }

    public void setMonitorObject(MonitorObject monitorObject) {
        this.monitorObject = monitorObject;
    }

    @Override
    public int getBlockingThreadIndex() {
        return this.blockingThreadIndex;
    }

    @Override
    public void setBlockingThreadIndex(int index) {
        this.blockingThreadIndex = index;
    }

    @Override
    public boolean hasBlockingThread() {
        return this.blockingThreadIndex != -1;
    }

    @Override
    public boolean isDeadlocked() {
        return this.deadlockCycleIndex > 0 || this.bockedDeadlockCycleIndex > 0;
    }

    @Override
    public int getBlockedDeadlockCycleIndex() {
        return this.bockedDeadlockCycleIndex;
    }

    @Override
    public void setBlockedDeadlockCycleIndex(int cycleIndex) {
        this.bockedDeadlockCycleIndex = cycleIndex;
    }

    @Override
    public int getDeadlockCycleIndex() {
        return this.deadlockCycleIndex;
    }

    @Override
    public void setDeadlockCycleIndex(int cycleIndex) {
        this.deadlockCycleIndex = cycleIndex;
    }

    @Override
    public void setStatus(ThreadStatus status) {
        this.status = status;
    }

    @Override
    public final List<MonitorObject> getFrameMonitorObjects(int frameIndex) {
        return this.lockedMonitorObjects.get(frameIndex);
    }

    @Override
    public SocketObject getSocketInfo() {
        return this.socketInfo;
    }

    @Override
    public long getNumDefinedClasses() {
        return this.numDefinedClasses;
    }

    @Override
    public ThreadAnnotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public final List<MonitorObject> getNoFrameMonitorObjects() {
        return this.lockedMonitorObjects.get(Integer.MAX_VALUE);
    }

    @Override
    public void calcBlockedMonitorObjects(Set<MonitorObject> lockedMonitors) {
        this.lockedMonitorObjects.clear();
        LinkedList<MonitorObject> noFrameMonitors = new LinkedList<MonitorObject>();
        this.lockedMonitorObjects.put(Integer.MAX_VALUE, noFrameMonitors);
        HashSet<MonitorObject> tmpMonitors = new HashSet<MonitorObject>(lockedMonitors.size());
        tmpMonitors.addAll(lockedMonitors);
        for (Map.Entry<Integer, List<MonitorObject>> frameMonitors : this.stackMonitorObjects.entrySet()) {
            Integer frameIndex = frameMonitors.getKey();
            List<MonitorObject> blockedFrameList = this.lockedMonitorObjects.get(frameIndex);
            for (MonitorObject frameMonitor : frameMonitors.getValue()) {
                if (!tmpMonitors.contains(frameMonitor)) continue;
                if (blockedFrameList == null) {
                    blockedFrameList = new LinkedList<MonitorObject>();
                    this.lockedMonitorObjects.put(frameIndex, blockedFrameList);
                }
                blockedFrameList.add(frameMonitor);
                tmpMonitors.remove(frameMonitor);
            }
        }
        for (MonitorObject noFrameMonitor : tmpMonitors) {
            noFrameMonitors.add(noFrameMonitor);
        }
    }

    private void incValues(long[] dest, long[] inc) {
        for (int i = 0; i < inc.length && i < dest.length; ++i) {
            int n = i;
            dest[n] = dest[n] + inc[i];
        }
    }

    @Override
    public void add(ThreadDumpItem info) {
        this.incValues(this.cpuTime, ((ThreadDumpItemImpl)info).cpuTime);
        this.incValues(this.elapsedTime, ((ThreadDumpItemImpl)info).elapsedTime);
        this.incValues(this.memoryConsumption, ((ThreadDumpItemImpl)info).memoryConsumption);
        this.incValues(this.fileBytesRead, ((ThreadDumpItemImpl)info).fileBytesRead);
        this.incValues(this.fileBytesWritten, ((ThreadDumpItemImpl)info).fileBytesWritten);
        this.incValues(this.socketBytesRead, ((ThreadDumpItemImpl)info).socketBytesRead);
        this.incValues(this.socketBytesWritten, ((ThreadDumpItemImpl)info).socketBytesWritten);
        this.incValues(this.numFilesOpen, ((ThreadDumpItemImpl)info).numFilesOpen);
        this.incValues(this.numSocketsOpen, ((ThreadDumpItemImpl)info).numSocketsOpen);
        this.numDefinedClasses += info.getNumDefinedClasses();
        this.contentedEnterCount += info.getContentedEnterCount();
        this.contentedEnterTime += info.getContentedEnterTime();
        this.monitorWaitCount += info.getMonitorWaitCount();
        this.monitorWaitTime += info.getMonitorWaitTime();
        this.sleepCount += info.getSleepCount();
        this.sleepTime += info.getSleepTime();
    }

    @Override
    public ThreadDumpItem createEmptyItem() {
        return new ThreadDumpItemImpl();
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.formatln("Thread             : %*T", this.getThreadIndex());
        stream.formatln("KernelId           : %d", this.getKernelId());
        stream.formatln("PthreadId          : %d", this.getPthreadId());
        stream.formatln("JavaId             : %d", this.getJavaThreadId());
        stream.formatln("Status             : " + this.getStatus().getDisplayText(), new Object[0]);
        stream.formatln("Priority           : %s", new Object[]{this.getPriority()});
        stream.formatln("Daemon             : " + (this.isDaemon() ? "true" : "false"), new Object[0]);
        stream.formatln("Name               : " + this.getName().toString(), new Object[0]);
        stream.formatln("ThreadGroup        : " + this.getThreadGroupName(), new Object[0]);
        if (this.getContextClassLoader() != null) {
            // empty if block
        }
        stream.formatln("Defined classes    : %d", this.getNumDefinedClasses());
        stream.formatln("CPU [reset]               : %d [%d]", this.getCpuTime(false), this.getCpuTime(true));
        stream.formatln("Elapsed time [reset]      : %d [%d]", this.getElapsedTime(false), this.getElapsedTime(true));
        stream.formatln("Memory [reset]            : %*B [%*B]", this.getMemoryConsumption(false), this.getMemoryConsumption(true));
        stream.formatln("FileBytesRead [reset]     : %*B [%*B]", this.getFileBytesRead(false), this.getFileBytesRead(true));
        stream.formatln("FileBytesWritten [reset]  : %*B [%*B]", this.getFileBytesWritten(false), this.getFileBytesWritten(true));
        stream.formatln("SocketBytesRead [reset]   : %*B [%*B]", this.getSocketBytesRead(false), this.getSocketBytesRead(true));
        stream.formatln("SocketBytesWritten [reset]: %*B [%*B]", this.getSocketBytesWritten(false), this.getSocketBytesWritten(true));
        stream.formatln("#Files open [reset]       : %d [%d]", this.getNumFilesOpen(false), this.getNumFilesOpen(true));
        stream.formatln("#Sockets open [reset]     : %d [%d]", this.getNumSocketsOpen(false), this.getNumSocketsOpen(true));
        if (this.getContentedEnterCount() >= 0L) {
            stream.formatln("#ContentedEnter    : %d", this.getContentedEnterCount());
            stream.formatln("ContentedEnterTime : %d", this.getContentedEnterTime());
        }
        if (this.getMonitorWaitCount() >= 0L) {
            stream.formatln("#MonitorWait       : %d", this.getMonitorWaitCount());
            stream.formatln("ContentedEnterTime : %d", this.getMonitorWaitTime());
        }
        if (this.getSleepCount() >= 0L) {
            stream.formatln("#Sleep             : %d", this.getSleepCount());
            stream.formatln("SleepTime          : %d", this.getSleepTime());
        }
        if (this.getMonitorObject() != null) {
            // empty if block
        }
        if (this.getBlockingThreadIndex() >= 0) {
            stream.formatln("Blocking thread    : %d", this.getBlockingThreadIndex());
        }
        if (this.getDeadlockCycleIndex() > 0) {
            stream.formatln("Deadlock cycle     : %d", this.getDeadlockCycleIndex());
        } else if (this.getBlockedDeadlockCycleIndex() > 0) {
            stream.formatln("Deadlock cycle     : (%d)", this.getBlockedDeadlockCycleIndex());
        }
    }
}

