/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.thread;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.thread.SocketObject;
import com.sap.jvm.profiling.thread.ThreadDump;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadDumps;
import com.sap.jvm.profiling.thread.ThreadDumpsNotMatchException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ThreadDumpsImpl
implements ThreadDumps {
    private List<ThreadDumpItem[]> threadDumps;
    private long[] timestamps;
    private ThreadDump[] threadDumpsRaw;
    private List<Map<Integer, Integer>> threadIndexMaps;
    private Map<ThreadDumpItem, Integer> threadItemMap;
    private ProfilingSession session;

    public ThreadDumpsImpl(ThreadDump[] threadDumpsRaw, ProfilingSession session, ProgressReporter reporter) throws ThreadDumpsNotMatchException, OperationCanceledException {
        int dumpIndex;
        this.session = session;
        this.threadDumpsRaw = threadDumpsRaw;
        this.threadDumps = new ArrayList<ThreadDumpItem[]>(threadDumpsRaw[0].getNumThreads());
        int numDumps = threadDumpsRaw.length;
        this.timestamps = new long[numDumps];
        reporter.setWork(I18n._s("Analyzing the thread runs... (<%>% done)"), numDumps);
        for (dumpIndex = 0; dumpIndex < numDumps; ++dumpIndex) {
            int j;
            ThreadDump dump = threadDumpsRaw[dumpIndex];
            ThreadDumpItem[] rawItems = dump.getThreadDumpItems();
            this.timestamps[dumpIndex] = dump.getTimeStamp();
            if (dumpIndex == 0) {
                for (j = 0; j < rawItems.length; ++j) {
                    ThreadDumpItem[] threadRun = new ThreadDumpItem[numDumps];
                    threadRun[0] = dump.getThreadDumpItems()[j];
                    this.threadDumps.add(threadRun);
                }
            } else {
                assert (dumpIndex > 0);
                if (this.timestamps[dumpIndex] < this.timestamps[dumpIndex - 1]) {
                    throw new ThreadDumpsNotMatchException(dump, dumpIndex, "Timestamps are not increasing.");
                }
                for (j = 0; j < rawItems.length; ++j) {
                    ThreadDumpItem item = rawItems[j];
                    ThreadDumpItem[] threadRun = this.getThreadRun(item, dumpIndex, j);
                    if (threadRun == null) {
                        threadRun = new ThreadDumpItem[numDumps];
                        this.threadDumps.add(threadRun);
                    }
                    threadRun[dumpIndex] = item;
                    if (this.itemIsDominated(threadRun[dumpIndex - 1], threadRun[dumpIndex])) continue;
                    throw new ThreadDumpsNotMatchException(threadRun, dumpIndex, String.format("Thread with name '%s' makes negative progress from dump with index %d to index %d", threadRun[dumpIndex].getName().toString(), dumpIndex - 1, dumpIndex));
                }
            }
            reporter.reportNextOrThrow();
        }
        this.threadIndexMaps = new ArrayList<Map<Integer, Integer>>(numDumps);
        this.threadItemMap = new HashMap<ThreadDumpItem, Integer>(this.getNumThreads() * this.getNumDumps());
        for (dumpIndex = 0; dumpIndex < numDumps; ++dumpIndex) {
            this.threadIndexMaps.add(this.createThreadRunIndexMap(dumpIndex));
            ThreadDump threadDump = this.getThreadDumps()[dumpIndex];
            for (ThreadDumpItem item : threadDump.getThreadDumpItems()) {
                this.threadItemMap.put(item, dumpIndex);
            }
        }
        for (int threadIndex = 0; threadIndex < this.getNumThreads(); ++threadIndex) {
            ThreadDumpItem[] run = this.getThreadRun(threadIndex);
            boolean started = false;
            boolean finished = false;
            for (int dumpIndex2 = 0; dumpIndex2 < this.getNumDumps(); ++dumpIndex2) {
                ThreadDumpItem item;
                item = run[dumpIndex2];
                assert (item == this.getThreadDumpItem(dumpIndex2, threadIndex));
                assert (item == null || this.threadIndex2ThreadRunIndex(dumpIndex2, item.getThreadIndex()) == threadIndex);
                if (item != null) {
                    if (finished) {
                        throw new ThreadDumpsNotMatchException(run, dumpIndex2, "Found incomplete thread run.");
                    }
                    started = true;
                    continue;
                }
                if (!started) continue;
                finished = true;
            }
        }
    }

    private Map<Integer, Integer> createThreadRunIndexMap(int dumpIndex) {
        ThreadDump threadDump = this.getThreadDumps()[dumpIndex];
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>(threadDump.getNumThreads());
        for (int threadRunIndex = 0; threadRunIndex < this.getNumThreads(); ++threadRunIndex) {
            ThreadDumpItem item = this.getThreadDumpItem(dumpIndex, threadRunIndex);
            if (item == null) continue;
            int threadIndex = item.getThreadIndex();
            assert (!indexMap.containsKey(threadIndex));
            indexMap.put(threadIndex, threadRunIndex);
        }
        return indexMap;
    }

    private boolean itemIsDominated(ThreadDumpItem smallItem, ThreadDumpItem bigItem) {
        if (smallItem == null) {
            return true;
        }
        return smallItem.getCpuTime(false) <= bigItem.getCpuTime(false) && smallItem.getMemoryConsumption(false) <= bigItem.getMemoryConsumption(false) && smallItem.getFileBytesRead(false) <= bigItem.getFileBytesRead(false) && smallItem.getSocketBytesRead(false) <= bigItem.getSocketBytesRead(false) && smallItem.getFileBytesWritten(false) <= bigItem.getFileBytesWritten(false) && smallItem.getSocketBytesWritten(false) <= bigItem.getSocketBytesWritten(false);
    }

    @Override
    public boolean isSameThreadRun(ThreadDumpItem lhsItem, ThreadDumpItem rhsItem) {
        return lhsItem.getJavaThreadId() == rhsItem.getJavaThreadId() && lhsItem.getNativeId() == rhsItem.getNativeId() && lhsItem.getKernelId() == rhsItem.getKernelId() && lhsItem.getPthreadId() == rhsItem.getPthreadId() && lhsItem.isDaemon() == rhsItem.isDaemon();
    }

    @Override
    public int getNumDumps() {
        assert (this.timestamps.length == this.threadDumpsRaw.length);
        return this.threadDumpsRaw.length;
    }

    @Override
    public int getNumThreads() {
        return this.threadDumps.size();
    }

    @Override
    public ThreadDumpItem getThreadDumpItem(int dumpIndex, int threadIndex) {
        return this.threadDumps.get(threadIndex)[dumpIndex];
    }

    @Override
    public ThreadDumpItem[] getThreadRun(int threadIndex) {
        return this.threadDumps.get(threadIndex);
    }

    private ThreadDumpItem[] getThreadRun(ThreadDumpItem item, int dumpIndex, int threadRunIndexHint) {
        ThreadDumpItem[] hint;
        ThreadDumpItem lastRunItem;
        assert (dumpIndex > 0);
        if (threadRunIndexHint >= 0 && threadRunIndexHint < this.threadDumps.size() && (lastRunItem = (hint = this.threadDumps.get(threadRunIndexHint))[dumpIndex - 1]) != null && this.isSameThreadRun(lastRunItem, item)) {
            return hint;
        }
        for (ThreadDumpItem[] threadRun : this.threadDumps) {
            ThreadDumpItem lastRunItem2 = threadRun[dumpIndex - 1];
            if (lastRunItem2 == null || !this.isSameThreadRun(lastRunItem2, item)) continue;
            return threadRun;
        }
        return null;
    }

    @Override
    public Iterable<ThreadDumpItem> getThreadDump(final int dumpIndex) {
        return new Iterable<ThreadDumpItem>(){

            @Override
            public Iterator<ThreadDumpItem> iterator() {
                return new Iterator<ThreadDumpItem>(){
                    int threadIndex = 0;

                    @Override
                    public boolean hasNext() {
                        return this.threadIndex < ThreadDumpsImpl.this.getNumThreads();
                    }

                    @Override
                    public ThreadDumpItem next() {
                        return ThreadDumpsImpl.this.getThreadDumpItem(dumpIndex, this.threadIndex++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public long getTimeStamp(int dumpIndex) {
        return this.timestamps[dumpIndex];
    }

    @Override
    public ThreadDump[] getThreadDumps() {
        return this.threadDumpsRaw;
    }

    @Override
    public StackFrames getStackFrame(int stackTraceIndex) {
        StackFrames stacktrace = this.getSession().getStackTraceManager().getStackFramesObject(true);
        stacktrace.fillIn(stackTraceIndex);
        return stacktrace;
    }

    @Override
    public int getStackPrefix(StackFrames lhs, StackFrames rhs, int maxCommonFrames) {
        int maxFrames = Math.min(lhs.getNrOfFrames(), maxCommonFrames);
        maxFrames = Math.min(rhs.getNrOfFrames(), maxFrames);
        for (int frameIndex = 0; frameIndex < maxFrames; ++frameIndex) {
            MethodLocation rhsMethod;
            MethodLocation lhsMethod = lhs.getMethodLocation(frameIndex);
            if (lhsMethod.compareTo(rhsMethod = rhs.getMethodLocation(frameIndex)) == 0) continue;
            return frameIndex;
        }
        assert (maxFrames <= maxCommonFrames);
        return maxFrames;
    }

    @Override
    public int getThreadRunStartIndex(ThreadDumpItem[] threadRun) {
        for (int i = 0; i < threadRun.length; ++i) {
            if (threadRun[i] == null) continue;
            return i;
        }
        assert (false);
        return -1;
    }

    @Override
    public int getThreadRunEndIndex(ThreadDumpItem[] threadRun) {
        for (int i = threadRun.length - 1; i >= 0; --i) {
            if (threadRun[i] == null) continue;
            return i;
        }
        assert (false);
        return -1;
    }

    @Override
    public int[] getThreadRunRange(int threadIndex) {
        int[] result = new int[2];
        ThreadDumpItem[] threadRun = this.getThreadRun(threadIndex);
        result[0] = this.getThreadRunStartIndex(threadRun);
        result[1] = this.getThreadRunEndIndex(threadRun);
        return result;
    }

    @Override
    public int threadIndex2ThreadRunIndex(int dumpIndex, int threadIndex) {
        assert (0 <= dumpIndex && dumpIndex < this.getNumDumps());
        return this.threadIndexMaps.get(dumpIndex).get(threadIndex);
    }

    @Override
    public int threadDumpItem2DumpIndex(ThreadDumpItem item) {
        return this.threadItemMap.get(item);
    }

    @Override
    public ThreadDumpItem getThreadRunHead(int threadIndex) {
        ThreadDumpItem[] threadRun = this.getThreadRun(threadIndex);
        int startIndex = this.getThreadRunStartIndex(threadRun);
        return threadRun[startIndex];
    }

    @Override
    public ThreadDumpItem getThreadRunTail(int threadIndex) {
        ThreadDumpItem[] threadRun = this.getThreadRun(threadIndex);
        int endIndex = this.getThreadRunEndIndex(threadRun);
        return threadRun[endIndex];
    }

    @Override
    public boolean hasProgress(ThreadDumpItem firstItem, ThreadDumpItem secondItem) {
        if (firstItem.getStackTraceIndex() != secondItem.getStackTraceIndex()) {
            return true;
        }
        if (secondItem.getCpuTime(false) <= firstItem.getCpuTime(false) && secondItem.getMemoryConsumption(false) <= firstItem.getMemoryConsumption(false) && secondItem.getFileBytesRead(false) <= firstItem.getFileBytesRead(false) && secondItem.getFileBytesWritten(false) <= firstItem.getFileBytesWritten(false) && secondItem.getSocketBytesRead(false) <= firstItem.getSocketBytesRead(false) && secondItem.getSocketBytesWritten(false) <= firstItem.getSocketBytesWritten(false) && secondItem.getNumDefinedClasses() <= firstItem.getNumDefinedClasses() && secondItem.getNumFilesOpen(false) <= firstItem.getNumFilesOpen(false) && secondItem.getNumSocketsOpen(false) <= firstItem.getNumSocketsOpen(false) && secondItem.getStatus() == firstItem.getStatus()) {
            SocketObject firstSocketObject = firstItem.getSocketInfo();
            SocketObject secondSocketObject = secondItem.getSocketInfo();
            if (firstSocketObject != null && secondSocketObject != null ? !firstSocketObject.equals(secondSocketObject) : firstSocketObject != secondSocketObject) {
                return true;
            }
            MonitorObject firstMonitorObject = firstItem.getMonitorObject();
            MonitorObject secondMonitorObject = secondItem.getMonitorObject();
            return firstMonitorObject != null && secondMonitorObject != null ? firstMonitorObject.getObjectId() != secondMonitorObject.getObjectId() : firstMonitorObject != secondMonitorObject;
        }
        return true;
    }

    @Override
    public ProfilingSession getSession() {
        return this.session;
    }

    @Override
    public String getDumpName(int dumpIndex) {
        return String.format("Thread Dump %d", dumpIndex + 1);
    }

    @Override
    public int getFirstDeadlockedDump() {
        for (int dumpIndex = 0; dumpIndex < this.threadDumpsRaw.length; ++dumpIndex) {
            if (this.threadDumpsRaw[dumpIndex].getDeadlocks().length <= 0) continue;
            return dumpIndex;
        }
        return -1;
    }
}

