/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.thread;

import com.sap.jvm.profiling.thread.SocketObject;
import com.sap.jvm.profiling.thread.ThreadDump;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadDumps;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;
import com.sap.jvm.profiling.thread.ThreadStatus;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class ThreadDumpsSummaryImpl
implements ThreadDumpsSummary {
    private ThreadDumps threadDumps;
    private List<SocketObject> remoteConnections;

    public ThreadDumpsSummaryImpl(ThreadDumps threadsCompare) {
        this.threadDumps = threadsCompare;
        this.remoteConnections = new LinkedList<SocketObject>();
        this.initRemoteConnections();
    }

    private long getValueDiff(int dumpIndex1, int dumpIndex2, ValueGetter getter) {
        long value = 0L;
        assert (0 <= dumpIndex1 && dumpIndex1 <= dumpIndex2 && dumpIndex2 < this.threadDumps.getNumDumps());
        for (int threadIndex = 0; threadIndex < this.threadDumps.getNumThreads(); ++threadIndex) {
            ThreadDumpItem item2 = null;
            for (int dumpIndex = dumpIndex2; dumpIndex > dumpIndex1 && (item2 = this.threadDumps.getThreadDumpItem(dumpIndex, threadIndex)) == null; --dumpIndex) {
            }
            if (item2 == null) continue;
            value += getter.getValue(item2);
            ThreadDumpItem item1 = this.threadDumps.getThreadDumpItem(dumpIndex1, threadIndex);
            if (item1 == null) continue;
            value -= getter.getValue(item1);
        }
        return value;
    }

    @Override
    public int getNumThreadsDiff(int dumpIndex1, int dumpIndex2) {
        return (int)this.getValueDiff(dumpIndex1, dumpIndex2, new ValueGetter(){

            @Override
            public long getValue(ThreadDumpItem item) {
                return 1L;
            }
        });
    }

    @Override
    public int getNumThreadsDiff() {
        return this.getNumThreadsDiff(0, this.threadDumps.getNumDumps() - 1);
    }

    @Override
    public long getCPUTimeDiff(int dumpIndex1, int dumpIndex2) {
        return this.getValueDiff(dumpIndex1, dumpIndex2, new ValueGetter(){

            @Override
            public long getValue(ThreadDumpItem item) {
                return item.getCpuTime(false);
            }
        });
    }

    @Override
    public long getCPUTimeDiff() {
        return this.getCPUTimeDiff(0, this.threadDumps.getNumDumps() - 1);
    }

    @Override
    public long getElapsedTimeDiff(int dumpIndex1, int dumpIndex2) {
        return this.threadDumps.getTimeStamp(dumpIndex2) - this.threadDumps.getTimeStamp(dumpIndex1);
    }

    @Override
    public long getElapsedTimeDiff() {
        return this.getElapsedTimeDiff(0, this.threadDumps.getNumDumps() - 1);
    }

    @Override
    public long getMemoryConsumptionDiff(int dumpIndex1, int dumpIndex2) {
        return this.getValueDiff(dumpIndex1, dumpIndex2, new ValueGetter(){

            @Override
            public long getValue(ThreadDumpItem item) {
                return item.getMemoryConsumption(false);
            }
        });
    }

    @Override
    public long getMemoryConsumptionDiff() {
        return this.getMemoryConsumptionDiff(0, this.threadDumps.getNumDumps() - 1);
    }

    @Override
    public long getFileBytesReadDiff(int dumpIndex1, int dumpIndex2) {
        return this.getValueDiff(dumpIndex1, dumpIndex2, new ValueGetter(){

            @Override
            public long getValue(ThreadDumpItem item) {
                return item.getFileBytesRead(false);
            }
        });
    }

    @Override
    public long getFileBytesReadDiff() {
        return this.getFileBytesReadDiff(0, this.threadDumps.getNumDumps() - 1);
    }

    @Override
    public long getFileBytesWrittenDiff(int dumpIndex1, int dumpIndex2) {
        return this.getValueDiff(dumpIndex1, dumpIndex2, new ValueGetter(){

            @Override
            public long getValue(ThreadDumpItem item) {
                return item.getFileBytesWritten(false);
            }
        });
    }

    @Override
    public long getFileBytesWrittenDiff() {
        return this.getFileBytesWrittenDiff(0, this.threadDumps.getNumDumps() - 1);
    }

    @Override
    public long getSocketBytesReadDiff(int dumpIndex1, int dumpIndex2) {
        return this.getValueDiff(dumpIndex1, dumpIndex2, new ValueGetter(){

            @Override
            public long getValue(ThreadDumpItem item) {
                return item.getSocketBytesRead(false);
            }
        });
    }

    @Override
    public long getSocketBytesReadDiff() {
        return this.getSocketBytesReadDiff(0, this.threadDumps.getNumDumps() - 1);
    }

    @Override
    public long getSocketBytesWrittenDiff(int dumpIndex1, int dumpIndex2) {
        return this.getValueDiff(dumpIndex1, dumpIndex2, new ValueGetter(){

            @Override
            public long getValue(ThreadDumpItem item) {
                return item.getSocketBytesWritten(false);
            }
        });
    }

    @Override
    public long getSocketBytesWrittenDiff() {
        return this.getSocketBytesWrittenDiff(0, this.threadDumps.getNumDumps() - 1);
    }

    @Override
    public long getNumFilesOpenDiff(int dumpIndex1, int dumpIndex2) {
        return this.getValueDiff(dumpIndex1, dumpIndex2, new ValueGetter(){

            @Override
            public long getValue(ThreadDumpItem item) {
                return item.getNumFilesOpen(false);
            }
        });
    }

    @Override
    public long getNumFilesOpenDiff() {
        return this.getNumFilesOpenDiff(0, this.threadDumps.getNumDumps() - 1);
    }

    @Override
    public long getNumSocketsOpenDiff(int dumpIndex1, int dumpIndex2) {
        return this.getValueDiff(dumpIndex1, dumpIndex2, new ValueGetter(){

            @Override
            public long getValue(ThreadDumpItem item) {
                return item.getNumSocketsOpen(false);
            }
        });
    }

    @Override
    public long getNumSocketsOpenDiff() {
        return this.getNumSocketsOpenDiff(0, this.threadDumps.getNumDumps() - 1);
    }

    @Override
    public int getMaxNumThreads() {
        int maxNumThreads = 0;
        for (ThreadDump dump : this.threadDumps.getThreadDumps()) {
            maxNumThreads = Math.max(maxNumThreads, dump.getNumThreads());
        }
        return maxNumThreads;
    }

    @Override
    public int getNumSurvivingThreads() {
        int result = 0;
        for (int threadIndex = 0; threadIndex < this.threadDumps.getNumThreads(); ++threadIndex) {
            ThreadDumpItem firstItem = this.threadDumps.getThreadDumpItem(0, threadIndex);
            ThreadDumpItem lastItem = this.threadDumps.getThreadDumpItem(this.threadDumps.getNumDumps() - 1, threadIndex);
            if (firstItem == null || lastItem == null) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int getNumCreatedThreads() {
        int result = 0;
        for (int threadIndex = 0; threadIndex < this.threadDumps.getNumThreads(); ++threadIndex) {
            ThreadDumpItem firstItem = this.threadDumps.getThreadDumpItem(0, threadIndex);
            if (firstItem != null) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int getNumFinishedThreads() {
        int result = 0;
        for (int threadIndex = 0; threadIndex < this.threadDumps.getNumThreads(); ++threadIndex) {
            ThreadDumpItem lastItem = this.threadDumps.getThreadDumpItem(this.threadDumps.getNumDumps() - 1, threadIndex);
            if (lastItem != null) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int getTotalNumThreads() {
        return this.getThreadDumps().getNumThreads();
    }

    @Override
    public ThreadDump hasDeadlock() {
        for (ThreadDump dump : this.threadDumps.getThreadDumps()) {
            ThreadDumpItem[] deadlockedItems = dump.getDeadlocks();
            if (deadlockedItems == null || deadlockedItems.length <= 0) continue;
            return dump;
        }
        return null;
    }

    @Override
    public ThreadDumps getThreadDumps() {
        return this.threadDumps;
    }

    @Override
    public double getCPUUtilization() {
        return this.getCPUUtilization(0, this.threadDumps.getNumDumps() - 1);
    }

    @Override
    public double getCPUUtilization(int dumpIndex1, int dumpIndex2) {
        long elapsedTime = 1000000L * this.getElapsedTimeDiff(dumpIndex1, dumpIndex2);
        if (elapsedTime > 0L) {
            return (double)this.getCPUTimeDiff(dumpIndex1, dumpIndex2) / (double)elapsedTime;
        }
        return Double.NaN;
    }

    private static int getPercentage(int num, int total) {
        return (int)Math.round((double)num / (double)total * 100.0);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Number thread dumps: " + this.threadDumps.getNumDumps());
        sb.append("\n");
        sb.append("Max number threads: " + this.threadDumps.getNumThreads());
        sb.append("\n");
        sb.append("Number threads created: " + this.getNumCreatedThreads());
        sb.append("\n");
        sb.append("Number threads finished: " + this.getNumFinishedThreads());
        sb.append("\n");
        ThreadDumpsSummary.ThreadStateStatistic stats = this.getNumThreadState();
        sb.append(String.format("Thread states: %d%% running, %d%% in IO, %d%% sleeping, %d%% waiting, %d%% locked", ThreadDumpsSummaryImpl.getPercentage(stats.numRunnable, stats.total), ThreadDumpsSummaryImpl.getPercentage(stats.numIO, stats.total), ThreadDumpsSummaryImpl.getPercentage(stats.numSleeping, stats.total), ThreadDumpsSummaryImpl.getPercentage(stats.numWaiting, stats.total), ThreadDumpsSummaryImpl.getPercentage(stats.numLocked, stats.total)));
        sb.append("\n");
        sb.append("\n");
        sb.append("Elapsed time [ms]: " + this.getElapsedTimeDiff());
        sb.append("\n");
        sb.append("CPU time [ms]:" + this.getCPUTimeDiff() / 1000000L);
        sb.append("\n");
        sb.append("Average Utilization [#cores] : " + this.getCPUUtilization());
        sb.append("\n");
        sb.append("\n");
        sb.append("Memory consumption [bytes]: " + this.getMemoryConsumptionDiff());
        sb.append("\n");
        sb.append("Socket read [bytes]: " + this.getSocketBytesReadDiff());
        sb.append("\n");
        sb.append("Socket written [bytes]: " + this.getSocketBytesWrittenDiff());
        sb.append("\n");
        sb.append("Sockets opened: " + this.getNumSocketsOpenDiff());
        sb.append("\n");
        sb.append("File read [bytes]: " + this.getFileBytesReadDiff());
        sb.append("\n");
        sb.append("File written [bytes]: " + this.getFileBytesWrittenDiff());
        sb.append("\n");
        sb.append("Files opened: " + this.getNumFilesOpenDiff());
        sb.append("\n");
        sb.append("\n");
        if (this.getSocketConnections().size() > 0) {
            sb.append("");
            for (SocketObject connection : this.getSocketConnections()) {
                sb.append("Remote connection: ");
                sb.append(connection.getEffectiveRemoteHostname());
                sb.append(" port:");
                sb.append(connection.getRemotePort());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public long getNumThreads(int dumpIndex) {
        ThreadDump[] dumps = this.threadDumps.getThreadDumps();
        if (dumpIndex >= 0 && dumpIndex < dumps.length) {
            return dumps[dumpIndex].getNumThreads();
        }
        assert (false);
        return 0L;
    }

    @Override
    public long getNumFilesOpen(int dumpIndex) {
        long result = 0L;
        for (int threadIndex = 0; threadIndex < this.threadDumps.getNumThreads(); ++threadIndex) {
            ThreadDumpItem item = this.threadDumps.getThreadDumpItem(dumpIndex, threadIndex);
            for (int testDumpIndex = dumpIndex - 1; item == null && testDumpIndex >= 0; --testDumpIndex) {
                item = this.threadDumps.getThreadDumpItem(testDumpIndex, threadIndex);
            }
            if (item == null) continue;
            result += item.getNumFilesOpen(false);
        }
        return result;
    }

    @Override
    public long getNumSocketsOpen(int dumpIndex) {
        long result = 0L;
        for (int threadIndex = 0; threadIndex < this.threadDumps.getNumThreads(); ++threadIndex) {
            ThreadDumpItem item = this.threadDumps.getThreadDumpItem(dumpIndex, threadIndex);
            for (int testDumpIndex = dumpIndex - 1; item == null && testDumpIndex >= 0; --testDumpIndex) {
                item = this.threadDumps.getThreadDumpItem(testDumpIndex, threadIndex);
            }
            if (item == null) continue;
            result += item.getNumSocketsOpen(false);
        }
        return result;
    }

    @Override
    public long getNumBlockedThreads(int dumpIndex) {
        long result = 0L;
        for (ThreadDumpItem item : this.threadDumps.getThreadDump(dumpIndex)) {
            if (item == null || item.getStatus() != ThreadStatus.THREAD_STATUS_LOCK_WAIT) continue;
            ++result;
        }
        return result;
    }

    @Override
    public long getNumIOThreads(int dumpIndex) {
        long result = 0L;
        for (ThreadDumpItem item : this.threadDumps.getThreadDump(dumpIndex)) {
            if (item == null || item.getStatus() != ThreadStatus.THREAD_STATUS_SOCKET_ACCEPT && item.getStatus() != ThreadStatus.THREAD_STATUS_SOCKET_CONNECT && item.getStatus() != ThreadStatus.THREAD_STATUS_SOCKET_READ && item.getStatus() != ThreadStatus.THREAD_STATUS_SOCKET_WRITE && item.getStatus() != ThreadStatus.THREAD_STATUS_FILE_READ && item.getStatus() != ThreadStatus.THREAD_STATUS_FILE_WRITE) continue;
            ++result;
        }
        return result;
    }

    @Override
    public ThreadDumpsSummary.ThreadStateStatistic getNumThreadState() {
        int numWaiting = 0;
        int numLocked = 0;
        int numIO = 0;
        int numSleeping = 0;
        int numRunnable = 0;
        for (ThreadDump dump : this.threadDumps.getThreadDumps()) {
            block8: for (ThreadDumpItem dumpItem : dump.getThreadDumpItems()) {
                switch (dumpItem.getStatus()) {
                    case THREAD_STATUS_RUNNING: {
                        ++numRunnable;
                        continue block8;
                    }
                    case THREAD_STATUS_OS_SLEEPING: 
                    case THREAD_STATUS_SLEEPING: {
                        ++numSleeping;
                        continue block8;
                    }
                    case THREAD_STATUS_LOCK_WAIT: {
                        ++numLocked;
                        continue block8;
                    }
                    case THREAD_STATUS_OBJECT_WAIT: {
                        ++numWaiting;
                        continue block8;
                    }
                    case THREAD_STATUS_SOCKET_READ: 
                    case THREAD_STATUS_SOCKET_WRITE: 
                    case THREAD_STATUS_SOCKET_ACCEPT: 
                    case THREAD_STATUS_SOCKET_CONNECT: 
                    case THREAD_STATUS_FILE_READ: 
                    case THREAD_STATUS_FILE_WRITE: {
                        ++numIO;
                        continue block8;
                    }
                }
            }
        }
        return new ThreadDumpsSummary.ThreadStateStatistic(numWaiting, numLocked, numIO, numSleeping, numRunnable);
    }

    private void initRemoteConnections() {
        this.remoteConnections.clear();
        HashSet<SocketObject> uniqueConnections = new HashSet<SocketObject>();
        for (ThreadDump dump : this.threadDumps.getThreadDumps()) {
            for (ThreadDumpItem dumpItem : dump.getThreadDumpItems()) {
                SocketObject socketInfo = dumpItem.getSocketInfo();
                if (socketInfo == null || !socketInfo.hasValidRemoteAddress() || socketInfo.remoteConnectionIsLoopback()) continue;
                uniqueConnections.add(socketInfo);
            }
        }
        this.remoteConnections.addAll(uniqueConnections);
    }

    @Override
    public List<SocketObject> getSocketConnections() {
        return this.remoteConnections;
    }

    private static interface ValueGetter {
        public long getValue(ThreadDumpItem var1);
    }
}

