/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.thread.command;

import com.sap.jvm.profiling.core.command.CommandType;
import com.sap.jvm.profiling.impl.core.command.CommandImpl;
import com.sap.jvm.profiling.thread.command.EnableThreadDumpsCommand;
import com.sap.jvm.profiling.thread.command.ThreadDumpConfiguration;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class EnableThreadDumpsCommandImpl
extends CommandImpl
implements EnableThreadDumpsCommand {
    public ThreadDumpConfiguration threadDumpConfiguration;

    public EnableThreadDumpsCommandImpl(ThreadDumpConfiguration threadDumpConfiguration) {
        this.threadDumpConfiguration = threadDumpConfiguration;
    }

    @Override
    public void print(PrintStream stream) {
        stream.print("Starting thread dump task : number =");
        stream.print(this.threadDumpConfiguration.getNumThreadDumps());
        stream.print(", period [ms] = ");
        stream.print(this.threadDumpConfiguration.getPeriod());
        stream.print(", delay [ms] = ");
        stream.print(this.threadDumpConfiguration.getDelay());
    }

    @Override
    protected void writeToStreamImpl(DataOutputStream stream) throws IOException {
        this.writeUint16(stream, 70);
        stream.writeLong(this.getId());
        stream.writeInt(this.threadDumpConfiguration.getNumThreadDumps());
        stream.writeLong(this.threadDumpConfiguration.getPeriod());
        stream.writeLong(this.threadDumpConfiguration.getDelay());
    }

    @Override
    public CommandType getType() {
        return CommandType.ENABLE_THREAD_DUMP;
    }

    @Override
    public ThreadDumpConfiguration getConfiguration() {
        return this.threadDumpConfiguration;
    }
}

