/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.thread.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.SimpleProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.thread.ThreadDumpImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.thread.ThreadDump;
import com.sap.jvm.profiling.thread.event.ThreadDumpEventHandler;
import com.sap.jvm.profiling.thread.event.ThreadDumpsEvent;
import java.io.IOException;
import java.io.PrintStream;

public final class ThreadDumpsEventImpl
extends ProfilingPacketImpl
implements ThreadDumpsEvent {
    private long timeStamp;
    private ThreadDump threadDump;

    public static ThreadDumpsEventImpl read(ResourceReader reader, MappingInformation mapInfo, ThreadDumpEventHandler[] threadDumpEventHandlers) throws IOException {
        ThreadDumpsEventImpl result = new ThreadDumpsEventImpl(reader, mapInfo);
        for (ThreadDumpEventHandler handler : threadDumpEventHandlers) {
            handler.handle(result);
        }
        return result;
    }

    protected ThreadDumpsEventImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.timeStamp = reader.readInt64();
        this.threadDump = new ThreadDumpImpl(reader, mapInfo);
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.THREAD_DUMPS_EVENT;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)764);
        writer.writeInt64(this.timeStamp);
        this.threadDump.write(writer);
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "thread dump event";
    }

    @Override
    public ThreadDump getThreadDump() {
        return this.threadDump;
    }

    @Override
    public long getTime() {
        return this.timeStamp;
    }

    @Override
    public void print(PrintStream stream, boolean includeThreadContent) {
        SimpleProfilingPrintStream sps = new SimpleProfilingPrintStream(stream);
        this.print(sps, includeThreadContent);
        sps.flush();
    }

    @Override
    public void print(ProfilingPrintStream stream, boolean includeThreadContent) {
        stream.printlnPacketHeader(this);
        this.threadDump.print(stream, includeThreadContent);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        this.print(stream, false);
    }
}

