/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.thread.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.thread.ThreadStatus;
import com.sap.jvm.profiling.thread.event.ThreadStateSamplingEvent;
import java.io.IOException;

public final class ThreadStateSamplingEventImpl
extends ProfilingPacketImpl
implements ThreadStateSamplingEvent {
    private final long timeStamp;
    private final char[] threadIndices;
    private final ThreadStatus[] threadStateInfo;

    public static ThreadStateSamplingEventImpl read(ResourceReader reader) throws IOException {
        ThreadStateSamplingEventImpl result = new ThreadStateSamplingEventImpl(reader);
        return result;
    }

    public ThreadStateSamplingEventImpl(ResourceReader reader) throws IOException {
        this.timeStamp = reader.readInt64();
        int nrOfThreads = reader.readInt32();
        this.threadIndices = new char[nrOfThreads];
        this.threadStateInfo = new ThreadStatus[nrOfThreads];
        for (int i = 0; i < nrOfThreads; ++i) {
            this.threadIndices[i] = reader.readUint16();
            this.threadStateInfo[i] = ThreadStatus.getThreadState(reader.readInt16());
        }
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.THREAD_STATE_SAMPLING_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public int getNrOfThreads() {
        return this.threadIndices.length;
    }

    @Override
    public char getThreadIndex(int index) {
        return this.threadIndices[index];
    }

    @Override
    public ThreadStatus getThreadStateInfo(int index) {
        return this.threadStateInfo[index];
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)531);
        writer.writeInt64(this.timeStamp);
        writer.writeInt32(this.threadIndices.length);
        for (int i = 0; i < this.threadIndices.length; ++i) {
            writer.writeUint16(this.threadIndices[i]);
            writer.writeInt16((short)this.threadStateInfo[i].getValue());
        }
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "thread state sampling event";
    }
}

