/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.thread.parser;

import com.sap.jvm.profiling.SimpleProfilingWriter;
import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.core.type.MonitorObjectUsage;
import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.type.IpAddressV4Impl;
import com.sap.jvm.profiling.impl.core.type.IpAddressV6Impl;
import com.sap.jvm.profiling.impl.thread.ThreadDumpImpl;
import com.sap.jvm.profiling.impl.thread.ThreadDumpItemImpl;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.thread.SocketObject;
import com.sap.jvm.profiling.thread.SocketObjectUsage;
import com.sap.jvm.profiling.thread.ThreadDump;
import com.sap.jvm.profiling.thread.ThreadDumpFactory;
import com.sap.jvm.profiling.thread.ThreadDumpFileParser;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadDumpsNotMatchException;
import com.sap.jvm.profiling.thread.ThreadStatus;
import com.sap.jvm.profiling.util.threaddump.parser.ThreadDumpFormatException;
import com.sap.jvm.profiling.util.threaddump.parser.ThreadDumpLines;
import com.sap.jvm.profiling.util.threaddump.parser.ThreadDumpStateMachine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpLockInfoLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpMonitorBlockedLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpMonitorLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpSocketInfoLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpStateLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpSynchronizerLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpTimeStampLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpVMInfoLine;
import com.sap.jvm.tracing.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class ThreadDumpFileParserImpl
implements ThreadDumpFileParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] parseProfilingFiles(String[] threadDumpFileNames, String destDir, String destFileNamePrefix, String logFileName, int major, int minor, int micro, ProgressReporter reporter) {
        ThreadDumpProfilingFileGenerator generator = null;
        boolean generated = false;
        try {
            generator = new ThreadDumpProfilingFileGenerator(destDir, destFileNamePrefix, logFileName, major, minor, micro);
            ThreadDumpStateMachine fsm = new ThreadDumpStateMachine();
            fsm.addListener(generator);
            LinkedList<String> filesToParse = new LinkedList<String>();
            for (String threadDumpFileName : threadDumpFileNames) {
                if (!this.testForAscii(threadDumpFileName)) continue;
                filesToParse.add(threadDumpFileName);
            }
            if (reporter != null) {
                int totalLines = 0;
                for (String threadDumpFileName : filesToParse) {
                    LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(threadDumpFileName));
                    try {
                        while (lineNumberReader.readLine() != null) {
                        }
                    }
                    catch (IOException e) {
                        generator.logMessage(String.format("IO Error while reading file %s: %s.", threadDumpFileName, e.getMessage()), ThreadDumpProfilingFileGenerator.LogSeverity.ERROR);
                    }
                    finally {
                        lineNumberReader.close();
                        totalLines += lineNumberReader.getLineNumber();
                    }
                }
                reporter.addToMaximumWork(totalLines);
            }
            for (String threadDumpFileName : filesToParse) {
                LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(threadDumpFileName));
                generator.logMessage(String.format("Parsing file '%s'.", threadDumpFileName), ThreadDumpProfilingFileGenerator.LogSeverity.INFO);
                fsm.consumeFile(threadDumpFileName);
                try {
                    String curLine = null;
                    while ((curLine = lineNumberReader.readLine()) != null) {
                        if (curLine.length() > 0 && !fsm.consumeLine(curLine, lineNumberReader.getLineNumber())) {
                            String[] stringArray = null;
                            return stringArray;
                        }
                        if (reporter == null) continue;
                        if (reporter.isCancelled()) {
                            String[] stringArray = null;
                            return stringArray;
                        }
                        reporter.reportNext();
                    }
                }
                catch (IOException e) {
                    generator.logMessage(String.format("IO Error during processing of file %s: %s.", threadDumpFileName, e.getMessage()), ThreadDumpProfilingFileGenerator.LogSeverity.ERROR);
                }
                finally {
                    lineNumberReader.close();
                }
            }
            fsm.finish();
            generated = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            generator.logMessage(String.format("Got Exception: %s.", e.getMessage()), ThreadDumpProfilingFileGenerator.LogSeverity.ERROR);
        }
        finally {
            if (generator != null) {
                try {
                    generator.close();
                }
                catch (IOException iOException) {
                }
                catch (ThreadDumpFormatException threadDumpFormatException) {}
            }
            if (reporter != null) {
                if (!generated) {
                    reporter.cancel();
                } else {
                    reporter.finish();
                }
            }
        }
        return generator.generatedFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long parseFirstTimestamp(String threadDumpFileName) {
        class TimeStampListener
        implements ThreadDumpStateMachine.ThreadDumpParseEventListener {
            long timestampFound = -1L;

            TimeStampListener() {
            }

            @Override
            public void onThreadDumpStart(ThreadDumpTimeStampLine timestamp) {
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                calendar.set(timestamp.getYear(), timestamp.getMonth(), timestamp.getDay(), timestamp.getHour(), timestamp.getMinute(), timestamp.getSecond());
                long curTimestamp = calendar.getTimeInMillis();
                if (this.timestampFound <= 0L) {
                    this.timestampFound = curTimestamp;
                }
            }

            @Override
            public void onThreadDumpVmStartup() throws IOException {
            }

            @Override
            public void onThreadDumpVmInfo(ThreadDumpVMInfoLine vmInfo) {
                this.timestampFound = Math.max(this.timestampFound, 0L);
            }

            @Override
            public void onThreadDumpStackTraceParsed(ThreadDumpLines threadDump) {
                this.timestampFound = Math.max(this.timestampFound, 0L);
            }

            @Override
            public void onThreadDumpEnd() {
                this.timestampFound = Math.max(this.timestampFound, 0L);
            }

            @Override
            public void onThreadDumpUnknownLine(String line, int lineNo) {
                if (this.timestampFound < 0L && ThreadDumpSynchronizerLine.isThreadDumpSynchronizerHeaderLine(line)) {
                    this.timestampFound = 0L;
                }
            }

            @Override
            public void onThreadDumpLineParseError(String line, int lineNo, String reason) {
            }

            @Override
            public void onNewThreadDumpFile(String fileName) {
            }

            public long getTimeStamp() {
                return this.timestampFound;
            }
        }
        TimeStampListener timestampResult;
        block7: {
            timestampResult = new TimeStampListener();
            try {
                if (!this.testForAscii(threadDumpFileName)) break block7;
                ThreadDumpStateMachine fsm = new ThreadDumpStateMachine();
                fsm.addListener(timestampResult);
                try (LineNumberReader lineReader = new LineNumberReader(new FileReader(threadDumpFileName));){
                    String curLine = null;
                    while ((curLine = lineReader.readLine()) != null && timestampResult.getTimeStamp() <= 0L) {
                        if (curLine.length() <= 0) continue;
                        fsm.consumeLine(curLine, lineReader.getLineNumber());
                    }
                }
                fsm.finish();
            }
            catch (IOException fsm) {
            }
            catch (Exception e) {
                Trace.error(e.getMessage());
            }
        }
        return timestampResult.getTimeStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testForAscii(String fileName) throws IOException {
        BufferedReader testFile = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        try {
            char[] testCharacters = new char[5000];
            testFile.read(testCharacters);
            boolean foundRow = false;
            for (char testChar : testCharacters) {
                if (testChar > '\u0080') {
                    boolean bl = false;
                    return bl;
                }
                if (testChar != '\n' && testChar != '\r') continue;
                foundRow = true;
            }
            if (!foundRow) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            try {
                ((Reader)testFile).close();
            }
            catch (IOException e) {
                Trace.warn(() -> e.getMessage());
            }
        }
        return true;
    }

    private static class ThreadDumpProfilingFileGenerator
    implements ThreadDumpStateMachine.ThreadDumpParseEventListener {
        private long timestamp;
        private List<ThreadDumpItem> curThreadItems = new LinkedList<ThreadDumpItem>();
        private List<ThreadDump> threadDumps = new LinkedList<ThreadDump>();
        private Map<MonitorObject, Integer> monitorOwner = new HashMap<MonitorObject, Integer>();
        private SimpleProfilingWriter sessionWriter;
        private FileWriter logWriter;
        private int threadCounter = 1;
        private int unknownLines = 0;
        private final String generatePath;
        private String generateFilePath;
        private String importFileName;
        private final boolean adaptImportFileName;
        private final int major;
        private final int minor;
        private final int micro;
        private List<String> generatedFiles = new ArrayList<String>();
        private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

        protected ThreadDumpProfilingFileGenerator(String destDir, String destFileNamePrefix, String logFilename, int major, int minor, int micro) throws IOException {
            this.major = major;
            this.minor = minor;
            this.micro = micro;
            this.generatePath = destDir;
            this.importFileName = destFileNamePrefix;
            boolean bl = this.adaptImportFileName = destFileNamePrefix == null;
            if (logFilename != null) {
                this.logWriter = new FileWriter(logFilename);
            }
        }

        public String[] generatedFiles() {
            String[] sortedFiles = this.generatedFiles.toArray(new String[0]);
            Arrays.sort(sortedFiles, new Comparator<String>(){

                @Override
                public int compare(String lhs, String rhs) {
                    return lhs.compareTo(rhs);
                }
            });
            return sortedFiles;
        }

        @Override
        public void onThreadDumpVmStartup() throws IOException, ThreadDumpFormatException {
            this.finishCurrentThreadDump();
            if (!this.threadDumps.isEmpty()) {
                this.close(false);
                this.generateFilePath = this.getGenerateFileName(this.importFileName);
                this.logMessage(String.format("Starting new profiling file %s.", this.generateFilePath), LogSeverity.INFO);
                this.sessionWriter = new SimpleProfilingWriter(new FileOutputStream(this.generateFilePath), this.major, this.minor, this.micro, true);
            }
        }

        @Override
        public void onThreadDumpStart(ThreadDumpTimeStampLine timestampLine) {
            this.finishCurrentThreadDump();
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(timestampLine.getYear(), timestampLine.getMonth(), timestampLine.getDay(), timestampLine.getHour(), timestampLine.getMinute(), timestampLine.getSecond());
            this.timestamp = calendar.getTimeInMillis();
            this.logMessage(String.format("Found new thread dump with timestamp %s.", dateFormat.format(calendar.getTime())), LogSeverity.INFO);
        }

        @Override
        public void onThreadDumpVmInfo(ThreadDumpVMInfoLine vmInfo) {
        }

        private MonitorObject createMonitorObject(long address, String className) throws IOException {
            long clazzId = this.sessionWriter.ensureClass(className, null);
            MonitorObject result = new MonitorObject(address, clazzId);
            return result;
        }

        private void handleAdditionalMonitors(List<ThreadDumpLines.AdditionalMonitorInfo> monitors) throws ThreadDumpFormatException, IOException {
            HashMap<Long, ThreadDumpItem> nativeId2threadItem = new HashMap<Long, ThreadDumpItem>();
            if (monitors.size() > 0) {
                for (ThreadDumpItem item : this.curThreadItems) {
                    nativeId2threadItem.put(item.getNativeId(), item);
                }
            }
            for (ThreadDumpLines.AdditionalMonitorInfo monitorInfo : monitors) {
                ThreadDumpMonitorLine monitorLine = monitorInfo.getMonitor();
                MonitorObject monitor = this.createMonitorObject(monitorLine.getMonitorAddress(), monitorLine.getMonitorClass());
                long threadNativeId = monitorInfo.getOwner().getNativeID();
                ThreadDumpItem blockerItem = (ThreadDumpItem)nativeId2threadItem.get(threadNativeId);
                if (blockerItem == null) {
                    throw new ThreadDumpFormatException("missing thread definiton with nid = " + threadNativeId);
                }
                this.monitorOwner.put(monitor, blockerItem.getThreadIndex());
                List<ThreadDumpMonitorBlockedLine> blocked = monitorInfo.getBlocked();
                for (ThreadDumpMonitorBlockedLine blockedLine : blocked) {
                    threadNativeId = blockedLine.getNativeID();
                    ThreadDumpItem item = (ThreadDumpItem)nativeId2threadItem.get(threadNativeId);
                    if (item == null) continue;
                    ((ThreadDumpItemImpl)item).setMonitorObject(monitor);
                    ((ThreadDumpItemImpl)item).setStatus(ThreadStatus.THREAD_STATUS_LOCK_WAIT);
                }
                List<ThreadDumpMonitorBlockedLine> waiters = monitorInfo.getWaiters();
                for (ThreadDumpMonitorBlockedLine waiterLine : waiters) {
                    threadNativeId = waiterLine.getNativeID();
                    ThreadDumpItem item = (ThreadDumpItem)nativeId2threadItem.get(threadNativeId);
                    if (item == null) {
                        throw new ThreadDumpFormatException("missing thread definiton with nid = " + threadNativeId);
                    }
                    ((ThreadDumpItemImpl)item).setMonitorObject(monitor);
                    ((ThreadDumpItemImpl)item).setStatus(ThreadStatus.THREAD_STATUS_OBJECT_WAIT);
                }
            }
        }

        @Override
        public void onThreadDumpStackTraceParsed(ThreadDumpLines threadItem) {
            try {
                this.handleAdditionalMonitors(threadItem.additionalMonitorInfos);
                if (!threadItem.isValid() || threadItem.nameLine == null || threadItem.stack.isEmpty()) {
                    return;
                }
                this.logMessage(String.format("\t Found new thread with name %s", threadItem.nameLine.getName()), LogSeverity.INFO);
                for (ThreadDumpSynchronizerLine syncLine : threadItem.synchronizers) {
                    MonitorObject monitor = this.createMonitorObject(syncLine.getSynchronizerAddress(), syncLine.getSynchronizerClass());
                    this.monitorOwner.put(monitor, this.threadCounter);
                }
                SimpleProfilingWriter.SimpleStackFrame[] stackTrace = new SimpleProfilingWriter.SimpleStackFrame[threadItem.stack.size()];
                SocketObject socketInfo = null;
                TreeMap<Integer, List<MonitorObject>> stackLocks = new TreeMap<Integer, List<MonitorObject>>();
                MonitorObject blocker = null;
                ThreadStatus status = ThreadStatus.THREAD_STATUS_RUNNING;
                if (threadItem.stateLine != null) {
                    status = this.convertToThreadStatus(threadItem.stateLine.getThreadStatus());
                }
                int i = 0;
                for (ThreadDumpLines.MethodInfo method : threadItem.stack) {
                    ThreadStatus filteredStatus;
                    String completeMethodName = method.frame.getMethodName();
                    int classSeparator = completeMethodName.lastIndexOf(46);
                    String className = completeMethodName.substring(0, classSeparator);
                    String methodName = completeMethodName.substring(classSeparator + 1);
                    if (i == 0 && (filteredStatus = ThreadStatus.isSpecialMethod(completeMethodName)) != null) {
                        status = filteredStatus;
                    }
                    String methodSignature = String.format("(%s)%s", method.frame.getMethodSignature(), method.frame.getMethodReturnType());
                    String fileName = method.frame.getFileName();
                    int lineNo = method.frame.getLineNumber();
                    boolean isNative = method.frame.isNative();
                    stackTrace[i] = new SimpleProfilingWriter.SimpleStackFrame(className, methodName, methodSignature, (short)lineNo, fileName, isNative);
                    if (!method.lockInfos.isEmpty()) {
                        ArrayList<MonitorObject> frameLocks = null;
                        for (ThreadDumpLockInfoLine lockInfo : method.lockInfos) {
                            MonitorObject monitor = this.createMonitorObject(lockInfo.getLockAddress(), lockInfo.getLockClass());
                            MonitorObjectUsage usage = this.convertToMonitorObjectUsage(lockInfo.getLockInfo());
                            if (i == 0 && usage == MonitorObjectUsage.WAITING) {
                                if (blocker != null) {
                                    throw new ThreadDumpFormatException("can't wait and be blocked at the same time: monitor id = " + blocker.getObjectId() + " thread: " + threadItem.nameLine.getName());
                                }
                                blocker = monitor;
                                status = ThreadStatus.THREAD_STATUS_OBJECT_WAIT;
                                continue;
                            }
                            if (i == 0 && usage == MonitorObjectUsage.BLOCKED) {
                                if (blocker != null) {
                                    throw new ThreadDumpFormatException("can't wait and be blocked at the same time: monitor id = " + blocker.getObjectId() + " thread: " + threadItem.nameLine.getName());
                                }
                                blocker = monitor;
                                status = ThreadStatus.THREAD_STATUS_LOCK_WAIT;
                                continue;
                            }
                            if (blocker != null && monitor.getObjectId() == blocker.getObjectId()) continue;
                            if (frameLocks == null && (frameLocks = (ArrayList<MonitorObject>)stackLocks.get(i)) == null) {
                                frameLocks = new ArrayList<MonitorObject>(method.lockInfos.size());
                                stackLocks.put(i, frameLocks);
                            }
                            this.monitorOwner.put(monitor, this.threadCounter);
                            frameLocks.add(monitor);
                        }
                    }
                    if (method.socketInfo != null) {
                        ThreadDumpSocketInfoLine.SocketData local = method.socketInfo.getLocalSocket();
                        ThreadDumpSocketInfoLine.SocketData remote = method.socketInfo.getRemoteSocket();
                        SocketObjectUsage socketUsage = SocketObjectUsage.UNKNOWN;
                        String upperMethodName = methodName.toUpperCase();
                        if (upperMethodName.contains("READ")) {
                            socketUsage = SocketObjectUsage.READING;
                        } else if (upperMethodName.contains("WRITE")) {
                            socketUsage = SocketObjectUsage.WRITING;
                        } else if (upperMethodName.contains("ACCEPT")) {
                            socketUsage = SocketObjectUsage.ACCEPTING;
                        } else if (upperMethodName.contains("CONNECT")) {
                            socketUsage = SocketObjectUsage.CONNECTING;
                        }
                        IpAddress localIpAddr = this.convertToIpAddress(local.getAddress());
                        IpAddress remoteIpAddr = this.convertToIpAddress(remote.getAddress());
                        this.sessionWriter.writeSocketAddress(localIpAddr, local.getHostname());
                        this.sessionWriter.writeSocketAddress(remoteIpAddr, remote.getHostname());
                        socketInfo = new SocketObject(localIpAddr, (char)local.getPort(), remoteIpAddr, (char)remote.getPort(), socketUsage);
                    }
                    ++i;
                }
                int stackTraceId = this.sessionWriter.writeStackTrace(stackTrace);
                if (threadItem.stateLine != null && status == ThreadStatus.THREAD_STATUS_UNKNOWN) {
                    status = this.convertToThreadStatus(threadItem.stateLine.getThreadStatus());
                }
                long kernelId = 0L;
                long nativeId = 0L;
                long pthreadId = 0L;
                int priority = 0;
                if (threadItem.idLine != null) {
                    kernelId = threadItem.idLine.getKernelID();
                    nativeId = threadItem.idLine.getNativeID();
                    pthreadId = threadItem.idLine.getPthreadID();
                    priority = threadItem.idLine.getPrio();
                }
                boolean isDaemon = threadItem.nameLine.isDaemon();
                UTF8String name = UTF8Creator.create(threadItem.nameLine.getName());
                long cpuTime = 0L;
                long cpuTimeReset = 0L;
                long elapsedTime = 0L;
                long elapsedTimeReset = 0L;
                long memoryConsumption = 0L;
                long memoryConsumptionReset = 0L;
                if (threadItem.nameLine != null) {
                    cpuTime = threadItem.nameLine.getCpuTime();
                    elapsedTime = threadItem.nameLine.getElapsedTime();
                    memoryConsumption = threadItem.nameLine.getBytesAllocated();
                    cpuTimeReset = threadItem.nameLine.getCpuTimeReset();
                    elapsedTimeReset = threadItem.nameLine.getElapsedTimeReset();
                    memoryConsumptionReset = threadItem.nameLine.getBytesAllocatedReset();
                    priority = Math.max(priority, threadItem.nameLine.getPrio());
                }
                long numFilesOpen = 0L;
                long numFilesOpenReset = 0L;
                long numSocketsOpen = 0L;
                long numSocketsOpenReset = 0L;
                long[] fileBytes = null;
                long[] fileBytesReset = null;
                long[] socketBytes = null;
                long[] socketBytesReset = null;
                if (threadItem.ioLine != null) {
                    numFilesOpen = threadItem.ioLine.getNumFilesOpen();
                    numSocketsOpen = threadItem.ioLine.getNumSocketsOpen();
                    fileBytes = threadItem.ioLine.getFileBytes();
                    socketBytes = threadItem.ioLine.getSocketBytes();
                    numFilesOpenReset = threadItem.ioLine.getNumFilesOpenReset();
                    numSocketsOpenReset = threadItem.ioLine.getNumSocketsOpenReset();
                    fileBytesReset = threadItem.ioLine.getFileBytesReset();
                    socketBytesReset = threadItem.ioLine.getSocketBytesReset();
                }
                ThreadDumpItem item = ThreadDumpItemImpl.create(this.threadCounter++, kernelId, nativeId, pthreadId, status, isDaemon, name, priority, cpuTime, elapsedTime, memoryConsumption, numFilesOpen, numSocketsOpen, fileBytes, socketBytes, cpuTimeReset, elapsedTimeReset, memoryConsumptionReset, numFilesOpenReset, numSocketsOpenReset, fileBytesReset, socketBytesReset, socketInfo, blocker, stackLocks, stackTraceId);
                this.curThreadItems.add(item);
            }
            catch (IOException e) {
                this.logMessage(String.format("Could not write data for thread with name '%s'. Reason: %s.", threadItem.nameLine.getName(), e.getMessage()), LogSeverity.ERROR);
            }
            catch (ThreadDumpFormatException e) {
                this.logMessage(String.format("Could not process additional monitor data. Reason: %s.", e.getMessage()), LogSeverity.ERROR);
            }
        }

        @Override
        public void onThreadDumpUnknownLine(String line, int lineNo) {
            ++this.unknownLines;
        }

        @Override
        public void onThreadDumpLineParseError(String line, int lineNo, String reason) {
            this.logMessage(String.format("Could not parse line '%s' (line %d): %s.", line, lineNo, reason), LogSeverity.ERROR);
        }

        @Override
        public void onThreadDumpEnd() {
        }

        @Override
        public void onNewThreadDumpFile(String imortFilePath) {
            if (this.adaptImportFileName) {
                File path = new File(imortFilePath);
                this.importFileName = path.isDirectory() ? "import" : path.getName();
            }
            if (this.sessionWriter == null) {
                try {
                    this.generateFilePath = this.getGenerateFileName(this.importFileName);
                    this.logMessage(String.format("Starting new profiling file %s.", this.generateFilePath), LogSeverity.INFO);
                    this.sessionWriter = new SimpleProfilingWriter(new FileOutputStream(this.generateFilePath), this.major, this.minor, this.micro, true);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private String getGenerateFileName(String fileName) {
            assert (this.generatePath != null);
            assert (!fileName.contains(File.pathSeparator));
            String destFileName = fileName;
            String extension = null;
            int extIndex = destFileName.lastIndexOf(46);
            if (extIndex > 0) {
                extension = destFileName.substring(extIndex);
                destFileName = destFileName.substring(0, extIndex);
            }
            String result = destFileName = this.generatePath + File.separator + destFileName;
            HashSet<String> alreadyGenerated = new HashSet<String>(this.generatedFiles);
            int i = 1;
            while (alreadyGenerated.contains(result)) {
                result = destFileName + " (" + i + ")";
                ++i;
            }
            if (!this.adaptImportFileName && extension != null) {
                result = result + extension;
            }
            return result;
        }

        public void logMessage(String message, LogSeverity level) {
            try {
                if (this.logWriter != null) {
                    if (level != LogSeverity.INFO) {
                        this.logWriter.write(level.name() + ": " + message + "\n");
                    } else {
                        this.logWriter.write(message + "\n");
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private ThreadStatus convertToThreadStatus(ThreadDumpStateLine.ThreadState threadState) {
            switch (threadState) {
                case THREAD_STATE_RUNNABLE: {
                    return ThreadStatus.THREAD_STATUS_RUNNING;
                }
                case THREAD_STATE_SLEEPING: {
                    return ThreadStatus.THREAD_STATUS_SLEEPING;
                }
                case THREAD_STATE_WAIT: 
                case THREAD_STATE_WAIT_TIMED: {
                    return ThreadStatus.THREAD_STATUS_OBJECT_WAIT;
                }
                case THREAD_STATE_WAITLOCK: 
                case THREAD_STATE_WAITLOCK_TIMED: 
                case THREAD_STATE_WAITOBJECTMONITOR: {
                    return ThreadStatus.THREAD_STATUS_LOCK_WAIT;
                }
            }
            return ThreadStatus.THREAD_STATUS_UNKNOWN;
        }

        private MonitorObjectUsage convertToMonitorObjectUsage(ThreadDumpLockInfoLine.LockInfo value) {
            switch (value) {
                case PARKED: 
                case BLOCKED: 
                case RELOCKING: {
                    return MonitorObjectUsage.BLOCKED;
                }
                case WAITING: {
                    return MonitorObjectUsage.WAITING;
                }
                case LOCKING: {
                    return MonitorObjectUsage.LOCKED;
                }
            }
            return MonitorObjectUsage.UNKNOWN;
        }

        private IpAddress convertToIpAddress(ThreadDumpSocketInfoLine.IPAddress ipAddress) {
            if (ipAddress.isIpv4Addr()) {
                return new IpAddressV4Impl(ipAddress.getAddr());
            }
            return new IpAddressV6Impl(ipAddress.getNetworkPrefix(), ipAddress.getHostAddress());
        }

        private void resolveBlockingThreads() {
            HashMap<Integer, ThreadDumpItem> index2ThreadDumpItem = new HashMap<Integer, ThreadDumpItem>();
            for (ThreadDumpItem item : this.curThreadItems) {
                index2ThreadDumpItem.put(item.getThreadIndex(), item);
                MonitorObject blocker = item.getMonitorObject();
                if (blocker != null) {
                    Integer blockingIndex = this.monitorOwner.get(blocker);
                    if (blockingIndex != null && blockingIndex >= 0 && item.getThreadIndex() != blockingIndex.intValue()) {
                        item.setBlockingThreadIndex(blockingIndex);
                    } else {
                        item.setStatus(ThreadStatus.THREAD_STATUS_OBJECT_WAIT);
                    }
                }
                if (item.getStatus() != ThreadStatus.THREAD_STATUS_LOCK_WAIT || item.getMonitorObject() != null) continue;
                this.logMessage(String.format("Found blocked thread '%s' without lock object. Set to runnable state.", item.getName()), LogSeverity.WARNING);
                ((ThreadDumpItemImpl)item).setStatus(ThreadStatus.THREAD_STATUS_RUNNING);
            }
            HashSet<ThreadDumpItem> visited = new HashSet<ThreadDumpItem>();
            int cycleIndex = 1;
            block1: for (ThreadDumpItem item : this.curThreadItems) {
                if (visited.contains(item)) continue;
                visited.add(item);
                HashSet<ThreadDumpItem> cycle = new HashSet<ThreadDumpItem>();
                ThreadDumpItem blockedItem = item;
                while (blockedItem.hasBlockingThread()) {
                    ThreadDumpItem nextBlockedItem = (ThreadDumpItem)index2ThreadDumpItem.get(blockedItem.getBlockingThreadIndex());
                    if (cycle.contains(nextBlockedItem)) {
                        ThreadDumpItem cycleItem = blockedItem;
                        do {
                            assert (cycle.contains(cycleItem) || cycleItem == blockedItem);
                            cycleItem.setDeadlockCycleIndex(cycleIndex);
                        } while ((cycleItem = (ThreadDumpItem)index2ThreadDumpItem.get(cycleItem.getBlockingThreadIndex())) != blockedItem);
                        ++cycleIndex;
                        continue block1;
                    }
                    if (visited.contains(nextBlockedItem)) continue block1;
                    cycle.add(blockedItem);
                    visited.add(blockedItem);
                    blockedItem = nextBlockedItem;
                }
            }
        }

        private void finishCurrentThreadDump() {
            if (!this.curThreadItems.isEmpty()) {
                this.resolveBlockingThreads();
                ThreadDumpItem[] threadDumpItems = this.curThreadItems.toArray(new ThreadDumpItem[0]);
                ThreadDumpImpl threadDump = new ThreadDumpImpl(this.timestamp, threadDumpItems);
                this.threadDumps.add(threadDump);
            }
            this.curThreadItems.clear();
            this.monitorOwner.clear();
            this.threadCounter = 1;
            this.timestamp = 0L;
            this.unknownLines = 0;
        }

        protected void close() throws IOException, ThreadDumpFormatException {
            this.close(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void close(boolean closeLog) throws IOException, ThreadDumpFormatException {
            this.finishCurrentThreadDump();
            Calendar date = Calendar.getInstance();
            date.setTimeInMillis(this.timestamp);
            ThreadDump[] sortedThreadDumps = this.threadDumps.toArray(new ThreadDump[0]);
            Arrays.sort(sortedThreadDumps, new Comparator<ThreadDump>(){

                @Override
                public int compare(ThreadDump lhs, ThreadDump rhs) {
                    long rhsVal;
                    long lhsVal = lhs.getTimeStamp();
                    return lhsVal > (rhsVal = rhs.getTimeStamp()) ? 1 : (lhsVal == rhsVal ? 0 : -1);
                }
            });
            int i = 0;
            while (i < sortedThreadDumps.length) {
                ThreadDump curThreadDump = sortedThreadDumps[i];
                long baseTimeStamp = curThreadDump.getTimeStamp();
                int curIndex = i;
                while (++i < sortedThreadDumps.length && sortedThreadDumps[i].getTimeStamp() <= baseTimeStamp) {
                }
                int numEqual = i - curIndex;
                if (numEqual <= 1) continue;
                long deltaMs = 0L;
                long fractionMs = 1000 / numEqual;
                for (int j = curIndex; j < i; ++j) {
                    ((ThreadDumpImpl)sortedThreadDumps[j]).setTimeStamp(baseTimeStamp + deltaMs);
                    deltaMs += fractionMs;
                }
            }
            boolean wrote = false;
            ThreadDumpFormatException notMatchEx = null;
            if (sortedThreadDumps.length > 0) {
                ThreadDump[] reporter = new ProgressReporter();
                try {
                    ThreadDumpFactory.createThreadDumpSummary(sortedThreadDumps, null, (ProgressReporter)reporter);
                }
                catch (ThreadDumpsNotMatchException e1) {
                    this.logMessage(String.format("Could not write %d dumps because there was at least one inconsistent thread run: %s.", sortedThreadDumps.length, e1.getMessage()), LogSeverity.ERROR);
                    notMatchEx = new ThreadDumpFormatException(e1.getMessage());
                }
                finally {
                    reporter.finish();
                }
            }
            if (sortedThreadDumps.length > 0 && notMatchEx == null) {
                this.sessionWriter.writeThreadDumpsStart(sortedThreadDumps.length, sortedThreadDumps[0].getTimeStamp());
                for (ThreadDump threadDump : sortedThreadDumps) {
                    try {
                        this.logMessage(String.format("Skipped %d unknown line(s).", this.unknownLines), LogSeverity.INFO);
                        this.logMessage(String.format("Finish thread dump thread at %s (number of Threads: %d).", dateFormat.format(date.getTime()), threadDump.getNumThreads()), LogSeverity.INFO);
                        this.sessionWriter.writeThreadDump(threadDump);
                        wrote = true;
                    }
                    catch (IOException e) {
                        this.logMessage(String.format("Could not write data for complete thread dump at %s (number of Threads: %d). Reason: %s.", dateFormat.format(date.getTime()), threadDump.getNumThreads(), e.getMessage()), LogSeverity.ERROR);
                    }
                }
                long endTimestamp = sortedThreadDumps[sortedThreadDumps.length - 1].getTimeStamp();
                this.sessionWriter.writeThreadDumpsEnd(endTimestamp);
            }
            if (wrote) {
                this.generatedFiles.add(this.generateFilePath);
            }
            this.threadDumps.clear();
            if (closeLog) {
                this.logWriter.close();
            }
            if (this.sessionWriter != null) {
                this.sessionWriter.close();
            }
            if (notMatchEx != null) {
                throw notMatchEx;
            }
        }

        public static enum LogSeverity {
            INFO,
            WARNING,
            ERROR;

        }
    }
}

