/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.thread.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.thread.command.ThreadDumpConfiguration;
import com.sap.jvm.profiling.thread.event.ThreadDumpEventHandler;
import com.sap.jvm.profiling.thread.response.EnableThreadDumpsResponse;
import java.io.IOException;

public final class EnableThreadDumpsResponseImpl
extends ResponseImpl
implements EnableThreadDumpsResponse {
    public ThreadDumpConfiguration threadDumpConfiguration = new ThreadDumpConfiguration();

    private EnableThreadDumpsResponseImpl(ResourceReader reader) throws IOException {
        super("enable thread dumps trace response", reader);
        this.threadDumpConfiguration.setNumThreadDumps(reader.readInt32());
        this.threadDumpConfiguration.setPeriod(reader.readInt64());
        this.threadDumpConfiguration.setDelay(reader.readInt64());
    }

    public static EnableThreadDumpsResponseImpl read(ResourceReader reader, MappingInformation mapInfo, ThreadDumpEventHandler[] handlers) throws IOException {
        EnableThreadDumpsResponseImpl response = new EnableThreadDumpsResponseImpl(reader);
        for (ThreadDumpEventHandler handler : handlers) {
            handler.handle(response);
        }
        return response;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ENABLE_THREAD_DUMPS_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
        stream.formatln("number = %d, period = %d [ms], delay = %d [ms]", this.threadDumpConfiguration.getNumThreadDumps(), this.threadDumpConfiguration.getPeriod(), this.threadDumpConfiguration.getDelay());
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1069);
        this.writeInternal(writer);
        writer.writeInt32(this.threadDumpConfiguration.getNumThreadDumps());
        writer.writeInt64(this.threadDumpConfiguration.getPeriod());
        writer.writeInt64(this.threadDumpConfiguration.getDelay());
        writer.finalizePacket();
    }

    @Override
    public ThreadDumpConfiguration getConfiguration() {
        return this.threadDumpConfiguration;
    }
}

