/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.tools;

import com.sap.jvm.profiling.OfflineProfilingSession;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public class Reader {
    public static void main(String[] args) {
        int offset = 0;
        boolean skipEvents = false;
        if (args.length < 1) {
            System.out.println("Syntax: Reader [-silent-events] [-ignore-line-nrs] [-skip-events] <prof-file>");
            return;
        }
        boolean printEventPackets = true;
        if (args[offset].equals("-silent-events")) {
            printEventPackets = false;
            ++offset;
        }
        if (args[offset].equals("-skip-events")) {
            skipEvents = true;
            ++offset;
        }
        ProfilingReader reader = null;
        try {
            OfflineProfilingSession session = ProfilingFactory.createSession(args[offset]);
            reader = session.getReader();
            if (skipEvents) {
                reader.nextPacket();
                return;
            }
            ProfilingPacketImpl packet = null;
            while ((packet = (ProfilingPacketImpl)reader.nextPacket()) != null) {
                if (!printEventPackets) continue;
                packet.print(System.out);
                System.out.println();
            }
        }
        catch (IOException ex) {
            Trace.error((Throwable)ex, "Could not process profiling file");
        }
    }
}

