/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.util;

public abstract class AbstractCollector {
    protected static final int CHUNK_SIZE = 65536;
    private static final double MAX_LOAD = 0.75;
    private static final double INC_AMOUNT = 0.2;
    private int nrHashElements;
    private int maxHashElements;
    private int nrOfHashChunks;
    private int usedInHashLongArray;
    private long[] hashLongArray;
    public long[] snapshotLongArray;

    protected abstract int hashCode(int var1, int var2);

    protected abstract boolean isEmpty(int var1, int var2);

    protected abstract boolean isSame(int var1, int var2, int var3, int var4);

    protected abstract void swap(int var1, int var2, int var3, int var4);

    protected abstract void resizeChunkArray(int var1, int var2);

    protected abstract void createSnapshotArray(int var1);

    protected abstract void addSnapshotChunk(int var1, int var2);

    protected abstract void moveToSnapshot(int var1, int var2, int var3, int var4);

    protected abstract void addChunk(int var1);

    protected abstract void removeChunk(int var1);

    protected final void init() {
        this.resizeChunkArray(0, 1);
        this.addChunk(0);
        this.nrOfHashChunks = 1;
        this.maxHashElements = 49152;
    }

    protected final int findPosToAdd() {
        int hashCode = this.hashCode(0, 0);
        int nrOfPositions = this.nrOfHashChunks * 65536;
        int pos = 1 + hashCode % (nrOfPositions - 1);
        int chunkIndex = pos / 65536;
        int index = pos & 0xFFFF;
        while (!this.isEmpty(chunkIndex, index)) {
            if (this.isSame(0, 0, chunkIndex, index)) {
                return index + chunkIndex * 65536;
            }
            if (++index < 65536) continue;
            index = 0;
            if (++chunkIndex < this.nrOfHashChunks) continue;
            chunkIndex = 0;
            index = 1;
        }
        if (this.nrHashElements == this.maxHashElements) {
            this.resize();
            return this.findPosToAdd();
        }
        ++this.nrHashElements;
        return index + chunkIndex * 65536;
    }

    public final int createSnapshot(int chunkSize, boolean deleteHash) {
        int nrOfNeededChunks = (this.nrHashElements + chunkSize - 1) / chunkSize;
        int lastChunkSize = this.nrHashElements - (nrOfNeededChunks - 1) * chunkSize;
        int destChunkSize = chunkSize;
        int destChunkIndex = 0;
        int destIndex = 0;
        if (nrOfNeededChunks == 1) {
            destChunkSize = lastChunkSize;
        }
        if (nrOfNeededChunks > 0) {
            this.createSnapshotArray(nrOfNeededChunks);
            this.addSnapshotChunk(0, destChunkSize);
        }
        int srcIndex = 1;
        for (int srcChunkIndex = 0; srcChunkIndex < this.nrOfHashChunks; ++srcChunkIndex) {
            while (srcIndex < 65536) {
                if (!this.isEmpty(srcChunkIndex, srcIndex)) {
                    this.moveToSnapshot(srcChunkIndex, srcIndex, destChunkIndex, destIndex);
                    if (++destIndex >= destChunkSize) {
                        destIndex = 0;
                        if (++destChunkIndex >= nrOfNeededChunks - 1) {
                            destChunkSize = lastChunkSize;
                        }
                        if (destChunkIndex < nrOfNeededChunks) {
                            this.addSnapshotChunk(destChunkIndex, destChunkSize);
                        }
                    }
                }
                ++srcIndex;
            }
            if (deleteHash) {
                this.removeChunk(srcChunkIndex);
            }
            srcIndex = 0;
        }
        this.snapshotLongArray = new long[this.usedInHashLongArray];
        if (this.usedInHashLongArray > 0) {
            System.arraycopy(this.hashLongArray, 0, this.snapshotLongArray, 0, this.usedInHashLongArray);
        }
        if (deleteHash) {
            this.hashLongArray = null;
        }
        return this.nrHashElements;
    }

    public final void deleteSnapshot() {
        this.createSnapshotArray(0);
    }

    private final void resize() {
        int chunksToAdd = Math.max(1, (int)(0.1 * (double)this.nrOfHashChunks));
        this.resizeChunkArray(this.nrOfHashChunks, this.nrOfHashChunks + chunksToAdd);
        for (int i = 0; i < chunksToAdd; ++i) {
            this.addChunk(this.nrOfHashChunks + i);
        }
        this.nrOfHashChunks += chunksToAdd;
        this.maxHashElements = (int)(0.75 * (double)this.nrOfHashChunks * 65536.0);
        char[] isNew = new char[(this.nrOfHashChunks * 65536 + 15) / 16];
        int nrOfPositions = this.nrOfHashChunks * 65536;
        int index = 1;
        for (int chunkIndex = 0; chunkIndex < this.nrOfHashChunks - 1; ++chunkIndex) {
            while (index < 65536) {
                if (!AbstractCollector.isSet(chunkIndex * 65536 + index, isNew)) {
                    if (!this.isEmpty(chunkIndex, index)) {
                        int hashCode = this.hashCode(chunkIndex, index);
                        int pos = 1 + hashCode % (nrOfPositions - 1);
                        int newChunkIndex = pos / 65536;
                        int newIndex = pos & 0xFFFF;
                        while (AbstractCollector.isSet(newChunkIndex * 65536 + newIndex, isNew) && !this.isEmpty(newChunkIndex, newIndex)) {
                            if (++newIndex < 65536) continue;
                            newIndex = 0;
                            if (++newChunkIndex < this.nrOfHashChunks) continue;
                            newChunkIndex = 0;
                            newIndex = 1;
                        }
                        this.swap(chunkIndex, index, newChunkIndex, newIndex);
                        if (this.isEmpty(chunkIndex, index)) {
                            ++index;
                        }
                        AbstractCollector.set(newChunkIndex * 65536 + newIndex, isNew);
                        continue;
                    }
                    ++index;
                    continue;
                }
                ++index;
            }
            index = 0;
        }
    }

    protected final void add(long value, int[] array, int pos) {
        int oldVal = array[pos];
        if (oldVal < 0) {
            int n = -oldVal - 1;
            this.hashLongArray[n] = this.hashLongArray[n] + value;
        } else {
            long newVal = (long)oldVal + value;
            if (newVal >>> 31 != 0L) {
                int slot = this.getLongArraySlot();
                array[pos] = -slot - 1;
                this.hashLongArray[slot] = newVal;
            } else {
                assert ((int)newVal >= 0);
                array[pos] = (int)newVal;
            }
        }
    }

    private final int getLongArraySlot() {
        if (this.hashLongArray == null) {
            this.hashLongArray = new long[64];
        }
        if (this.usedInHashLongArray >= this.hashLongArray.length) {
            long[] newLongArray = new long[this.usedInHashLongArray + 64];
            System.arraycopy(this.hashLongArray, 0, newLongArray, 0, this.usedInHashLongArray);
            this.hashLongArray = newLongArray;
        }
        return this.usedInHashLongArray++;
    }

    private static final boolean isSet(int index, char[] bitArray) {
        return (bitArray[index >> 4] & 1 << (index & 0xF)) != 0;
    }

    private static final void set(int index, char[] bitArray) {
        int n = index >> 4;
        bitArray[n] = (char)(bitArray[n] | 1 << (index & 0xF));
    }

    public int getSize() {
        return this.nrHashElements;
    }
}

