/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.util;

import java.util.Arrays;

public final class IntArrayList {
    private int[] data = new int[32];
    private int len;

    public int get(int index) {
        assert (index < this.len);
        return this.data[index];
    }

    public void set(int index, int value) {
        assert (index < this.len);
        this.data[index] = value;
    }

    public void setSize(int size) {
        assert (size <= this.len);
        assert (size >= 0);
        this.len = size;
    }

    public void push(int value) {
        if (this.len >= this.data.length) {
            int[] newData = new int[this.data.length * 3 / 2];
            System.arraycopy(this.data, 0, newData, 0, this.len);
            this.data = newData;
        }
        this.data[this.len] = value;
        ++this.len;
    }

    public void pop() {
        assert (this.len > 0);
        --this.len;
    }

    public int getLast() {
        assert (this.len > 0);
        return this.data[this.len - 1];
    }

    public int size() {
        return this.len;
    }

    public void clear() {
        this.len = 0;
    }

    public int getMaxValue() {
        assert (this.len > 0);
        int max = this.data[0];
        for (int i = 1; i < this.len; ++i) {
            max = Math.max(max, this.data[i]);
        }
        return max;
    }

    public int getMinValue() {
        assert (this.len > 0);
        int min = this.data[0];
        for (int i = 1; i < this.len; ++i) {
            min = Math.min(min, this.data[i]);
        }
        return min;
    }

    public void sortAscendingAndUnique() {
        if (this.len <= 1) {
            return;
        }
        int last = this.data[0];
        boolean isSorted = true;
        for (int i = 1; i < this.len; ++i) {
            if (last > this.data[i]) {
                isSorted = false;
                break;
            }
            last = this.data[i];
        }
        if (!isSorted) {
            Arrays.sort(this.data, 0, this.len);
        }
        last = this.data[0];
        int newLen = 1;
        for (int i = 1; i < this.len; ++i) {
            if (last == this.data[i]) continue;
            this.data[newLen] = last = this.data[i];
            ++newLen;
        }
        this.len = newLen;
    }
}

