/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.util;

public final class IntHashSet {
    private static final int DEFAULT_SIZE = 8;
    private int[] data = new int[8];

    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0;
        }
    }

    public boolean add(int val) {
        int chunkIndex = val >> 5;
        int index = val & 0x1F;
        if (chunkIndex >= this.data.length) {
            int[] newData = new int[chunkIndex + 1];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        if ((this.data[chunkIndex] & 1 << index) != 0) {
            return false;
        }
        int n = chunkIndex;
        this.data[n] = this.data[n] | 1 << index;
        return true;
    }

    public boolean contains(int val) {
        int chunkIndex = val >> 5;
        if (chunkIndex >= this.data.length) {
            return false;
        }
        int index = val & 0x1F;
        return (this.data[chunkIndex] & 1 << index) != 0;
    }
}

