/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.util;

import com.sap.jvm.profiling.MapMetaInfo;
import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.SessionAssociated;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.HostNameManager;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.MethodObjectManager;
import com.sap.jvm.profiling.core.type.NonArrayClassObject;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.JRubyBoundMethodOracleImpl;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.ThreadAnnotationImpl;
import com.sap.jvm.profiling.impl.core.ThreadInfoImpl;
import com.sap.jvm.profiling.impl.core.event.SystemInfoImpl;
import com.sap.jvm.profiling.impl.core.type.ArrayClassObjectImpl;
import com.sap.jvm.profiling.impl.core.type.ClassLoaderObjectImpl;
import com.sap.jvm.profiling.impl.core.type.ClassObjectImpl;
import com.sap.jvm.profiling.impl.core.type.HostNameManagerImpl;
import com.sap.jvm.profiling.impl.core.type.InternalClassObjectImpl;
import com.sap.jvm.profiling.impl.core.type.InternedUTF8StringImpl;
import com.sap.jvm.profiling.impl.core.type.MethodObjectImpl;
import com.sap.jvm.profiling.impl.core.type.NetworkServiceNameManagerImpl;
import com.sap.jvm.profiling.impl.core.type.NonArrayClassObjectImpl;
import com.sap.jvm.profiling.impl.core.type.PackageNameImpl;
import com.sap.jvm.profiling.impl.core.type.PrimitiveClassObjectImpl;
import com.sap.jvm.profiling.impl.core.type.StackTraceManagerImpl;
import com.sap.jvm.profiling.impl.core.type.UTF8StringImpl;
import com.sap.jvm.profiling.impl.io.event.FileOpenEventImpl;
import com.sap.jvm.profiling.impl.io.event.ZipFileOpenEventImpl;
import com.sap.jvm.profiling.impl.jit.event.JitEventMethodCompilationImpl;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValuesImpl;
import com.sap.jvm.profiling.impl.method.event.MethodParameterDefinitionEventImpl;
import com.sap.jvm.profiling.impl.method.response.MethodParameterSpecImpl;
import com.sap.jvm.profiling.impl.monitoring.event.AbstractMonitoringBoardEventImpl;
import com.sap.jvm.profiling.impl.monitoring.event.MonitoringBoardDiffToInitialEventImpl;
import com.sap.jvm.profiling.impl.monitoring.event.MonitoringBoardDiffToPrevEventImpl;
import com.sap.jvm.profiling.impl.monitoring.event.MonitoringBoardInitialEventImpl;
import com.sap.jvm.profiling.impl.reader.ResourceReaderImpl;
import com.sap.jvm.profiling.impl.session.AbstractProfilingSessionImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.impl.util.PackageNameTable;
import com.sap.jvm.profiling.impl.util.UTF8StringTable;
import com.sap.jvm.profiling.io.event.FileOpenEvent;
import com.sap.jvm.profiling.method.event.MethodParameterDefinitions;
import com.sap.jvm.profiling.method.event.MethodParametersDefinition;
import com.sap.jvm.profiling.net.event.HostLookupEvent;
import com.sap.jvm.profiling.net.event.ServiceDiscoveryEvent;
import com.sap.jvm.profiling.net.event.SocketBindEvent;
import com.sap.jvm.profiling.net.event.SocketConnectEvent;
import com.sap.jvm.profiling.net.event.SocketOpenEvent;
import com.sap.jvm.profiling.resource.PacketResourceReader;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.util.splitarray.SplitArrayObject;
import com.sap.jvm.util.misc.UTF8Util;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class MappingInformationImpl
implements MappingInformation {
    public static final int INDEX_OFFSET = 1024;
    public static final boolean useGlobalStringTable = System.getProperty("com.sap.jvm.profiling.useGlobalStringTable", "true").equals("true");
    public static WeakReference<UTF8StringTable> globalStringTable;
    private final StackTraceManagerImpl stackManager;
    private final SplitArrayObject<ClassLoaderObjectImpl> classLoaderMapping;
    private Map<Long, Integer> classLoaderId2IndexMapping;
    private final SplitArrayObject<ClassObjectImpl> classMapping;
    private Map<Long, Integer> classId2IndexMapping;
    private final SplitArrayObject<MethodObjectImpl> methodMapping;
    private Map<Long, Integer> methodId2IndexMapping;
    private final UTF8StringTable stringTable;
    private final PackageNameTable packageTable;
    private final boolean ignoreLineNrs;
    private final AtomicInteger classLoaderIndexHolder;
    private final AtomicInteger classIndexHolder;
    private final AtomicInteger methodIndexHolder;
    private int definitionIndexOffset;
    private ThreadInfoImpl[] threadInfos;
    private long threadChangeCounts;
    private MethodParameterDefinitions parameterDefinitions;
    private int specOffset;
    private UTF8String[] annotationKeys;
    private UTF8String[] annotationDescriptions;
    private AbstractProfilingSessionImpl session;
    private ClassLoaderObjectImpl noStackClassLoader;
    private NonArrayClassObjectImpl noStackClass;
    private MethodObjectImpl noStackMethod;
    private PackageNameImpl noPackage;
    private ClassLoaderObjectImpl inlinedAwayClassLoader;
    private NonArrayClassObjectImpl inlinedAwayClass;
    private MethodObjectImpl inlinedAwayMethod;
    private PackageNameImpl inlinedAwayPackage;
    private PackageNameImpl rootPackage;
    private PackageNameImpl defaultPackage;
    private final UTF8StringImpl[] profilingMethodSpecs;
    private NonArrayClassObjectImpl javaLangObjectClass;
    private int nrOfEntryEventTimes;
    private GCHistoryInitialValues gcHistoryInitialValues;
    private long lastTbsTimeStamp;
    private long tbsElapsedTime;
    private long tbsSampleCount;
    private long nrOfHeartBeatPackets;
    private List<FileOpenEventImpl> fd2OpenEvent;
    private HashMap<ZipKey, ZipFileOpenEventImpl> zipKey2OpenEvents;
    private long currentUniqueFileId;
    private long mptId;
    private List<List<ProfilingPacketImpl>> fd2SocketEvents;
    private long currentUniqueSocketId;
    private final InternedUTF8StringImpl emptyString;
    private final HostNameManagerImpl hostManager;
    private NetworkServiceNameManagerImpl serviceManager;
    private JRubyBoundMethodOracleImpl boundMethodOracle;
    private JitEventMethodCompilationImpl[] jitCompilations;
    private byte[] lastBoard;
    private AbstractMonitoringBoardEventImpl lastBoardEvent;
    private String defaultTimeZone = "";
    private String userTimeZone = "";
    private long lastConcGcEndTimeStamp = -1L;

    public MappingInformationImpl(AbstractProfilingSessionImpl session, boolean ignoreLineNrs) {
        this.session = session;
        this.stackManager = new StackTraceManagerImpl((MethodObjectManager)this, true, (ProfilingSession)session);
        this.stackManager.addStackTrace(0, 0, 0, new MethodObject[0], new int[0]);
        this.stringTable = MappingInformationImpl.getOrCreateNewStringTable();
        this.packageTable = new PackageNameTable();
        this.emptyString = this.stringTable.intern(new InternedUTF8StringImpl(new byte[0]));
        this.classLoaderMapping = new SplitArrayObject(1);
        this.classLoaderId2IndexMapping = new HashMap<Long, Integer>();
        this.classMapping = new SplitArrayObject(1);
        this.classId2IndexMapping = new HashMap<Long, Integer>();
        this.methodMapping = new SplitArrayObject(1);
        this.methodId2IndexMapping = new HashMap<Long, Integer>();
        this.ignoreLineNrs = ignoreLineNrs;
        this.classLoaderIndexHolder = new AtomicInteger(1024);
        this.classIndexHolder = new AtomicInteger(1024);
        this.methodIndexHolder = new AtomicInteger(1024);
        this.setupSyntheticTypes();
        this.threadInfos = new ThreadInfoImpl[512];
        this.annotationKeys = new UTF8String[6];
        this.annotationDescriptions = new UTF8String[6];
        this.annotationKeys[0] = this.intern("user");
        this.annotationKeys[1] = this.intern("session");
        this.annotationKeys[2] = this.intern("request");
        this.annotationKeys[3] = this.intern("application");
        this.annotationKeys[4] = this.intern("isapplicationthread");
        this.annotationKeys[5] = this.intern("tenant");
        this.profilingMethodSpecs = this.getProfilingMethods();
        this.mptId = 0L;
        this.parameterDefinitions = new MethodParameterDefinitions();
        this.fd2OpenEvent = new ArrayList<FileOpenEventImpl>(Arrays.asList(new FileOpenEventImpl[32768]));
        this.zipKey2OpenEvents = new HashMap();
        this.currentUniqueFileId = 0L;
        this.fd2SocketEvents = new ArrayList<List<ProfilingPacketImpl>>();
        this.currentUniqueSocketId = 0L;
        this.hostManager = new HostNameManagerImpl();
        this.serviceManager = new NetworkServiceNameManagerImpl();
        this.jitCompilations = new JitEventMethodCompilationImpl[10];
    }

    public MappingInformationImpl(PacketResourceReader reader, MapMetaInfo mapMetaInfo, ProgressReporter progressReporter) throws IOException {
        this.session = (AbstractProfilingSessionImpl)reader.getSession();
        this.session.setMapInfo(this);
        this.ignoreLineNrs = false;
        this.stackManager = new StackTraceManagerImpl((MethodObjectManager)this, mapMetaInfo.nrOfStackTraces, (ProfilingSession)this.session);
        this.stringTable = MappingInformationImpl.getOrCreateNewStringTable();
        this.emptyString = this.stringTable.intern(new InternedUTF8StringImpl(new byte[0]));
        this.packageTable = new PackageNameTable();
        this.classLoaderMapping = new SplitArrayObject(mapMetaInfo.nrOfClassLoaders);
        this.classMapping = new SplitArrayObject(mapMetaInfo.nrOfClasses);
        this.methodMapping = new SplitArrayObject(mapMetaInfo.nrOfMethods);
        this.parameterDefinitions = new MethodParameterDefinitions();
        this.classLoaderIndexHolder = new AtomicInteger(1024);
        this.classIndexHolder = new AtomicInteger(1024);
        this.methodIndexHolder = new AtomicInteger(1024);
        this.setupSyntheticTypes();
        this.threadInfos = new ThreadInfoImpl[512];
        this.annotationKeys = new UTF8String[mapMetaInfo.nrOfAnnotationDefinitions];
        this.annotationDescriptions = new UTF8String[mapMetaInfo.nrOfAnnotationDefinitions];
        boolean hasNext = reader.nextPacket();
        if (hasNext && reader.getType() == 761) {
            MonitoringBoardInitialEventImpl board = new MonitoringBoardInitialEventImpl(reader);
            this.session.setInitialMonitoringBoard(board);
            hasNext = reader.nextPacket();
        }
        if (hasNext && reader.getType() == 407) {
            SystemInfoImpl systemInfo = new SystemInfoImpl(reader);
            this.session.setSystemInfo(systemInfo);
        }
        this.readClassLoaders(mapMetaInfo.nrOfClassLoaders, reader, progressReporter);
        this.readClasses(mapMetaInfo.nrOfClasses, reader, progressReporter);
        for (int i = 0; i < mapMetaInfo.nrOfClassLoaders; ++i) {
            this.classLoaderMapping.get(i + 1024).fixupReferences(this);
        }
        this.readMethods(mapMetaInfo.nrOfMethods, reader, progressReporter);
        this.readMethodLocations(reader, progressReporter);
        this.readStackTraces(mapMetaInfo.nrOfStackTraces, reader, progressReporter);
        this.readAnnotationDefinitions(mapMetaInfo.nrOfAnnotationDefinitions, reader);
        this.readMethodParameterInfo(mapMetaInfo.nrOfSpecs, mapMetaInfo.nrOfDefinitionSets, reader);
        this.stackManager.notifyStackTracesFinished();
        this.profilingMethodSpecs = this.getProfilingMethods();
        this.mptId = 0L;
        if (mapMetaInfo.hasGcStatistic) {
            hasNext = reader.nextPacket();
            assert (hasNext);
            this.addGCHistoryInitialValues(reader);
        }
        this.defaultTimeZone = mapMetaInfo.defaultTimeZone;
        this.userTimeZone = mapMetaInfo.userTimeZone;
        this.nrOfHeartBeatPackets = mapMetaInfo.nrOfHeartBeatPackets;
        this.fd2OpenEvent = new ArrayList<FileOpenEventImpl>(Arrays.asList(new FileOpenEventImpl[32768]));
        this.zipKey2OpenEvents = new HashMap();
        this.currentUniqueFileId = 0L;
        this.fd2SocketEvents = new ArrayList<List<ProfilingPacketImpl>>();
        this.currentUniqueSocketId = 0L;
        this.hostManager = new HostNameManagerImpl(reader, progressReporter, mapMetaInfo.nrOfHostnames);
        this.serviceManager = new NetworkServiceNameManagerImpl(reader, progressReporter, mapMetaInfo.nrOfServices);
        this.jitCompilations = new JitEventMethodCompilationImpl[10];
    }

    private MappingInformationImpl(MappingInformationImpl mapInfo) {
        this.session = mapInfo.session;
        this.classLoaderMapping = mapInfo.classLoaderMapping;
        this.classMapping = mapInfo.classMapping;
        this.methodMapping = mapInfo.methodMapping;
        this.stackManager = mapInfo.stackManager;
        this.ignoreLineNrs = mapInfo.ignoreLineNrs;
        this.classIndexHolder = mapInfo.classIndexHolder;
        this.classLoaderIndexHolder = mapInfo.classLoaderIndexHolder;
        this.definitionIndexOffset = mapInfo.definitionIndexOffset;
        this.methodIndexHolder = mapInfo.methodIndexHolder;
        this.stringTable = mapInfo.stringTable;
        this.emptyString = mapInfo.emptyString;
        this.packageTable = mapInfo.packageTable;
        this.parameterDefinitions = mapInfo.parameterDefinitions;
        this.hostManager = mapInfo.hostManager;
        this.serviceManager = mapInfo.serviceManager;
        this.defaultTimeZone = mapInfo.defaultTimeZone;
        this.userTimeZone = mapInfo.userTimeZone;
        this.fd2OpenEvent = new ArrayList<FileOpenEventImpl>(Arrays.asList(new FileOpenEventImpl[32768]));
        this.zipKey2OpenEvents = new HashMap();
        this.currentUniqueFileId = 0L;
        this.fd2SocketEvents = new ArrayList<List<ProfilingPacketImpl>>();
        this.currentUniqueSocketId = 0L;
        this.threadInfos = new ThreadInfoImpl[512];
        this.annotationKeys = new UTF8String[6];
        this.annotationDescriptions = new UTF8String[6];
        this.annotationKeys[0] = this.intern("user");
        this.annotationKeys[1] = this.intern("session");
        this.annotationKeys[2] = this.intern("request");
        this.annotationKeys[3] = this.intern("application");
        this.annotationKeys[4] = this.intern("isapplicationthread");
        this.annotationKeys[5] = this.intern("tenant");
        this.noStackClassLoader = mapInfo.noStackClassLoader;
        this.noStackClass = mapInfo.noStackClass;
        this.noStackMethod = mapInfo.noStackMethod;
        this.noPackage = mapInfo.noPackage;
        this.inlinedAwayClassLoader = mapInfo.inlinedAwayClassLoader;
        this.inlinedAwayClass = mapInfo.inlinedAwayClass;
        this.inlinedAwayMethod = mapInfo.inlinedAwayMethod;
        this.inlinedAwayPackage = mapInfo.inlinedAwayPackage;
        this.rootPackage = mapInfo.rootPackage;
        this.defaultPackage = mapInfo.defaultPackage;
        this.javaLangObjectClass = mapInfo.javaLangObjectClass;
        this.profilingMethodSpecs = this.getProfilingMethods();
        this.mptId = 0L;
        if (mapInfo.gcHistoryInitialValues != null) {
            this.gcHistoryInitialValues = mapInfo.gcHistoryInitialValues.copy();
        }
        this.nrOfHeartBeatPackets = mapInfo.getNrOfHeartBeatPackets();
        this.jitCompilations = new JitEventMethodCompilationImpl[10];
        this.lastBoard = null;
    }

    private static synchronized UTF8StringTable getOrCreateNewStringTable() {
        UTF8StringTable result;
        if (!useGlobalStringTable) {
            return new UTF8StringTable();
        }
        if (globalStringTable == null) {
            result = new UTF8StringTable();
            globalStringTable = new WeakReference<UTF8StringTable>(result);
        } else {
            result = (UTF8StringTable)globalStringTable.get();
            if (result == null) {
                result = new UTF8StringTable();
                globalStringTable = new WeakReference<UTF8StringTable>(result);
            }
        }
        return result;
    }

    private void setupSyntheticTypes() {
        this.noStackClassLoader = new ClassLoaderObjectImpl(this, this.getNoStack(), -1L, 1, this.session);
        this.addClassLoaderObject(this.noStackClassLoader);
        this.noStackClass = new NonArrayClassObjectImpl(this, this.getNoStack(), null, -1L, 1, this.noStackClassLoader, this.session);
        this.addClassObject(this.noStackClass);
        this.noStackMethod = new MethodObjectImpl(-1L, 1, this.noStackClass, this.getNoStack(), this.intern(""), this.intern("void"), 0, null);
        this.addMethodObject(this.noStackMethod, true);
        int noStackLocationIndex = this.stackManager.locationAddToHashSet(this.noStackMethod.getIndex(), 0);
        this.stackManager.setNoStackMethodLocation(this.stackManager.getLocation(noStackLocationIndex));
        this.noPackage = this.getPackageName(this.getNoStack(), false);
        this.inlinedAwayClassLoader = new ClassLoaderObjectImpl(this, this.getInlinedAway(), -2L, 2, this.session);
        this.addClassLoaderObject(this.inlinedAwayClassLoader);
        this.inlinedAwayClass = new NonArrayClassObjectImpl(this, this.getInlinedAway(), null, -2L, 2, this.inlinedAwayClassLoader, this.session);
        this.addClassObject(this.inlinedAwayClass);
        this.inlinedAwayMethod = new MethodObjectImpl(-2L, 2, this.inlinedAwayClass, this.getInlinedAway(), this.intern(""), this.intern("void"), 0, null);
        this.addMethodObject(this.inlinedAwayMethod, true);
        int inlinedAwayLocationIndex = this.stackManager.locationAddToHashSet(this.inlinedAwayMethod.getIndex(), 0);
        this.stackManager.setInlinedAwayMethodLocation(this.stackManager.getLocation(inlinedAwayLocationIndex));
        this.inlinedAwayPackage = this.getPackageName(this.getInlinedAway(), false);
        this.rootPackage = this.getPackageName(this.getRootPackage(), false);
        this.defaultPackage = this.getPackageName(this.getDefaultPackage(), false);
    }

    @Override
    public MappingInformation copy() {
        return new MappingInformationImpl(this);
    }

    @Override
    public int getNrOfClassLoaders() {
        return Math.max(0, this.classLoaderMapping.size() - 1024);
    }

    @Override
    public ClassLoaderObjectImpl getNoClassLoaderObject() {
        return this.noStackClassLoader;
    }

    @Override
    public ClassLoaderObjectImpl getInlinedAwayClassLoaderObject() {
        return this.inlinedAwayClassLoader;
    }

    @Override
    public ClassLoaderObjectImpl getClassLoaderObject(int index) {
        return this.classLoaderMapping.get(index);
    }

    @Override
    public ClassLoaderObjectImpl getClassLoaderObjectById(long id) {
        Integer index;
        Integer n = index = this.classLoaderId2IndexMapping != null ? this.classLoaderId2IndexMapping.get(id) : null;
        if (index != null) {
            return this.getClassLoaderObject(index);
        }
        for (int i = 1024; i < this.classLoaderMapping.size(); ++i) {
            ClassLoaderObjectImpl curr = this.classLoaderMapping.get(i);
            if (curr.getId() != id) continue;
            return curr;
        }
        return null;
    }

    @Override
    public void addClassLoaderObject(ClassLoaderObjectImpl classLoaderObject) {
        int classLoaderIndex = classLoaderObject.getIndex();
        this.classLoaderMapping.resize(classLoaderIndex + 1);
        this.classLoaderMapping.set(classLoaderIndex, classLoaderObject);
        if (this.classLoaderId2IndexMapping != null) {
            this.classLoaderId2IndexMapping.put(classLoaderObject.getId(), classLoaderIndex);
        }
    }

    @Override
    public void addClassLoaderObject(ResourceReader reader, boolean resolveClasses) throws IOException {
        this.addClassLoaderObject(new ClassLoaderObjectImpl(reader, this, this.classLoaderIndexHolder.getAndIncrement(), this.session, resolveClasses));
    }

    @Override
    public int getNrOfClasses() {
        return Math.max(0, this.classMapping.size() - 1024);
    }

    @Override
    public ClassObjectImpl getNoClassObject() {
        return this.noStackClass;
    }

    @Override
    public ClassObject getInlinedAwayClassObject() {
        return this.inlinedAwayClass;
    }

    @Override
    public NonArrayClassObjectImpl getJavaLangObjectClassObject() {
        assert (this.javaLangObjectClass != null);
        return this.javaLangObjectClass;
    }

    @Override
    public ClassObjectImpl getClassObject(int classIndex) {
        return this.classMapping.get(classIndex);
    }

    @Override
    public ClassObjectImpl getClassObjectById(long id) {
        Integer index;
        Integer n = index = this.classId2IndexMapping != null ? this.classId2IndexMapping.get(id) : null;
        if (index != null) {
            return this.getClassObject(index);
        }
        if (id == 0L) {
            return null;
        }
        for (int i = 1024; i < this.classMapping.size(); ++i) {
            if (this.classMapping.get(i).getId() != id) continue;
            return this.classMapping.get(i);
        }
        return null;
    }

    @Override
    public void addArrayClassObject(ResourceReader reader) throws IOException {
        ArrayClassObjectImpl classObject = new ArrayClassObjectImpl(reader, this, this.classIndexHolder.getAndIncrement());
        this.addClassObject(classObject);
    }

    @Override
    public void addInternalClassObject(ResourceReader reader) throws IOException {
        InternalClassObjectImpl classObject = new InternalClassObjectImpl(reader, this, this.classIndexHolder.getAndIncrement(), this.session);
        this.addClassObject(classObject);
    }

    public void addClassObject(ClassObjectImpl classObject) {
        int classIndex = classObject.getIndex();
        this.classMapping.resize(classIndex + 1);
        this.classMapping.set(classIndex, classObject);
        if (this.classId2IndexMapping != null) {
            this.classId2IndexMapping.put(classObject.getId(), classIndex);
        }
    }

    @Override
    public void addNonArrayClassObject(ResourceReader reader) throws IOException {
        NonArrayClassObjectImpl classObject = new NonArrayClassObjectImpl(reader, this, this.classIndexHolder.getAndIncrement());
        this.addClassObject(classObject);
        if (this.javaLangObjectClass == null && classObject.getSuperClass() == null && classObject.getFullName().equals("java.lang.Object")) {
            this.javaLangObjectClass = classObject;
        }
    }

    @Override
    public void addPrimitiveClassObject(ResourceReader reader) throws IOException {
        PrimitiveClassObjectImpl classObject = new PrimitiveClassObjectImpl(reader, this, this.classIndexHolder.getAndIncrement());
        this.addClassObject(classObject);
    }

    @Override
    public int getNrOfMethods() {
        return Math.max(0, this.methodMapping.size() - 1024);
    }

    @Override
    public MethodObjectImpl getMethodObject(int methodIndex) {
        return this.methodMapping.get(methodIndex);
    }

    @Override
    public MethodObjectImpl getNoMethodObject() {
        return this.noStackMethod;
    }

    @Override
    public MethodObject getInlinedAwayMethodObject() {
        return this.inlinedAwayMethod;
    }

    @Override
    public MethodObjectImpl getMethodObjectById(long id) {
        Integer index;
        Integer n = index = this.methodId2IndexMapping != null ? this.methodId2IndexMapping.get(id) : null;
        if (index != null) {
            return this.getMethodObject(index);
        }
        for (int i = 1024; i < this.methodMapping.size(); ++i) {
            if (this.methodMapping.get(i).getId() != id) continue;
            return this.methodMapping.get(i);
        }
        return null;
    }

    @Override
    public void addMethodObjectFromInternal(ResourceReader reader) throws IOException {
        if (this.boundMethodOracle == null) {
            this.boundMethodOracle = new JRubyBoundMethodOracleImpl(this);
        }
        MethodObjectImpl methodObject = MethodObjectImpl.createFromInternal(reader, this.boundMethodOracle, this, this.methodIndexHolder.getAndIncrement());
        this.addMethodObject(methodObject, true);
    }

    @Override
    public void addMethodObjectFromExternal(ResourceReader reader) throws IOException {
        MethodObjectImpl methodObject = MethodObjectImpl.createFromExternal(reader, this, this.session.getCapabilities(), this.methodIndexHolder.getAndIncrement());
        this.addMethodObject(methodObject, false);
    }

    private void addMethodObject(MethodObjectImpl methodObject, boolean addLocation) {
        int methodIndex = methodObject.getIndex();
        this.methodMapping.resize(methodIndex + 1);
        this.methodMapping.set(methodIndex, methodObject);
        if (this.methodId2IndexMapping != null) {
            this.methodId2IndexMapping.put(methodObject.getId(), methodIndex);
        }
        if (addLocation) {
            int locationIndex = this.stackManager.locationAddToHashSet(methodObject.getIndex(), 0);
            methodObject.setMethodLocation(this.stackManager.getLocation(locationIndex));
        }
    }

    @Override
    public StackTraceManagerImpl getStackTraceManager() {
        return this.stackManager;
    }

    @Override
    public void addStackTrace(ResourceReader reader) throws IOException {
        int sharedStackTraceId;
        int origStackTraceId = reader.readInt32();
        assert (origStackTraceId >= 0);
        int nrOfFrames = reader.readInt32();
        assert (nrOfFrames > 0 || origStackTraceId == 0);
        int nrOfSharedFrames = reader.readInt32();
        int nrOfFramesToRead = nrOfFrames - nrOfSharedFrames;
        assert (nrOfFrames >= nrOfSharedFrames);
        int n = sharedStackTraceId = nrOfSharedFrames > 0 || reader instanceof ResourceReaderImpl ? reader.readInt32() : 0;
        if (reader instanceof ResourceReaderImpl) {
            MethodObject[] methods = new MethodObjectImpl[nrOfFramesToRead];
            int[] lineNrs = new int[nrOfFramesToRead];
            for (int i = nrOfFramesToRead - 1; i >= 0; --i) {
                methods[i] = (MethodObjectImpl)reader.readMethodObject();
                lineNrs[i] = reader.readUint16();
            }
            this.stackManager.addStackTrace(sharedStackTraceId, origStackTraceId, nrOfSharedFrames, methods, lineNrs);
        } else {
            int[] locations = new int[nrOfFramesToRead];
            for (int i = nrOfFramesToRead - 1; i >= 0; --i) {
                locations[i] = reader.readInt32();
            }
            this.stackManager.addIndexedStackTrace(sharedStackTraceId, origStackTraceId, nrOfSharedFrames, locations);
        }
    }

    @Override
    public int getStackTraceIndexOfOriginalId(int originalId) {
        return this.stackManager.getIndexForId(originalId);
    }

    @Override
    public MethodParameterDefinitions getParameterDefinitions() {
        return this.parameterDefinitions;
    }

    @Override
    public int getNrOfAnnotationKeys() {
        return this.annotationKeys != null ? this.annotationKeys.length : 0;
    }

    @Override
    public UTF8String getAnnotationKey(int slot) {
        if (this.annotationKeys == null || slot >= this.annotationKeys.length) {
            return null;
        }
        return this.annotationKeys[slot];
    }

    @Override
    public UTF8String getAnnotationDescription(int slot) {
        if (this.annotationDescriptions == null || slot >= this.annotationDescriptions.length) {
            return null;
        }
        return this.annotationDescriptions[slot];
    }

    @Override
    public synchronized ThreadInfoImpl getThreadInfo(char index) {
        ThreadInfoImpl result = null;
        if (index < this.threadInfos.length) {
            result = this.threadInfos[index];
        }
        if (result == null) {
            result = this.createInvalidThreadInfo();
            this.setThreadInfo(index, result);
        }
        return result;
    }

    @Override
    public synchronized long getThreadChangeCount() {
        return this.threadChangeCounts;
    }

    @Override
    public synchronized void setThreadChangeCount(long changeCount) {
        this.threadChangeCounts = Math.max(this.threadChangeCounts, changeCount);
    }

    @Override
    public synchronized char getMaxIndex() {
        return (char)(this.threadInfos.length - 1);
    }

    private ThreadInfoImpl createInvalidThreadInfo() {
        UTF8String emptyStr = UTF8Creator.create("");
        ThreadAnnotationImpl[] annotations = new ThreadAnnotationImpl[5];
        for (int i = 0; i < annotations.length; ++i) {
            annotations[i] = new ThreadAnnotationImpl(i, emptyStr, this);
        }
        return ThreadInfoImpl.createNew('\uffff', -1L, emptyStr, annotations, 1L);
    }

    @Override
    public synchronized void setThreadInfo(int index, ThreadInfoImpl newInfo) {
        ThreadInfoImpl oldThreadInfo;
        if (index >= this.threadInfos.length) {
            int length = Math.min(Math.max(index + 1, 2 * this.threadInfos.length), 65536);
            ThreadInfoImpl[] newThreadInfos = new ThreadInfoImpl[length];
            System.arraycopy(this.threadInfos, 0, newThreadInfos, 0, this.threadInfos.length);
            this.threadInfos = newThreadInfos;
        }
        if (this.threadInfos[index] != null && ((oldThreadInfo = this.threadInfos[index]).getIndex() == '\uffff' || oldThreadInfo.getThreadId() == newInfo.getThreadId())) {
            newInfo.setTbsCpuTime(oldThreadInfo.getTbsCpuTime());
        }
        this.threadInfos[index] = newInfo;
    }

    @Override
    public void addThreadAnnotationKey(ResourceReader reader) throws IOException {
        short slot = reader.readInt16();
        InternedUTF8StringImpl key = this.intern(reader.readUTF());
        InternedUTF8StringImpl description = this.intern(reader.readUTF());
        if (slot >= this.annotationKeys.length) {
            UTF8String[] newAnnotationKeys = new UTF8String[slot + 1];
            UTF8String[] newAnnotationDescriptions = new UTF8String[slot + 1];
            for (int i = 0; i < this.annotationKeys.length; ++i) {
                newAnnotationKeys[i] = this.annotationKeys[i];
                newAnnotationDescriptions[i] = this.annotationDescriptions[i];
            }
            this.annotationKeys = newAnnotationKeys;
            this.annotationDescriptions = newAnnotationDescriptions;
        }
        this.annotationKeys[slot] = key;
        this.annotationDescriptions[slot] = description;
    }

    @Override
    public HashSet<UTF8String> getAllPackages() {
        HashSet<UTF8String> result = new HashSet<UTF8String>();
        for (int i = 1024; i < this.classMapping.size(); ++i) {
            result.add(this.classMapping.get(i).getPackageNameUTF());
        }
        return result;
    }

    @Override
    public String[] getMatchingPackagePrefixes(String prefix) {
        HashSet<String> prefixes = new HashSet<String>();
        for (int i = 1024; i < this.classMapping.size(); ++i) {
            String name = this.classMapping.get(i).getPackageName();
            if (!name.startsWith(prefix)) continue;
            prefixes.add(name);
        }
        return prefixes.toArray(new String[prefixes.size()]);
    }

    @Override
    public ClassObject[] getMatchingClassNames(String prefix) {
        HashSet<ClassObjectImpl> matches = new HashSet<ClassObjectImpl>();
        for (int i = 1024; i < this.classMapping.size(); ++i) {
            ClassObjectImpl current = this.classMapping.get(i);
            String name = current.getName();
            if (!name.startsWith(prefix)) continue;
            matches.add(current);
        }
        return matches.toArray(new ClassObjectImpl[matches.size()]);
    }

    @Override
    public ClassObjectImpl[] getMatchingFullClassNames(String prefix) {
        HashSet<ClassObjectImpl> matches = new HashSet<ClassObjectImpl>();
        for (int i = 1024; i < this.classMapping.size(); ++i) {
            String name;
            ClassObjectImpl current = this.classMapping.get(i);
            String packageName = current.getPackageName();
            if (packageName.length() == 0) {
                String name2 = current.getName();
                if (!name2.startsWith(prefix)) continue;
                matches.add(current);
                continue;
            }
            if (!prefix.startsWith(packageName)) continue;
            int packageLen = packageName.length();
            if (prefix.length() < packageLen + 1 || prefix.charAt(packageLen) != '.' || !(name = current.getName()).startsWith(prefix.substring(packageLen + 1))) continue;
            matches.add(current);
        }
        return matches.toArray(new ClassObjectImpl[matches.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodObject[] getMatchingFullMethodNames(String prefix) {
        HashSet<MethodObjectImpl> result = new HashSet<MethodObjectImpl>();
        SplitArrayObject<MethodObjectImpl> splitArrayObject = this.methodMapping;
        synchronized (splitArrayObject) {
            for (int i = 1024; i < this.methodMapping.size(); ++i) {
                MethodObjectImpl method = this.methodMapping.get(i);
                String name = method.getName() + "(" + method.getSignature() + ")";
                if (!name.startsWith(prefix)) continue;
                result.add(method);
            }
        }
        return result.toArray(new MethodObject[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodObject[] getMatchingClassAndMethodNames(String prefix) {
        int lastDot;
        HashSet<MethodObjectImpl> result = new HashSet<MethodObjectImpl>();
        if (prefix.indexOf(40) == -1) {
            lastDot = prefix.lastIndexOf(46);
            if (prefix.indexOf(46) != lastDot) {
                return new MethodObject[0];
            }
        } else {
            lastDot = prefix.lastIndexOf(46, prefix.indexOf(40));
        }
        if (lastDot == -1) {
            return new MethodObject[0];
        }
        String methodPrefix = prefix.substring(lastDot + 1);
        String classNameToMatch = prefix.substring(0, lastDot);
        InternedUTF8StringImpl internedClassName = this.intern(classNameToMatch);
        SplitArrayObject<MethodObjectImpl> splitArrayObject = this.methodMapping;
        synchronized (splitArrayObject) {
            for (int i = 1024; i < this.methodMapping.size(); ++i) {
                String name;
                MethodObjectImpl method = this.methodMapping.get(i);
                NonArrayClassObjectImpl clazz = method.getMethodClass();
                if (!(clazz instanceof NonArrayClassObjectImpl) || !clazz.getNameUTF().equals(internedClassName) || !(name = method.getName() + "(" + method.getSignature() + ")").startsWith(methodPrefix)) continue;
                result.add(method);
            }
        }
        return result.toArray(new MethodObject[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodObject[] getMatchingFullClassAndMethodNames(String prefix) {
        HashSet<MethodObjectImpl> result = new HashSet<MethodObjectImpl>();
        int lastDot = prefix.indexOf(40) == -1 ? prefix.lastIndexOf(46) : prefix.lastIndexOf(46, prefix.indexOf(40));
        if (lastDot == -1) {
            return new MethodObject[0];
        }
        String methodPrefix = prefix.substring(lastDot + 1);
        String fullClassName = prefix.substring(0, lastDot);
        int classDot = fullClassName.lastIndexOf(46);
        String classNameToMatch = fullClassName.substring(classDot + 1);
        String packageNameToMatch = classDot == -1 ? "" : prefix.substring(0, classDot);
        InternedUTF8StringImpl internedClassName = this.intern(classNameToMatch);
        InternedUTF8StringImpl internedPackageName = this.intern(packageNameToMatch);
        SplitArrayObject<MethodObjectImpl> splitArrayObject = this.methodMapping;
        synchronized (splitArrayObject) {
            for (int i = 1024; i < this.methodMapping.size(); ++i) {
                String name;
                MethodObjectImpl method = this.methodMapping.get(i);
                NonArrayClassObjectImpl clazz = method.getMethodClass();
                if (!(clazz instanceof NonArrayClassObjectImpl) || !((ClassObjectImpl)clazz).getPackageNameUTF().equals(internedPackageName) || !clazz.getNameUTF().equals(internedClassName) || !(name = method.getName() + "(" + method.getSignature() + ")").startsWith(methodPrefix)) continue;
                result.add(method);
            }
        }
        return result.toArray(new MethodObject[result.size()]);
    }

    @Override
    public String[] getMatchingLoaderNamePrefixes(String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1024; i < this.classLoaderMapping.size(); ++i) {
            ClassLoaderObjectImpl loader = this.classLoaderMapping.get(i);
            String name = loader.getName();
            if (!name.startsWith(prefix)) continue;
            result.add(name);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void notifyFinished() {
        this.classLoaderId2IndexMapping = null;
        this.classId2IndexMapping = null;
        this.methodId2IndexMapping = null;
        this.stackManager.notifyStackTracesFinished();
    }

    @Override
    public void write(PacketResourceWriter writer, ProgressReporter reporter) throws IOException {
        SessionAssociated current;
        int i;
        SystemInfoImpl systemInfo;
        MonitoringBoardInitialEventImpl board = this.session.getInitialMonitoringBoard();
        if (board != null) {
            board.write(writer);
        }
        if ((systemInfo = this.session.getSystemInfo()) != null) {
            systemInfo.write(writer);
        } else {
            writer.initializePacket((short)1);
            writer.finalizePacket();
        }
        for (i = 1024; i < this.classLoaderMapping.size(); ++i) {
            current = this.classLoaderMapping.get(i);
            ((ClassLoaderObjectImpl)current).write(writer);
            if (reporter == null || reporter.reportNext()) continue;
            return;
        }
        for (i = 1024; i < this.classMapping.size(); ++i) {
            current = this.classMapping.get(i);
            ((ClassObjectImpl)current).write(writer);
            if (reporter == null || reporter.reportNext()) continue;
            return;
        }
        for (i = 1024; i < this.methodMapping.size(); ++i) {
            current = this.methodMapping.get(i);
            ((MethodObjectImpl)current).write(writer);
            if (reporter == null || reporter.reportNext()) continue;
            return;
        }
        this.stackManager.write(writer, reporter);
        this.writeAnnotationDefinitions(writer);
        this.writeParameterDefinitions(writer);
        if (this.gcHistoryInitialValues != null) {
            this.gcHistoryInitialValues.write(writer);
        }
        this.hostManager.write(writer, reporter);
        this.serviceManager.write(writer, reporter);
    }

    @Override
    public void writeThreadInfo(PacketResourceWriter writer) throws IOException {
        int i;
        for (i = 0; i < this.threadInfos.length; ++i) {
            if (this.threadInfos[i] == null) continue;
            this.threadInfos[i].write(writer);
        }
        for (i = 0; i < this.fd2OpenEvent.size(); ++i) {
            if (this.fd2OpenEvent.get(i) == null) continue;
            this.fd2OpenEvent.get(i).write(writer);
        }
        for (ZipFileOpenEventImpl event : this.zipKey2OpenEvents.values()) {
            event.write(writer);
        }
        for (int i2 = 0; i2 < this.fd2SocketEvents.size(); ++i2) {
            if (this.fd2SocketEvents.get(i2) == null) continue;
            List<ProfilingPacketImpl> list = this.fd2SocketEvents.get(i2);
            for (int j = 0; j < list.size(); ++j) {
                list.get(j).write(writer);
            }
        }
        if (this.lastBoardEvent != null) {
            byte[] initial = this.session.getInitialMonitoringBoard().getContent();
            new MonitoringBoardDiffToInitialEventImpl(this.lastBoardEvent.getTimeStamp(), this.lastBoard, initial).write(writer);
        }
    }

    private void readClassLoaders(int nrOfClassLoaders, PacketResourceReader reader, ProgressReporter progressReporter) throws IOException {
        for (int i = 0; i < nrOfClassLoaders; ++i) {
            boolean hasNext = reader.nextPacket();
            assert (hasNext);
            this.addClassLoaderObject(reader, false);
            if (progressReporter == null) continue;
            progressReporter.reportNext();
        }
    }

    private void readClasses(int nrOfClasses, PacketResourceReader reader, ProgressReporter progressReporter) throws IOException {
        for (int i = 0; i < nrOfClasses; ++i) {
            int type = reader.nextPacketType();
            boolean hasNext = reader.nextPacket();
            assert (hasNext);
            switch (type) {
                case 400: {
                    this.addNonArrayClassObject(reader);
                    break;
                }
                case 401: {
                    this.addArrayClassObject(reader);
                    break;
                }
                case 403: {
                    this.addInternalClassObject(reader);
                    break;
                }
                case 402: {
                    this.addPrimitiveClassObject(reader);
                }
            }
            if (progressReporter == null) continue;
            progressReporter.reportNext();
        }
    }

    private void readMethods(int nrOfMethods, PacketResourceReader reader, ProgressReporter progressReporter) throws IOException {
        for (int i = 0; i < nrOfMethods; ++i) {
            boolean hasNext = reader.nextPacket();
            assert (hasNext);
            this.addMethodObjectFromExternal(reader);
            if (progressReporter == null) continue;
            progressReporter.reportNext();
        }
    }

    private void readMethodLocations(PacketResourceReader reader, ProgressReporter progressReporter) throws IOException {
        boolean hasNext = reader.nextPacket();
        assert (hasNext);
        int nrLocations = reader.readInt32();
        for (int i = 0; i < nrLocations; ++i) {
            int methodIndex = reader.readInt32();
            char lineNr = reader.readUint16();
            int locationIndex = this.stackManager.locationAddToHashSet(methodIndex, lineNr);
            if (lineNr != '\u0000') continue;
            MethodObjectImpl methodObject = this.methodMapping.get(methodIndex);
            methodObject.setMethodLocation(this.stackManager.getLocation(locationIndex));
        }
    }

    private void readStackTraces(int nrOfStackTraces, PacketResourceReader reader, ProgressReporter progressReporter) throws IOException {
        for (int i = 0; i < nrOfStackTraces; ++i) {
            boolean hasNext = reader.nextPacket();
            assert (hasNext);
            this.addStackTrace(reader);
            if (progressReporter == null) continue;
            progressReporter.reportNext();
        }
    }

    private void readAnnotationDefinitions(int nrOfAnnotationDefinitions, PacketResourceReader reader) throws IOException {
        for (int i = 0; i < nrOfAnnotationDefinitions; ++i) {
            boolean hasNext = reader.nextPacket();
            assert (hasNext);
            this.addThreadAnnotationKey(reader);
        }
    }

    private void readMethodParameterInfo(int nrOfSpecs, int nrOfDefinitionSets, PacketResourceReader reader) throws IOException {
        boolean hasNext;
        int i;
        ArrayList<MethodParameterSpecImpl> specs = new ArrayList<MethodParameterSpecImpl>(nrOfSpecs);
        for (i = 0; i < nrOfSpecs; ++i) {
            hasNext = reader.nextPacket();
            assert (hasNext);
            specs.add(MethodParameterSpecImpl.read(reader));
        }
        this.parameterDefinitions.addSpecs(specs);
        for (i = 0; i < nrOfDefinitionSets; ++i) {
            hasNext = reader.nextPacket();
            assert (hasNext);
            this.parameterDefinitions.addDefinition(i, MethodParametersDefinition.read(reader, this.parameterDefinitions));
        }
    }

    @Override
    public int getNrOfInternedStrings() {
        return this.stringTable.size();
    }

    @Override
    public InternedUTF8StringImpl intern(String string) {
        if (string.length() == 0) {
            return this.emptyString;
        }
        return this.intern(UTF8Util.modifiedUTF8(string));
    }

    @Override
    public InternedUTF8StringImpl intern(byte[] utfString) {
        if (utfString.length == 0) {
            return this.emptyString;
        }
        return this.stringTable.intern(new InternedUTF8StringImpl(utfString));
    }

    @Override
    public InternedUTF8StringImpl intern(UTF8String utfString) {
        if (utfString instanceof InternedUTF8StringImpl) {
            return (InternedUTF8StringImpl)utfString;
        }
        return this.stringTable.intern(new InternedUTF8StringImpl(utfString.getBytes()));
    }

    @Override
    public UTF8String create(byte[] data) {
        if (data.length == 0) {
            return this.emptyString;
        }
        return new UTF8StringImpl(data);
    }

    @Override
    public UTF8String create(String string) {
        if (string.length() == 0) {
            return this.emptyString;
        }
        return new UTF8StringImpl(UTF8Util.modifiedUTF8(string));
    }

    @Override
    public UTF8String getEmptyString() {
        return this.emptyString;
    }

    @Override
    public InternedUTF8StringImpl getInlinedAway() {
        return this.intern("<inlined away>");
    }

    @Override
    public InternedUTF8StringImpl getNoStack() {
        return this.intern("<no stack>");
    }

    @Override
    public UTF8String getDefaultPackage() {
        return this.intern("");
    }

    @Override
    public UTF8String getRootPackage() {
        return this.intern("<root>");
    }

    @Override
    public int getNrOfEntryEventTimes() {
        return this.nrOfEntryEventTimes;
    }

    @Override
    public void setNrOfEntryEventTimes(int nr) {
        this.nrOfEntryEventTimes = nr;
    }

    @Override
    public void addMethodParameterSpecifications(List<MethodParameterSpecImpl> specs) {
        this.specOffset = this.parameterDefinitions.getNrOfSpecs();
        this.parameterDefinitions.addSpecs(specs);
        this.definitionIndexOffset = this.parameterDefinitions.getNrOfDefinitions();
    }

    @Override
    public int getDefinitionIndex(int index) {
        return index + this.definitionIndexOffset;
    }

    @Override
    public void addMethodParameterDefinition(ResourceReader reader) throws IOException {
        int id = reader.readInt32();
        int index = id + this.definitionIndexOffset;
        new MethodParameterDefinitionEventImpl(index, this.specOffset, reader, this.parameterDefinitions);
    }

    @Override
    public int getSpecificationOffset() {
        return this.specOffset;
    }

    private void writeAnnotationDefinitions(PacketResourceWriter writer) throws IOException {
        for (int i = 0; i < this.annotationKeys.length; ++i) {
            if (this.annotationKeys[i] == null) continue;
            writer.initializePacket((short)410);
            writer.writeInt16((short)i);
            writer.writeUTF(this.annotationKeys[i]);
            if (this.annotationDescriptions[i] == null) {
                writer.writeUTF(this.intern(""));
            } else {
                writer.writeUTF(this.annotationDescriptions[i]);
            }
            writer.finalizePacket();
        }
    }

    private void writeParameterDefinitions(PacketResourceWriter writer) throws IOException {
        this.parameterDefinitions.write(writer);
    }

    @Override
    public void addGCHistoryInitialValues(ResourceReader reader) throws IOException {
        this.gcHistoryInitialValues = new GCHistoryInitialValuesImpl(reader);
    }

    @Override
    public GCHistoryInitialValues getGcHistoryInitialValues() {
        return this.gcHistoryInitialValues;
    }

    @Override
    public boolean isProfilingMethod(NonArrayClassObject clazz, UTF8String name, UTF8String signature, UTF8String returnType) {
        if (!clazz.getClassLoader().isBootstrapClassLoader()) {
            return false;
        }
        for (int i = 0; i < this.profilingMethodSpecs.length; i += 5) {
            if (!name.equals(this.profilingMethodSpecs[i + 2]) || !signature.equals(this.profilingMethodSpecs[i + 3]) || !returnType.equals(this.profilingMethodSpecs[i + 4]) || !clazz.getNameUTF().equals(this.profilingMethodSpecs[i + 1]) || !clazz.getPackageNameUTF().equals(this.profilingMethodSpecs[i])) continue;
            return true;
        }
        return false;
    }

    private UTF8StringImpl[] getProfilingMethods() {
        return new UTF8StringImpl[]{this.intern("java.lang"), this.intern("Thread"), this.intern("notifyThreadNameChanged0"), this.intern(""), this.intern("void"), this.intern("java.lang"), this.intern("Thread"), this.intern("annotationChanged"), this.intern("int,java.lang.String"), this.intern("void"), this.intern("java.lang"), this.intern("Thread"), this.intern("annotationsCleared"), this.intern(""), this.intern("void")};
    }

    @Override
    public long getLastTbsTimeStamp() {
        return this.lastTbsTimeStamp;
    }

    @Override
    public void setLastTbsTimeStamp(long timeStamp) {
        this.lastTbsTimeStamp = timeStamp;
    }

    @Override
    public long getAverageTbsSampleDiff() {
        if (this.tbsSampleCount > 0L) {
            return this.tbsElapsedTime / this.tbsSampleCount;
        }
        return 10000000L;
    }

    @Override
    public void resetAverageTbsSampleDiff() {
        this.tbsElapsedTime = 0L;
        this.tbsSampleCount = 0L;
    }

    @Override
    public void updateAverageTbsSampleDiff(long diff) {
        ++this.tbsSampleCount;
        if (diff > 0L) {
            this.tbsElapsedTime += diff;
        }
    }

    @Override
    public void addFileOpenEvent(FileOpenEventImpl openEvent) {
        int fd = (int)openEvent.getFd();
        while (fd >= this.fd2OpenEvent.size()) {
            this.fd2OpenEvent.add(null);
        }
        this.fd2OpenEvent.set(fd, openEvent);
    }

    @Override
    public void addZipFileOpenEvent(ZipFileOpenEventImpl zipOpenEvent) {
        ZipKey key = new ZipKey(zipOpenEvent.getFd(), zipOpenEvent.getIndex());
        ZipFileOpenEventImpl old = this.zipKey2OpenEvents.put(key, zipOpenEvent);
        assert (old == null);
    }

    @Override
    public void removeFileOpenEvent(long fd) {
        if (fd < 0L || fd >= (long)this.fd2OpenEvent.size()) {
            return;
        }
        this.fd2OpenEvent.set((int)fd, null);
    }

    @Override
    public void removeZipFileOpenEvent(long fd, int index) {
        ZipKey key = new ZipKey(fd, index);
        this.zipKey2OpenEvents.remove(key);
    }

    @Override
    public void clearFileOpenEvents() {
        this.zipKey2OpenEvents.clear();
        this.fd2OpenEvent.clear();
    }

    @Override
    public long createUniqueFileId() {
        return ++this.currentUniqueFileId;
    }

    @Override
    public long getUniqueFileId(long fd) {
        if (fd < 0L || fd >= (long)this.fd2OpenEvent.size()) {
            return this.createUniqueFileId();
        }
        FileOpenEventImpl openEvent = this.fd2OpenEvent.get((int)fd);
        return openEvent == null ? this.createUniqueFileId() : openEvent.getId();
    }

    @Override
    public long getUniqueZipFileId(long fd, int index) {
        if (fd < 0L) {
            return this.createUniqueFileId();
        }
        ZipFileOpenEventImpl openEvent = null;
        ZipKey key = new ZipKey(fd, index);
        openEvent = this.zipKey2OpenEvents.get(key);
        return openEvent == null ? this.createUniqueFileId() : openEvent.getId();
    }

    @Override
    public PackageName getInlinedAwayPackageName() {
        return this.inlinedAwayPackage;
    }

    @Override
    public PackageName getNoPackageName() {
        return this.noPackage;
    }

    @Override
    public PackageNameImpl getPackageName(UTF8String name, boolean includesSubPackages) {
        int type = 0;
        if (name.equals(this.getRootPackage())) {
            type = 1;
        } else if (name.equals(this.getDefaultPackage())) {
            type = 2;
        } else if (name.equals(this.getInlinedAway())) {
            type = 4;
        } else if (name.equals(this.getNoStack())) {
            type = 3;
        }
        return this.packageTable.intern(new PackageNameImpl(name, includesSubPackages, (byte)type, this));
    }

    @Override
    public PackageNameImpl getPackageName(UTF8String name, boolean includesSubPackages, byte type) {
        return this.packageTable.intern(new PackageNameImpl(name, includesSubPackages, type, this));
    }

    @Override
    public PackageName getRootPackageName() {
        return this.rootPackage;
    }

    @Override
    public PackageName getDefaultPackageName() {
        return this.defaultPackage;
    }

    @Override
    public void setNrOfHeartBeatPackets(long nrOfHeartBeatPackets) {
        this.nrOfHeartBeatPackets = nrOfHeartBeatPackets;
    }

    @Override
    public long getNrOfHeartBeatPackets() {
        return this.nrOfHeartBeatPackets;
    }

    @Override
    public void addSocketOpenEvent(SocketOpenEvent openEvent) {
        this.addSocketEvent(openEvent.getFd(), (ProfilingPacketImpl)((Object)openEvent), true);
        assert (this.fd2SocketEvents.get(openEvent.getFd()).size() == 1);
    }

    @Override
    public void addSocketBindEvent(SocketBindEvent bindEvent) {
        this.addSocketEvent(bindEvent.getFd(), (ProfilingPacketImpl)((Object)bindEvent), false);
        assert (this.fd2SocketEvents.get(bindEvent.getFd()).size() >= 1 || this.fd2SocketEvents.get(bindEvent.getFd()).size() <= 3);
    }

    @Override
    public void addSocketConnectEvent(SocketConnectEvent connectEvent) {
        this.addSocketEvent(connectEvent.getFd(), (ProfilingPacketImpl)((Object)connectEvent), false);
        assert (this.fd2SocketEvents.get(connectEvent.getFd()).size() >= 1 || this.fd2SocketEvents.get(connectEvent.getFd()).size() <= 3);
    }

    private void addSocketEvent(int fd, ProfilingPacketImpl event, boolean clear) {
        while (fd >= this.fd2SocketEvents.size()) {
            this.fd2SocketEvents.add(null);
        }
        List<ProfilingPacketImpl> list = this.fd2SocketEvents.get(fd);
        if (list == null) {
            list = new ArrayList<ProfilingPacketImpl>();
        }
        if (clear) {
            list.clear();
        }
        list.add(event);
        this.fd2SocketEvents.set(fd, list);
    }

    @Override
    public void removeSocketEvents(int fd) {
        if (fd < 0 || fd >= this.fd2SocketEvents.size()) {
            return;
        }
        this.fd2SocketEvents.set(fd, null);
    }

    @Override
    public void clearSocketEvents() {
        this.fd2SocketEvents.clear();
    }

    @Override
    public long createUniqueSocketId() {
        return ++this.currentUniqueSocketId;
    }

    @Override
    public long getUniqueSocketId(int fd) {
        long id;
        if (fd < 0 || fd >= this.fd2SocketEvents.size()) {
            return this.createUniqueSocketId();
        }
        List<ProfilingPacketImpl> list = this.fd2SocketEvents.get(fd);
        if (list == null || list.isEmpty()) {
            return this.createUniqueSocketId();
        }
        ProfilingPacketImpl event = list.get(0);
        if (event instanceof SocketOpenEvent) {
            id = ((SocketOpenEvent)((Object)event)).getId();
        } else if (event instanceof SocketBindEvent) {
            id = ((SocketBindEvent)((Object)event)).getId();
        } else if (event instanceof SocketConnectEvent) {
            id = ((SocketConnectEvent)((Object)event)).getId();
        } else {
            throw new IllegalStateException("Unknown socket event: " + event.toString());
        }
        return id;
    }

    @Override
    public HostNameManager getHostNameManager() {
        return this.hostManager;
    }

    @Override
    public void addHostNameMapping(HostLookupEvent mapping) {
        this.hostManager.addMapping(mapping.getHostName(), mapping.getAddress());
    }

    @Override
    public NetworkServiceNameManagerImpl getNetworkServiceNameManager() {
        return this.serviceManager;
    }

    public void addNetworkServiceMapping(ServiceDiscoveryEvent service) {
        this.serviceManager.addService(service);
    }

    @Override
    public FileOpenEvent[] getOpenEvents() {
        ArrayList<ZipFileOpenEventImpl> result = new ArrayList<ZipFileOpenEventImpl>(this.zipKey2OpenEvents.values());
        for (FileOpenEvent fileOpenEvent : this.fd2OpenEvent) {
            if (fileOpenEvent == null) continue;
            result.add((ZipFileOpenEventImpl)fileOpenEvent);
        }
        return result.toArray(new FileOpenEvent[result.size()]);
    }

    @Override
    public Object[] getEvents() {
        ArrayList<ProfilingPacketImpl> result = new ArrayList<ProfilingPacketImpl>();
        for (List<ProfilingPacketImpl> events : this.fd2SocketEvents) {
            if (events == null) continue;
            result.addAll(events);
        }
        Collections.sort(result, new Comparator<Object>(){

            private long getId(Object obj) {
                if (obj instanceof SocketOpenEvent) {
                    return ((SocketOpenEvent)obj).getId();
                }
                if (obj instanceof SocketBindEvent) {
                    return ((SocketBindEvent)obj).getId();
                }
                if (obj instanceof SocketConnectEvent) {
                    return ((SocketConnectEvent)obj).getId();
                }
                throw new IllegalArgumentException("Unknown class: " + obj.getClass() + ":" + obj.toString());
            }

            @Override
            public int compare(Object o1, Object o2) {
                long id2;
                long id1 = this.getId(o1);
                return id1 == (id2 = this.getId(o2)) ? 0 : (id1 < id2 ? -1 : 1);
            }
        });
        return result.toArray();
    }

    @Override
    public long getNextMptId() {
        return ++this.mptId;
    }

    @Override
    public synchronized void addJitCompilationEvent(JitEventMethodCompilationImpl compilationEvent) {
        int length = this.jitCompilations.length;
        int index = compilationEvent.getCompileId() << 1 | (compilationEvent.isOSR() ? 1 : 0);
        if (index >= length) {
            JitEventMethodCompilationImpl[] copy = new JitEventMethodCompilationImpl[length + (length >> 1)];
            System.arraycopy(this.jitCompilations, 0, copy, 0, length);
            this.jitCompilations = copy;
            this.addJitCompilationEvent(compilationEvent);
            return;
        }
        assert (null == this.jitCompilations[index] || this.jitCompilations[index].compilationFailed());
        this.jitCompilations[index] = compilationEvent;
    }

    @Override
    public synchronized JitEventMethodCompilationImpl getJitCompilationEvent(int compileId, boolean isOSR) {
        int length;
        int index = compileId << 1 | (isOSR ? 1 : 0);
        if (index >= (length = this.jitCompilations.length)) {
            return null;
        }
        return this.jitCompilations[index];
    }

    @Override
    public boolean useGlobalStringTable() {
        return useGlobalStringTable;
    }

    @Override
    public void popAllEntryEvents() {
        for (ThreadInfoImpl info : this.threadInfos) {
            if (info == null) continue;
            info.undoEntryStackChanges();
            while (info.getEntryEventTop() >= 0) {
                info.popMethodParameterEntryEvent();
            }
        }
    }

    @Override
    public ProfilingSession getSession() {
        return this.session;
    }

    @Override
    public void setLastMonitoringBoard(MonitoringBoardInitialEventImpl event) {
        this.lastBoard = (byte[])event.getContent().clone();
        this.lastBoardEvent = event;
    }

    @Override
    public void setLastMonitoringBoard(MonitoringBoardDiffToInitialEventImpl event) {
        this.lastBoard = event.getContent();
        this.lastBoardEvent = event;
    }

    @Override
    public void setLastMonitoringBoard(MonitoringBoardDiffToPrevEventImpl event) {
        event.applyDiff(this.lastBoard);
        this.lastBoardEvent = event;
    }

    @Override
    public byte[] getLastBoardContent() {
        return this.lastBoard;
    }

    public String getDefaultTimeZone() {
        return this.defaultTimeZone;
    }

    public void setDefaultTimeZone(String id) {
        this.defaultTimeZone = id;
    }

    public String getUserTimeZone() {
        return this.userTimeZone;
    }

    public void setUserTimeZone(String id) {
        this.userTimeZone = id;
    }

    @Override
    public void setLastConcurrentGcEnd(long timeStamp) {
        this.lastConcGcEndTimeStamp = timeStamp;
    }

    @Override
    public long getLastConcurrentGcEnd() {
        return this.lastConcGcEndTimeStamp;
    }

    private class ZipKey {
        public final long fd;
        public final int index;

        public ZipKey(long fd, int index) {
            this.fd = fd;
            this.index = index;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ZipKey)) {
                return false;
            }
            ZipKey other = (ZipKey)obj;
            return other.index == this.index && other.fd == this.fd;
        }

        public int hashCode() {
            return (int)this.fd ^ this.index;
        }
    }
}

