/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.util;

import com.sap.jvm.profiling.impl.core.type.PackageNameImpl;

public class PackageNameTable {
    private PackageNameImpl[] entries;
    private int nrOfEntries;
    private int resizeLimit;
    private final double maxLoadFactor;

    public PackageNameTable(double loadFactor) {
        if (loadFactor < 0.1 || loadFactor > 0.9) {
            throw new IllegalArgumentException("Illegal load factor of " + loadFactor);
        }
        this.maxLoadFactor = loadFactor;
        this.entries = new PackageNameImpl[128];
        this.nrOfEntries = 0;
        this.resizeLimit = (int)((double)this.entries.length * loadFactor);
    }

    public PackageNameTable() {
        this(0.75);
    }

    public synchronized int size() {
        return this.nrOfEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageNameImpl intern(PackageNameImpl toIntern) {
        int hash = toIntern.hashCode();
        PackageNameTable packageNameTable = this;
        synchronized (packageNameTable) {
            int mask = this.entries.length - 1;
            for (int i = 0; i < this.entries.length; ++i) {
                int index = hash + i & mask;
                PackageNameImpl currEntry = this.entries[index];
                if (currEntry == null) {
                    this.add(index, toIntern);
                    return toIntern;
                }
                if (!currEntry.equals(toIntern)) continue;
                return currEntry;
            }
        }
        assert (false);
        return null;
    }

    private void add(int index, PackageNameImpl toAdd) {
        this.entries[index] = toAdd;
        ++this.nrOfEntries;
        if (this.nrOfEntries > this.resizeLimit) {
            PackageNameImpl[] oldEntries = this.entries;
            this.nrOfEntries = 0;
            this.entries = new PackageNameImpl[oldEntries.length * 2];
            this.resizeLimit = (int)((double)this.entries.length * this.maxLoadFactor);
            for (int i = 0; i < oldEntries.length; ++i) {
                PackageNameImpl oldEntry = oldEntries[i];
                if (oldEntry == null) continue;
                this.intern(oldEntry);
            }
        }
    }
}

