/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.util;

import com.sap.jvm.profiling.core.ProfilingVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public final class ProfilingFileInputStream
extends InputStream {
    private static final int SNP_FILE_ENCODING = 8;
    public static final int SNP_FILE_MAGIC_NUMBER = -559038737;
    public static final int CHUNKED_FILE_ENCODING = 1;
    public static final int PLAIN_FILE_ENCODING = 2;
    public static final int PLAIN_FILE_WITH_HEADER_ENCODING = 3;
    public static final int CHUNKED_FILE_WITH_HEADER_ENCODING = 5;
    public static final int PLAIN_FILE_WITH_HEADER_MAGIC = -1091581234;
    public static final int CHUNK_HEADER_SIZE = 4;
    private final RandomAccessFile file;
    private long[] mappingFileChunkOffsets;
    private long[] eventFileChunkOffsets;
    private int[] mappingFileChunkLengths;
    private int[] eventFileChunkLengths;
    private boolean isReadMap;
    private int currentIndex;
    private int currentOffset;
    private int currentLength;
    private int encoding;
    private long nrOfReadBytes;
    private Object lockNrOfReadBytes;
    private long fileLength;
    private ProfilingVersion version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isProfilingContent(String filename) {
        RandomAccessFile file = null;
        try {
            int magic2;
            file = new RandomAccessFile(filename, "r");
            int encoding = file.read();
            if (encoding == 8) {
                int magicNumber = file.readInt();
                if (magicNumber != -559038737) {
                    boolean bl = false;
                    return bl;
                }
                short hLength = file.readShort();
                if (hLength < 0) {
                    boolean ex = false;
                    return ex;
                }
                short majorV = file.readShort();
                short minorV = file.readShort();
                short microV = file.readShort();
                if (majorV < 0 && minorV < 0 && microV < 0) {
                    boolean bl = false;
                    return bl;
                }
                majorV = file.readShort();
                minorV = file.readShort();
                microV = file.readShort();
                if (majorV < 0 && minorV < 0 && microV < 0) {
                    boolean bl = false;
                    return bl;
                }
                int nrOfSnapshots = file.readInt();
                if (nrOfSnapshots < 0) {
                    boolean ex = false;
                    return ex;
                }
                int nrOfResources = file.readInt();
                if (nrOfResources < 0) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            if (encoding == 1 || encoding == 5) {
                if (encoding == 5 && (magic2 = file.readInt()) != -1091581234) {
                    boolean hLength = false;
                    return hLength;
                }
                magic2 = 1;
                return magic2 != 0;
            }
            if (encoding == 2) {
                boolean magic2 = true;
                return magic2;
            }
            if (encoding == 3) {
                magic2 = file.readInt();
                if (magic2 != -1091581234) {
                    boolean ex = false;
                    return ex;
                }
                boolean ex = true;
                return ex;
            }
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException ex) {
                    return false;
                }
            }
        }
        return false;
    }

    public ProfilingFileInputStream(String fileName) throws IOException {
        this.file = new RandomAccessFile(fileName, "r");
        this.nrOfReadBytes = 1L;
        this.lockNrOfReadBytes = new Object();
        this.fileLength = this.file.length();
        this.encoding = this.file.read();
        if (this.encoding == 1 || this.encoding == 5) {
            if (this.encoding == 5) {
                int magic = this.file.readInt();
                if (magic != -1091581234) {
                    throw new IOException(fileName + " is not a valid profiling file");
                }
                int majorVersion = this.file.readUnsignedShort();
                int minorVersion = this.file.readUnsignedShort();
                int microVersion = this.file.readUnsignedShort();
                this.version = new ProfilingVersion(majorVersion, minorVersion, microVersion);
                this.incrementNrOfReadBytes(10L);
            }
            this.createHeaderInformation();
            this.isReadMap = true;
            this.currentIndex = 0;
            this.file.seek(this.mappingFileChunkOffsets[this.currentIndex] + 4L);
            this.currentOffset = 4;
            this.currentLength = this.mappingFileChunkLengths[this.currentIndex];
        } else if (this.encoding != 2) {
            if (this.encoding == 3) {
                int magic = this.file.readInt();
                if (magic != -1091581234) {
                    throw new IOException(fileName + " is not a valid profiling file (wrong magic header)");
                }
                int headerSize = this.file.readUnsignedShort();
                int majorVersion = this.file.readUnsignedShort();
                int minorVersion = this.file.readUnsignedShort();
                int microVersion = this.file.readUnsignedShort();
                this.file.seek(headerSize);
                this.incrementNrOfReadBytes(headerSize - 1);
                this.version = new ProfilingVersion(majorVersion, minorVersion, microVersion);
            } else {
                throw new IOException(fileName + " is not a valid profiling file (invalid encoding " + this.encoding + ")");
            }
        }
    }

    @Override
    public int read() throws IOException {
        if (this.encoding == 1 || this.encoding == 5) {
            if (this.currentOffset == this.currentLength && !this.getNextFileChunk()) {
                return -1;
            }
            ++this.currentOffset;
        }
        this.incrementNrOfReadBytes(1L);
        return this.file.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.encoding == 1 || this.encoding == 5) {
            if (this.currentOffset == this.currentLength && !this.getNextFileChunk()) {
                return -1;
            }
            int numberBytesToRead = len < this.currentLength - this.currentOffset ? len : this.currentLength - this.currentOffset;
            int retValue = this.file.read(b, off, numberBytesToRead);
            this.incrementNrOfReadBytes(retValue);
            if (retValue != -1) {
                this.currentOffset += retValue;
            }
            return retValue;
        }
        int retValue = this.file.read(b, off, len);
        this.incrementNrOfReadBytes(retValue);
        return retValue;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
        this.mappingFileChunkLengths = null;
        this.mappingFileChunkOffsets = null;
        this.eventFileChunkLengths = null;
        this.eventFileChunkOffsets = null;
    }

    private void createHeaderInformation() throws IOException {
        int i;
        long increment = 0L;
        int numberMappingFileChunks = this.file.readInt();
        int numberEventFileChunks = this.file.readInt();
        increment += 8L;
        this.mappingFileChunkOffsets = new long[numberMappingFileChunks];
        this.eventFileChunkOffsets = new long[numberEventFileChunks];
        this.mappingFileChunkLengths = new int[numberMappingFileChunks];
        this.eventFileChunkLengths = new int[numberEventFileChunks];
        for (i = 0; i < numberMappingFileChunks; ++i) {
            this.mappingFileChunkOffsets[i] = this.file.readLong();
            this.mappingFileChunkLengths[i] = this.file.readInt();
        }
        increment += (long)(numberMappingFileChunks * 12);
        for (i = 0; i < numberEventFileChunks; ++i) {
            this.eventFileChunkOffsets[i] = this.file.readLong();
            this.eventFileChunkLengths[i] = this.file.readInt();
        }
        this.incrementNrOfReadBytes(increment += (long)(numberEventFileChunks * 12));
    }

    private boolean getNextFileChunk() throws IOException {
        if (this.isReadMap) {
            ++this.currentIndex;
            if (this.currentIndex == this.mappingFileChunkOffsets.length) {
                this.isReadMap = false;
                this.currentIndex = -1;
            } else {
                this.file.seek(this.mappingFileChunkOffsets[this.currentIndex] + 4L);
                this.currentOffset = 4;
                this.currentLength = this.mappingFileChunkLengths[this.currentIndex];
            }
        }
        if (!this.isReadMap) {
            ++this.currentIndex;
            if (this.currentIndex >= this.eventFileChunkOffsets.length) {
                return false;
            }
            this.file.seek(this.eventFileChunkOffsets[this.currentIndex]);
            int offset = this.file.readInt();
            this.incrementNrOfReadBytes(4L);
            this.currentOffset = 4;
            this.currentLength = this.eventFileChunkLengths[this.currentIndex];
            if (this.currentIndex == 0) {
                int skipped;
                for (int toSkip = offset; toSkip > 0; toSkip -= skipped) {
                    skipped = this.file.skipBytes(toSkip);
                    if (skipped > 0) continue;
                    throw new IOException("Skip failed with " + skipped);
                }
                this.currentOffset += offset;
            }
        }
        return true;
    }

    public long getLength() {
        return this.fileLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNrOfReadBytes() {
        Object object = this.lockNrOfReadBytes;
        synchronized (object) {
            return this.nrOfReadBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementNrOfReadBytes(long increment) {
        Object object = this.lockNrOfReadBytes;
        synchronized (object) {
            this.nrOfReadBytes += increment;
        }
    }

    public ProfilingVersion getVersion() {
        return this.version;
    }

    public boolean usesChunkedFile() {
        return this.encoding == 1 || this.encoding == 5;
    }
}

