/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public final class ProfilingInputStream
extends InputStream {
    private InputStream dataProvider;
    private Inflater inflater;
    private byte[] inputBuffer;
    private int inputBufferLen;
    private boolean closed = false;
    private byte[] singleByteBuf = new byte[1];

    public ProfilingInputStream(InputStream dataProvider) {
        if (dataProvider == null) {
            throw new NullPointerException();
        }
        this.dataProvider = dataProvider;
        this.inputBuffer = new byte[2048];
        this.inflater = new Inflater();
    }

    @Override
    public int read() throws IOException {
        return this.read(this.singleByteBuf, 0, 1) == -1 ? -1 : this.singleByteBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        try {
            int inflatedBytes;
            while ((inflatedBytes = this.inflater.inflate(b, off, len)) == 0) {
                if (this.inflater.finished() || this.inflater.needsDictionary()) {
                    int bytesLeft = this.inflater.getRemaining();
                    this.inflater.reset();
                    if (bytesLeft > 0) {
                        this.inflater.setInput(this.inputBuffer, this.inputBufferLen - bytesLeft, bytesLeft);
                    }
                }
                if (!this.inflater.needsInput()) continue;
                this.inputBufferLen = this.dataProvider.read(this.inputBuffer, 0, this.inputBuffer.length);
                if (this.inputBufferLen == -1) {
                    return -1;
                }
                this.inflater.setInput(this.inputBuffer, 0, this.inputBufferLen);
            }
            return inflatedBytes;
        }
        catch (DataFormatException ex) {
            ZipException zipException = new ZipException();
            zipException.initCause(ex);
            throw zipException;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.inflater.end();
            this.dataProvider.close();
            this.closed = true;
        }
    }

    public static interface DataProvider {
        public int read(byte[] var1, int var2, int var3) throws IOException;

        public void close() throws IOException;
    }
}

