/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.util;

import com.sap.jvm.profiling.impl.core.type.InternedUTF8StringImpl;

public final class UTF8StringTable {
    private InternedUTF8StringImpl[] entries;
    private int nrOfEntries;
    private int resizeLimit;
    private long overallLength;
    private final double maxLoadFactor;

    public UTF8StringTable(double loadFactor) {
        if (loadFactor < 0.1 || loadFactor > 0.9) {
            throw new IllegalArgumentException("Illegal load factor of " + loadFactor);
        }
        this.maxLoadFactor = loadFactor;
        this.entries = new InternedUTF8StringImpl[128];
        this.nrOfEntries = 0;
        this.resizeLimit = (int)((double)this.entries.length * loadFactor);
    }

    public UTF8StringTable() {
        this(0.75);
    }

    public synchronized int size() {
        return this.nrOfEntries;
    }

    public synchronized double getAverageLength() {
        if (this.nrOfEntries == 0) {
            return 0.0;
        }
        return 1.0 * (double)this.overallLength / (double)this.nrOfEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternedUTF8StringImpl intern(InternedUTF8StringImpl toIntern) {
        int hash = toIntern.hashCode();
        UTF8StringTable uTF8StringTable = this;
        synchronized (uTF8StringTable) {
            int mask = this.entries.length - 1;
            for (int i = 0; i < this.entries.length; ++i) {
                int index = hash + i & mask;
                InternedUTF8StringImpl currEntry = this.entries[index];
                if (currEntry == null) {
                    this.add(index, toIntern);
                    return toIntern;
                }
                if (!this.equals(currEntry, toIntern)) continue;
                return currEntry;
            }
        }
        assert (false);
        return null;
    }

    private boolean equals(InternedUTF8StringImpl string1, InternedUTF8StringImpl string2) {
        if (string1.length() != string2.length()) {
            return false;
        }
        byte[] array1 = string1.getBytes();
        byte[] array2 = string2.getBytes();
        for (int i = string1.length() - 1; i >= 0; --i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    private void add(int index, InternedUTF8StringImpl toAdd) {
        this.entries[index] = toAdd;
        ++this.nrOfEntries;
        this.overallLength += (long)toAdd.length();
        if (this.nrOfEntries > this.resizeLimit) {
            InternedUTF8StringImpl[] oldEntries = this.entries;
            this.nrOfEntries = 0;
            this.entries = new InternedUTF8StringImpl[oldEntries.length * 2];
            this.resizeLimit = (int)((double)this.entries.length * this.maxLoadFactor);
            for (int i = 0; i < oldEntries.length; ++i) {
                InternedUTF8StringImpl oldEntry = oldEntries[i];
                if (oldEntry == null) continue;
                this.intern(oldEntry);
            }
        }
    }
}

