/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.memory;

public final class AgeRange {
    public static final int MAX_AGE = Integer.MAX_VALUE;
    private final int lower;
    private final int upper;

    public AgeRange(int lower, int upper) {
        if (lower < 0) {
            throw new IllegalArgumentException("'lower' (" + lower + ") is < 0");
        }
        if (upper < lower) {
            throw new IllegalArgumentException("'lower' (" + lower + ") is > 'upper' (" + upper + ")");
        }
        this.lower = lower;
        this.upper = upper;
    }

    public int getLowerLimit() {
        return this.lower;
    }

    public int getUpperLimit() {
        return this.upper;
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(AgeRange.class)) {
            return false;
        }
        AgeRange tmpRange = (AgeRange)obj;
        return tmpRange.lower == this.lower && tmpRange.upper == this.upper;
    }

    public int hashCode() {
        return this.lower ^ this.upper;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("AgeRange(");
        buffer.append(this.lower);
        buffer.append('-');
        buffer.append(this.upper);
        buffer.append(')');
        return buffer.toString();
    }
}

